/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class DestConfig
implements Writeable,
ToXContentObject {
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ParseField PIPELINE = new ParseField("pipeline", new String[0]);
    public static final ConstructingObjectParser<DestConfig, Void> STRICT_PARSER = DestConfig.createParser(false);
    public static final ConstructingObjectParser<DestConfig, Void> LENIENT_PARSER = DestConfig.createParser(true);
    private final String index;
    private final String pipeline;

    private static ConstructingObjectParser<DestConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser("data_frame_config_dest", lenient, args -> new DestConfig((String)args[0], (String)args[1]));
        parser.declareString(ConstructingObjectParser.constructorArg(), INDEX);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), PIPELINE);
        return parser;
    }

    public DestConfig(String index, String pipeline) {
        this.index = ExceptionsHelper.requireNonNull(index, INDEX.getPreferredName());
        this.pipeline = pipeline;
    }

    public DestConfig(StreamInput in) throws IOException {
        this.index = in.readString();
        this.pipeline = in.getVersion().onOrAfter(Version.V_7_3_0) ? in.readOptionalString() : null;
    }

    public String getIndex() {
        return this.index;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.index.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"dest.index must not be empty", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void checkForDeprecations(String id, NamedXContentRegistry namedXContentRegistry, Consumer<DeprecationIssue> onDeprecation) {
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalString(this.pipeline);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), this.index);
        if (this.pipeline != null) {
            builder.field(PIPELINE.getPreferredName(), this.pipeline);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DestConfig that = (DestConfig)other;
        return Objects.equals(this.index, that.index) && Objects.equals(this.pipeline, that.pipeline);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.pipeline);
    }

    public static DestConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (DestConfig)LENIENT_PARSER.apply(parser, null) : (DestConfig)STRICT_PARSER.apply(parser, null);
    }
}

