/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.concurrent.FutureUtils;

public class NettyListener
implements BiConsumer<Void, Exception>,
ChannelPromise {
    private final ChannelPromise promise;

    private NettyListener(ChannelPromise promise) {
        this.promise = promise;
    }

    @Override
    public void accept(Void v, Exception exception) {
        if (exception == null) {
            this.promise.setSuccess();
        } else {
            this.promise.setFailure(exception);
        }
    }

    @Override
    public Channel channel() {
        return this.promise.channel();
    }

    @Override
    public ChannelPromise setSuccess(Void result) {
        return this.promise.setSuccess(result);
    }

    @Override
    public boolean trySuccess(Void result) {
        return this.promise.trySuccess(result);
    }

    @Override
    public ChannelPromise setSuccess() {
        return this.promise.setSuccess();
    }

    @Override
    public boolean trySuccess() {
        return this.promise.trySuccess();
    }

    @Override
    public ChannelPromise setFailure(Throwable cause) {
        return this.promise.setFailure(cause);
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        return this.promise.tryFailure(cause);
    }

    @Override
    public boolean setUncancellable() {
        return this.promise.setUncancellable();
    }

    @Override
    public boolean isSuccess() {
        return this.promise.isSuccess();
    }

    @Override
    public boolean isCancellable() {
        return this.promise.isCancellable();
    }

    @Override
    public Throwable cause() {
        return this.promise.cause();
    }

    @Override
    public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        return this.promise.addListener(listener);
    }

    @Override
    @SafeVarargs
    public final ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        return this.promise.addListeners(listeners);
    }

    @Override
    public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        return this.promise.removeListener(listener);
    }

    @Override
    @SafeVarargs
    public final ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        return this.promise.removeListeners(listeners);
    }

    @Override
    public ChannelPromise sync() throws InterruptedException {
        return this.promise.sync();
    }

    @Override
    public ChannelPromise syncUninterruptibly() {
        return this.promise.syncUninterruptibly();
    }

    @Override
    public ChannelPromise await() throws InterruptedException {
        return this.promise.await();
    }

    @Override
    public ChannelPromise awaitUninterruptibly() {
        return this.promise.awaitUninterruptibly();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.promise.await(timeout, unit);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.promise.await(timeoutMillis);
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.promise.awaitUninterruptibly(timeout, unit);
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.promise.awaitUninterruptibly(timeoutMillis);
    }

    @Override
    public Void getNow() {
        return (Void)this.promise.getNow();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return FutureUtils.cancel(this.promise);
    }

    @Override
    public boolean isCancelled() {
        return this.promise.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.promise.isDone();
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        return (Void)this.promise.get();
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (Void)this.promise.get(timeout, unit);
    }

    @Override
    public boolean isVoid() {
        return this.promise.isVoid();
    }

    @Override
    public ChannelPromise unvoid() {
        return this.promise.unvoid();
    }

    public static NettyListener fromBiConsumer(BiConsumer<Void, Exception> biConsumer, Channel channel) {
        if (biConsumer instanceof NettyListener) {
            return (NettyListener)biConsumer;
        }
        ChannelPromise channelPromise = channel.newPromise();
        channelPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            Throwable cause = f.cause();
            if (cause == null) {
                biConsumer.accept(null, null);
            } else if (cause instanceof Error) {
                ExceptionsHelper.maybeDieOnAnotherThread(cause);
                biConsumer.accept(null, new Exception(cause));
            } else {
                biConsumer.accept(null, (Exception)cause);
            }
        }));
        return new NettyListener(channelPromise);
    }

    public static NettyListener fromChannelPromise(ChannelPromise channelPromise) {
        if (channelPromise instanceof NettyListener) {
            return (NettyListener)channelPromise;
        }
        return new NettyListener(channelPromise);
    }
}

