/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class FollowParameters
implements Writeable,
ToXContentObject {
    private static final TimeValue RETRY_DELAY_MAX = TimeValue.timeValueMinutes(5L);
    public static final ParseField MAX_READ_REQUEST_OPERATION_COUNT = new ParseField("max_read_request_operation_count", new String[0]);
    public static final ParseField MAX_WRITE_REQUEST_OPERATION_COUNT = new ParseField("max_write_request_operation_count", new String[0]);
    public static final ParseField MAX_OUTSTANDING_READ_REQUESTS = new ParseField("max_outstanding_read_requests", new String[0]);
    public static final ParseField MAX_OUTSTANDING_WRITE_REQUESTS = new ParseField("max_outstanding_write_requests", new String[0]);
    public static final ParseField MAX_READ_REQUEST_SIZE = new ParseField("max_read_request_size", new String[0]);
    public static final ParseField MAX_WRITE_REQUEST_SIZE = new ParseField("max_write_request_size", new String[0]);
    public static final ParseField MAX_WRITE_BUFFER_COUNT = new ParseField("max_write_buffer_count", new String[0]);
    public static final ParseField MAX_WRITE_BUFFER_SIZE = new ParseField("max_write_buffer_size", new String[0]);
    public static final ParseField MAX_RETRY_DELAY = new ParseField("max_retry_delay", new String[0]);
    public static final ParseField READ_POLL_TIMEOUT = new ParseField("read_poll_timeout", new String[0]);
    Integer maxReadRequestOperationCount;
    Integer maxWriteRequestOperationCount;
    Integer maxOutstandingReadRequests;
    Integer maxOutstandingWriteRequests;
    ByteSizeValue maxReadRequestSize;
    ByteSizeValue maxWriteRequestSize;
    Integer maxWriteBufferCount;
    ByteSizeValue maxWriteBufferSize;
    TimeValue maxRetryDelay;
    TimeValue readPollTimeout;

    public FollowParameters() {
    }

    public FollowParameters(FollowParameters source) {
        this.maxReadRequestOperationCount = source.maxReadRequestOperationCount;
        this.maxWriteRequestOperationCount = source.maxWriteRequestOperationCount;
        this.maxOutstandingReadRequests = source.maxOutstandingReadRequests;
        this.maxOutstandingWriteRequests = source.maxOutstandingWriteRequests;
        this.maxReadRequestSize = source.maxReadRequestSize;
        this.maxWriteRequestSize = source.maxWriteRequestSize;
        this.maxWriteBufferCount = source.maxWriteBufferCount;
        this.maxWriteBufferSize = source.maxWriteBufferSize;
        this.maxRetryDelay = source.maxRetryDelay;
        this.readPollTimeout = source.readPollTimeout;
    }

    public Integer getMaxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    public void setMaxReadRequestOperationCount(Integer maxReadRequestOperationCount) {
        this.maxReadRequestOperationCount = maxReadRequestOperationCount;
    }

    public ByteSizeValue getMaxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    public void setMaxReadRequestSize(ByteSizeValue maxReadRequestSize) {
        this.maxReadRequestSize = maxReadRequestSize;
    }

    public Integer getMaxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    public void setMaxOutstandingReadRequests(Integer maxOutstandingReadRequests) {
        this.maxOutstandingReadRequests = maxOutstandingReadRequests;
    }

    public Integer getMaxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    public void setMaxWriteRequestOperationCount(Integer maxWriteRequestOperationCount) {
        this.maxWriteRequestOperationCount = maxWriteRequestOperationCount;
    }

    public ByteSizeValue getMaxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    public void setMaxWriteRequestSize(ByteSizeValue maxWriteRequestSize) {
        this.maxWriteRequestSize = maxWriteRequestSize;
    }

    public Integer getMaxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    public void setMaxOutstandingWriteRequests(Integer maxOutstandingWriteRequests) {
        this.maxOutstandingWriteRequests = maxOutstandingWriteRequests;
    }

    public Integer getMaxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    public void setMaxWriteBufferCount(Integer maxWriteBufferCount) {
        this.maxWriteBufferCount = maxWriteBufferCount;
    }

    public ByteSizeValue getMaxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    public void setMaxWriteBufferSize(ByteSizeValue maxWriteBufferSize) {
        this.maxWriteBufferSize = maxWriteBufferSize;
    }

    public TimeValue getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public void setMaxRetryDelay(TimeValue maxRetryDelay) {
        this.maxRetryDelay = maxRetryDelay;
    }

    public TimeValue getReadPollTimeout() {
        return this.readPollTimeout;
    }

    public void setReadPollTimeout(TimeValue readPollTimeout) {
        this.readPollTimeout = readPollTimeout;
    }

    public ActionRequestValidationException validate() {
        String message;
        ActionRequestValidationException e = null;
        if (this.maxReadRequestOperationCount != null && this.maxReadRequestOperationCount < 1) {
            e = ValidateActions.addValidationError(MAX_READ_REQUEST_OPERATION_COUNT.getPreferredName() + " must be larger than 0", e);
        }
        if (this.maxReadRequestSize != null && this.maxReadRequestSize.compareTo(ByteSizeValue.ZERO) <= 0) {
            e = ValidateActions.addValidationError(MAX_READ_REQUEST_SIZE.getPreferredName() + " must be larger than 0", e);
        }
        if (this.maxOutstandingReadRequests != null && this.maxOutstandingReadRequests < 1) {
            e = ValidateActions.addValidationError(MAX_OUTSTANDING_READ_REQUESTS.getPreferredName() + " must be larger than 0", e);
        }
        if (this.maxWriteRequestOperationCount != null && this.maxWriteRequestOperationCount < 1) {
            e = ValidateActions.addValidationError(MAX_WRITE_REQUEST_OPERATION_COUNT.getPreferredName() + " must be larger than 0", e);
        }
        if (this.maxWriteRequestSize != null && this.maxWriteRequestSize.compareTo(ByteSizeValue.ZERO) <= 0) {
            e = ValidateActions.addValidationError(MAX_WRITE_REQUEST_SIZE.getPreferredName() + " must be larger than 0", e);
        }
        if (this.maxOutstandingWriteRequests != null && this.maxOutstandingWriteRequests < 1) {
            e = ValidateActions.addValidationError(MAX_OUTSTANDING_WRITE_REQUESTS.getPreferredName() + " must be larger than 0", e);
        }
        if (this.maxWriteBufferCount != null && this.maxWriteBufferCount < 1) {
            e = ValidateActions.addValidationError(MAX_WRITE_BUFFER_COUNT.getPreferredName() + " must be larger than 0", e);
        }
        if (this.maxWriteBufferSize != null && this.maxWriteBufferSize.compareTo(ByteSizeValue.ZERO) <= 0) {
            e = ValidateActions.addValidationError(MAX_WRITE_BUFFER_SIZE.getPreferredName() + " must be larger than 0", e);
        }
        if (this.maxRetryDelay != null && this.maxRetryDelay.millis() <= 0L) {
            message = "[" + MAX_RETRY_DELAY.getPreferredName() + "] must be positive but was [" + this.maxRetryDelay.getStringRep() + "]";
            e = ValidateActions.addValidationError(message, e);
        }
        if (this.maxRetryDelay != null && this.maxRetryDelay.millis() > RETRY_DELAY_MAX.millis()) {
            message = "[" + MAX_RETRY_DELAY.getPreferredName() + "] must be less than [" + RETRY_DELAY_MAX.getStringRep() + "] but was [" + this.maxRetryDelay.getStringRep() + "]";
            e = ValidateActions.addValidationError(message, e);
        }
        return e;
    }

    public FollowParameters(StreamInput in) throws IOException {
        this.fromStreamInput(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.maxReadRequestOperationCount);
        out.writeOptionalVInt(this.maxOutstandingReadRequests);
        out.writeOptionalWriteable(this.maxReadRequestSize);
        out.writeOptionalVInt(this.maxWriteRequestOperationCount);
        out.writeOptionalWriteable(this.maxWriteRequestSize);
        out.writeOptionalVInt(this.maxOutstandingWriteRequests);
        out.writeOptionalVInt(this.maxWriteBufferCount);
        out.writeOptionalWriteable(this.maxWriteBufferSize);
        out.writeOptionalTimeValue(this.maxRetryDelay);
        out.writeOptionalTimeValue(this.readPollTimeout);
    }

    void fromStreamInput(StreamInput in) throws IOException {
        this.maxReadRequestOperationCount = in.readOptionalVInt();
        this.maxOutstandingReadRequests = in.readOptionalVInt();
        this.maxReadRequestSize = in.readOptionalWriteable(ByteSizeValue::new);
        this.maxWriteRequestOperationCount = in.readOptionalVInt();
        this.maxWriteRequestSize = in.readOptionalWriteable(ByteSizeValue::new);
        this.maxOutstandingWriteRequests = in.readOptionalVInt();
        this.maxWriteBufferCount = in.readOptionalVInt();
        this.maxWriteBufferSize = in.readOptionalWriteable(ByteSizeValue::new);
        this.maxRetryDelay = in.readOptionalTimeValue();
        this.readPollTimeout = in.readOptionalTimeValue();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder);
        builder.endObject();
        return builder;
    }

    XContentBuilder toXContentFragment(XContentBuilder builder) throws IOException {
        if (this.maxReadRequestOperationCount != null) {
            builder.field(MAX_READ_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxReadRequestOperationCount);
        }
        if (this.maxWriteRequestOperationCount != null) {
            builder.field(MAX_WRITE_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxWriteRequestOperationCount);
        }
        if (this.maxOutstandingReadRequests != null) {
            builder.field(MAX_OUTSTANDING_READ_REQUESTS.getPreferredName(), this.maxOutstandingReadRequests);
        }
        if (this.maxOutstandingWriteRequests != null) {
            builder.field(MAX_OUTSTANDING_WRITE_REQUESTS.getPreferredName(), this.maxOutstandingWriteRequests);
        }
        if (this.maxReadRequestSize != null) {
            builder.field(MAX_READ_REQUEST_SIZE.getPreferredName(), this.maxReadRequestSize.getStringRep());
        }
        if (this.maxWriteRequestSize != null) {
            builder.field(MAX_WRITE_REQUEST_SIZE.getPreferredName(), this.maxWriteRequestSize.getStringRep());
        }
        if (this.maxWriteBufferCount != null) {
            builder.field(MAX_WRITE_BUFFER_COUNT.getPreferredName(), this.maxWriteBufferCount);
        }
        if (this.maxWriteBufferSize != null) {
            builder.field(MAX_WRITE_BUFFER_SIZE.getPreferredName(), this.maxWriteBufferSize.getStringRep());
        }
        if (this.maxRetryDelay != null) {
            builder.field(MAX_RETRY_DELAY.getPreferredName(), this.maxRetryDelay.getStringRep());
        }
        if (this.readPollTimeout != null) {
            builder.field(READ_POLL_TIMEOUT.getPreferredName(), this.readPollTimeout.getStringRep());
        }
        return builder;
    }

    public static <P extends FollowParameters> void initParser(AbstractObjectParser<P, ?> parser) {
        parser.declareInt(FollowParameters::setMaxReadRequestOperationCount, MAX_READ_REQUEST_OPERATION_COUNT);
        parser.declareInt(FollowParameters::setMaxWriteRequestOperationCount, MAX_WRITE_REQUEST_OPERATION_COUNT);
        parser.declareInt(FollowParameters::setMaxOutstandingReadRequests, MAX_OUTSTANDING_READ_REQUESTS);
        parser.declareInt(FollowParameters::setMaxOutstandingWriteRequests, MAX_OUTSTANDING_WRITE_REQUESTS);
        parser.declareField(FollowParameters::setMaxReadRequestSize, (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MAX_READ_REQUEST_SIZE.getPreferredName()), MAX_READ_REQUEST_SIZE, ObjectParser.ValueType.STRING);
        parser.declareField(FollowParameters::setMaxWriteRequestSize, (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MAX_WRITE_REQUEST_SIZE.getPreferredName()), MAX_WRITE_REQUEST_SIZE, ObjectParser.ValueType.STRING);
        parser.declareInt(FollowParameters::setMaxWriteBufferCount, MAX_WRITE_BUFFER_COUNT);
        parser.declareField(FollowParameters::setMaxWriteBufferSize, (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MAX_WRITE_BUFFER_SIZE.getPreferredName()), MAX_WRITE_BUFFER_SIZE, ObjectParser.ValueType.STRING);
        parser.declareField(FollowParameters::setMaxRetryDelay, (p, c) -> TimeValue.parseTimeValue(p.text(), MAX_RETRY_DELAY.getPreferredName()), MAX_RETRY_DELAY, ObjectParser.ValueType.STRING);
        parser.declareField(FollowParameters::setReadPollTimeout, (p, c) -> TimeValue.parseTimeValue(p.text(), READ_POLL_TIMEOUT.getPreferredName()), READ_POLL_TIMEOUT, ObjectParser.ValueType.STRING);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FollowParameters)) {
            return false;
        }
        FollowParameters that = (FollowParameters)o;
        return Objects.equals(this.maxReadRequestOperationCount, that.maxReadRequestOperationCount) && Objects.equals(this.maxWriteRequestOperationCount, that.maxWriteRequestOperationCount) && Objects.equals(this.maxOutstandingReadRequests, that.maxOutstandingReadRequests) && Objects.equals(this.maxOutstandingWriteRequests, that.maxOutstandingWriteRequests) && Objects.equals(this.maxReadRequestSize, that.maxReadRequestSize) && Objects.equals(this.maxWriteRequestSize, that.maxWriteRequestSize) && Objects.equals(this.maxWriteBufferCount, that.maxWriteBufferCount) && Objects.equals(this.maxWriteBufferSize, that.maxWriteBufferSize) && Objects.equals(this.maxRetryDelay, that.maxRetryDelay) && Objects.equals(this.readPollTimeout, that.readPollTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.maxReadRequestOperationCount, this.maxWriteRequestOperationCount, this.maxOutstandingReadRequests, this.maxOutstandingWriteRequests, this.maxReadRequestSize, this.maxWriteRequestSize, this.maxWriteBufferCount, this.maxWriteBufferSize, this.maxRetryDelay, this.readPollTimeout);
    }
}

