/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PreviewDataFrameAnalyticsAction
extends ActionType<Response> {
    public static final PreviewDataFrameAnalyticsAction INSTANCE = new PreviewDataFrameAnalyticsAction();
    public static final String NAME = "cluster:admin/xpack/ml/data_frame/analytics/preview";

    private PreviewDataFrameAnalyticsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField TYPE = new ParseField("preview_data_frame_analytics_response", new String[0]);
        public static final ParseField FEATURE_VALUES = new ParseField("feature_values", new String[0]);
        static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), args -> new Response((List)args[0]));
        private final List<Map<String, Object>> featureValues;

        public Response(List<Map<String, Object>> featureValues) {
            this.featureValues = Objects.requireNonNull(featureValues);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.featureValues = in.readList(StreamInput::readMap);
        }

        public List<Map<String, Object>> getFeatureValues() {
            return this.featureValues;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.featureValues, StreamOutput::writeMap);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FEATURE_VALUES.getPreferredName(), this.featureValues);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Response that = (Response)other;
            return Objects.equals(this.featureValues, that.featureValues);
        }

        public int hashCode() {
            return Objects.hash(this.featureValues);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), FEATURE_VALUES);
        }
    }

    public static class Request
    extends ActionRequest {
        public static final ParseField CONFIG = new ParseField("config", new String[0]);
        private final DataFrameAnalyticsConfig config;
        static final ObjectParser<Builder, Void> PARSER = new ObjectParser("preview_data_frame_analytics_response", Builder::new);

        public static Builder fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public Request(DataFrameAnalyticsConfig config) {
            this.config = ExceptionsHelper.requireNonNull(config, CONFIG);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new DataFrameAnalyticsConfig(in);
        }

        public DataFrameAnalyticsConfig getConfig() {
            return this.config;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.config, request.config);
        }

        public int hashCode() {
            return Objects.hash(this.config);
        }

        static {
            PARSER.declareObject((rec$, x$0) -> ((Builder)rec$).setConfig(x$0), DataFrameAnalyticsConfig.STRICT_PARSER::apply, CONFIG);
        }

        public static class Builder {
            private DataFrameAnalyticsConfig config;

            private Builder setConfig(DataFrameAnalyticsConfig.Builder config) {
                this.config = config.buildForExplain();
                return this;
            }

            public Builder setConfig(DataFrameAnalyticsConfig config) {
                this.config = config;
                return this;
            }

            public DataFrameAnalyticsConfig getConfig() {
                return this.config;
            }

            public Request build() {
                return new Request(this.config);
            }
        }
    }
}

