/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.StartsWithFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class StartsWithFunctionPipe
extends Pipe {
    private final Pipe input;
    private final Pipe pattern;
    private final boolean isCaseSensitive;

    public StartsWithFunctionPipe(Source source, Expression expression, Pipe input, Pipe pattern, boolean isCaseSensitive) {
        super(source, expression, Arrays.asList(input, pattern));
        this.input = input;
        this.pattern = pattern;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public final Pipe replaceChildren(List<Pipe> newChildren) {
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    @Override
    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newField = this.input.resolveAttributes(resolver);
        Pipe newPattern = this.pattern.resolveAttributes(resolver);
        if (newField == this.input && newPattern == this.pattern) {
            return this;
        }
        return this.replaceChildren(newField, newPattern);
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.input.supportedByAggsOnlyQuery() && this.pattern.supportedByAggsOnlyQuery();
    }

    @Override
    public boolean resolved() {
        return this.input.resolved() && this.pattern.resolved();
    }

    protected Pipe replaceChildren(Pipe newField, Pipe newPattern) {
        return new StartsWithFunctionPipe(this.source(), this.expression(), newField, newPattern, this.isCaseSensitive);
    }

    @Override
    public final void collectFields(QlSourceBuilder sourceBuilder) {
        this.input.collectFields(sourceBuilder);
        this.pattern.collectFields(sourceBuilder);
    }

    @Override
    protected NodeInfo<StartsWithFunctionPipe> info() {
        return NodeInfo.create(this, StartsWithFunctionPipe::new, this.expression(), this.input, this.pattern, this.isCaseSensitive);
    }

    @Override
    public StartsWithFunctionProcessor asProcessor() {
        return new StartsWithFunctionProcessor(this.input.asProcessor(), this.pattern.asProcessor(), this.isCaseSensitive);
    }

    public Pipe input() {
        return this.input;
    }

    public Pipe pattern() {
        return this.pattern;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.input, this.pattern, this.isCaseSensitive);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StartsWithFunctionPipe other = (StartsWithFunctionPipe)obj;
        return Objects.equals(this.input, other.input) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.isCaseSensitive, other.isCaseSensitive);
    }
}

