/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.coordination.DiscoveryUpgradeService;
import org.elasticsearch.cluster.coordination.JoinHelper;
import org.elasticsearch.cluster.coordination.NoMasterBlockService;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.SeedHostsResolver;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.discovery.zen.ElectMasterService;
import org.elasticsearch.discovery.zen.FaultDetection;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.DanglingIndicesState;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.jdk.JavaVersion;
import org.elasticsearch.license.License;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.SniffConnectionStrategy;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.xpack.cluster.routing.allocation.DataTierAllocationDecider;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.saml.SamlRealmSettings;
import org.elasticsearch.xpack.monitoring.Monitoring;

class NodeDeprecationChecks {
    static final String JAVA_DEPRECATION_MESSAGE = "Java 11 is required in 8.0";
    private static final String MONITORING_SETTING_DEPRECATION_LINK = "https://ela.st/es-deprecation-7-monitoring-settings";

    NodeDeprecationChecks() {
    }

    static DeprecationIssue checkPidfile(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, Environment.PIDFILE_SETTING, Environment.NODE_PIDFILE_SETTING, "https://ela.st/es-deprecation-7-pidfile-setting");
    }

    static DeprecationIssue checkProcessors(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, EsExecutors.PROCESSORS_SETTING, EsExecutors.NODE_PROCESSORS_SETTING, "https://ela.st/es-deprecation-7-processors-setting");
    }

    static DeprecationIssue checkMissingRealmOrders(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Set orderNotConfiguredRealms = RealmSettings.getRealmSettings((Settings)settings).entrySet().stream().filter(e -> false == ((Settings)e.getValue()).hasValue("order")).filter(e -> ((Settings)e.getValue()).getAsBoolean("enabled", Boolean.valueOf(true))).map(e -> RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)((RealmConfig.RealmIdentifier)e.getKey())) + "order").collect(Collectors.toSet());
        if (orderNotConfiguredRealms.isEmpty()) {
            return null;
        }
        String details = String.format(Locale.ROOT, "Specify the realm order for all realms [%s]. If no realm order is specified, the node will fail to start in 8.0. ", String.join((CharSequence)"; ", orderNotConfiguredRealms));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Realm order is required", "https://ela.st/es-deprecation-7-realm-orders-required", details, false, null);
    }

    static DeprecationIssue checkUniqueRealmOrders(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Map orderToRealmSettings = RealmSettings.getRealmSettings((Settings)settings).entrySet().stream().filter(e -> ((Settings)e.getValue()).hasValue("order")).collect(Collectors.groupingBy(e -> ((Settings)e.getValue()).get("order"), Collectors.mapping(e -> RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)((RealmConfig.RealmIdentifier)e.getKey())) + "order", Collectors.toList())));
        Set duplicateOrders = orderToRealmSettings.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.toSet());
        if (duplicateOrders.isEmpty()) {
            return null;
        }
        String details = String.format(Locale.ROOT, "The same order is configured for multiple realms: [%s]]. Configure a unique order for each realm. If duplicate realm orders exist, the node will fail to start in 8.0. ", String.join((CharSequence)"; ", duplicateOrders));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Realm orders must be unique", "https://ela.st/es-deprecation-7-realm-orders-unique", details, false, null);
    }

    static DeprecationIssue checkImplicitlyDisabledSecurityOnBasicAndTrial(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (!XPackSettings.SECURITY_ENABLED.exists(settings) && (licenseState.getOperationMode().equals((Object)License.OperationMode.BASIC) || licenseState.getOperationMode().equals((Object)License.OperationMode.TRIAL))) {
            String details = "Security will no longer be disabled by default for Trial licenses in 8.0. The [xpack.security.enabled] setting will always default to \"true\". See https://ela.st/es-deprecation-7-security-minimal-setup to secure your cluster. To explicitly disable security, set [xpack.security.enabled] to \"false\" (not recommended).";
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Security is enabled by default for all licenses", "https://ela.st/es-deprecation-7-implicitly-disabled-security", details, false, null);
        }
        return null;
    }

    static DeprecationIssue checkImplicitlyDisabledBasicRealms(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        String details;
        Map realmSettings = RealmSettings.getRealmSettings((Settings)settings);
        if (realmSettings.isEmpty()) {
            return null;
        }
        boolean anyRealmEnabled = false;
        HashSet unconfiguredBasicRealms = new HashSet(org.elasticsearch.core.Set.of((Object)"file", (Object)"native"));
        for (Map.Entry realmSetting : realmSettings.entrySet()) {
            anyRealmEnabled = anyRealmEnabled || ((Settings)realmSetting.getValue()).getAsBoolean("enabled", Boolean.valueOf(true)) != false;
            unconfiguredBasicRealms.remove(((RealmConfig.RealmIdentifier)realmSetting.getKey()).getType());
        }
        if (!anyRealmEnabled) {
            List explicitlyDisabledBasicRealms = Sets.difference((Set)org.elasticsearch.core.Set.of((Object)"file", (Object)"native"), unconfiguredBasicRealms).stream().sorted().collect(Collectors.toList());
            if (explicitlyDisabledBasicRealms.isEmpty()) {
                return null;
            }
            details = String.format(Locale.ROOT, "Found explicitly disabled basic %s: [%s]. But %s will be enabled because no other realms are configured or enabled. In next major release, explicitly disabled basic realms will remain disabled.", explicitlyDisabledBasicRealms.size() == 1 ? "realm" : "realms", Strings.collectionToDelimitedString(explicitlyDisabledBasicRealms, (String)","), explicitlyDisabledBasicRealms.size() == 1 ? "it" : "they");
        } else {
            if (unconfiguredBasicRealms.isEmpty()) {
                return null;
            }
            details = String.format(Locale.ROOT, "Found implicitly disabled basic %s: [%s]. %s disabled because there are other explicitly configured realms.In next major release, basic realms will always be enabled unless explicitly disabled.", unconfiguredBasicRealms.size() == 1 ? "realm" : "realms", Strings.collectionToDelimitedString(unconfiguredBasicRealms, (String)","), unconfiguredBasicRealms.size() == 1 ? "It is" : "They are");
        }
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "File and/or native realms are enabled by default in next major release.", "https://ela.st/es-deprecation-7-implicitly-disabled-basic-realms", details, false, null);
    }

    static DeprecationIssue checkReservedPrefixedRealmNames(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Map realmSettings = RealmSettings.getRealmSettings((Settings)settings);
        if (realmSettings.isEmpty()) {
            return null;
        }
        ArrayList<RealmConfig.RealmIdentifier> reservedPrefixedRealmIdentifiers = new ArrayList<RealmConfig.RealmIdentifier>();
        for (RealmConfig.RealmIdentifier realmIdentifier : realmSettings.keySet()) {
            if (!realmIdentifier.getName().startsWith("_")) continue;
            reservedPrefixedRealmIdentifiers.add(realmIdentifier);
        }
        if (reservedPrefixedRealmIdentifiers.isEmpty()) {
            return null;
        }
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Prefixing realm names with an underscore (_) is deprecated", "https://ela.st/es-deprecation-7-realm-names", String.format(Locale.ROOT, "Rename the following realm%s in the realm chain: %s.", reservedPrefixedRealmIdentifiers.size() > 1 ? "s" : "", reservedPrefixedRealmIdentifiers.stream().map(rid -> "xpack.security.authc.realms." + rid.getType() + "." + rid.getName()).sorted().collect(Collectors.joining(", "))), false, null);
    }

    static DeprecationIssue checkThreadPoolListenerQueueSize(Settings settings) {
        return NodeDeprecationChecks.checkThreadPoolListenerSetting("thread_pool.listener.queue_size", settings);
    }

    static DeprecationIssue checkThreadPoolListenerSize(Settings settings) {
        return NodeDeprecationChecks.checkThreadPoolListenerSetting("thread_pool.listener.size", settings);
    }

    private static DeprecationIssue checkThreadPoolListenerSetting(String name, Settings settings) {
        FixedExecutorBuilder builder = new FixedExecutorBuilder(settings, "listener", 1, -1, "thread_pool.listener", true);
        List listenerSettings = builder.getRegisteredSettings();
        Optional<Setting> setting = listenerSettings.stream().filter(s -> s.getKey().equals(name)).findFirst();
        assert (setting.isPresent());
        return NodeDeprecationChecks.checkRemovedSetting(settings, setting.get(), "https://ela.st/es-deprecation-7-thread-pool-listener-settings", "The listener pool is no longer used in 8.0.");
    }

    public static DeprecationIssue checkClusterRemoteConnectSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (!RemoteClusterService.ENABLE_REMOTE_CLUSTERS.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = RemoteClusterService.ENABLE_REMOTE_CLUSTERS.getKey();
        String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", deprecatedSettingKey);
        String details = String.format(Locale.ROOT, "Remove the [%s] setting. Use the [remote_cluster_client] role instead. Set [node.roles] to [data_frozen,master,remote_cluster_client,data,data_content,data_hot,data_warm,data_cold,ingest] on eligible cross-cluster client nodes.", deprecatedSettingKey);
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, "https://ela.st/es-deprecation-7-cluster-remote-connect-setting", details, false, null);
    }

    public static DeprecationIssue checkNodeLocalStorageSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, Node.NODE_LOCAL_STORAGE_SETTING, "https://ela.st/es-deprecation-7-node-local-storage-setting", "All nodes require local storage in 8.0 and cannot share data paths.");
    }

    public static DeprecationIssue checkNodeBasicLicenseFeatureEnabledSetting(Settings settings, Setting<?> setting) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, setting, "https://ela.st/es-deprecation-7-xpack-basic-feature-settings", "Basic features are always enabled in 8.0.");
    }

    public static DeprecationIssue checkLegacyRoleSettings(Setting<Boolean> legacyRoleSetting, Settings settings, PluginsAndModules pluginsAndModules) {
        assert (legacyRoleSetting.isDeprecated()) : legacyRoleSetting;
        if (!legacyRoleSetting.exists(settings)) {
            return null;
        }
        String legacyRoleSettingKey = legacyRoleSetting.getKey();
        String role = !legacyRoleSettingKey.isEmpty() && legacyRoleSettingKey.contains(".") && legacyRoleSettingKey.indexOf(".") <= legacyRoleSettingKey.length() + 2 ? legacyRoleSettingKey.substring(legacyRoleSettingKey.indexOf(".") + 1) : "unknown";
        String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", legacyRoleSettingKey);
        String details = String.format(Locale.ROOT, "Remove the [%s] setting. Set [%s] and include the [%s] role.", legacyRoleSettingKey, NodeRoleSettings.NODE_ROLES_SETTING.getKey(), role);
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, "https://ela.st/es-deprecation-7-node-roles", details, false, null);
    }

    static DeprecationIssue checkBootstrapSystemCallFilterSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, BootstrapSettings.SYSTEM_CALL_FILTER_SETTING, "https://ela.st/es-deprecation-7-system-call-filter-setting", "System call filters are always required in 8.0.");
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting<?> replacementSetting, String url) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, (String v, Settings s) -> v, url);
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting<?> replacementSetting, BiFunction<String, Settings, String> replacementValue, String url) {
        assert (deprecatedSetting.isDeprecated()) : deprecatedSetting;
        if (!deprecatedSetting.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String replacementSettingKey = replacementSetting.getKey();
        String value = deprecatedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", deprecatedSettingKey);
        String details = String.format(Locale.ROOT, "Remove the [%s] setting and set [%s] to [%s].", deprecatedSettingKey, replacementSettingKey, replacementValue.apply(value, settings));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting.AffixSetting<?> replacementSetting, String star, String url) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, (v, s) -> v, star, url);
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting.AffixSetting<?> replacementSetting, BiFunction<String, Settings, String> replacementValue, String star, String url) {
        assert (deprecatedSetting.isDeprecated()) : deprecatedSetting;
        if (!deprecatedSetting.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String replacementSettingKey = replacementSetting.getKey();
        String value = deprecatedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", deprecatedSettingKey, replacementSettingKey);
        String details = String.format(Locale.ROOT, "Remove the [%s] setting. Set [%s] to [%s], where * is %s", deprecatedSettingKey, replacementSettingKey, replacementValue.apply(value, settings), star);
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
    }

    static DeprecationIssue checkRemovedSetting(Settings settings, Setting<?> removedSetting, String url, String additionalDetailMessage) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, removedSetting, url, additionalDetailMessage, DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkDeprecatedSetting(Settings settings, Setting<?> deprecatedSetting, String url) {
        if (!deprecatedSetting.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String value = deprecatedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", deprecatedSettingKey);
        String details = String.format(Locale.ROOT, "Remove the [%s] setting.", deprecatedSettingKey, value);
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, url, details, false, null);
    }

    static DeprecationIssue checkRemovedSetting(Settings settings, Setting<?> removedSetting, String url, String additionalDetailMessage, DeprecationIssue.Level deprecationLevel) {
        if (!removedSetting.exists(settings)) {
            return null;
        }
        String removedSettingKey = removedSetting.getKey();
        Object removedSettingValue = removedSetting.get(settings);
        if (removedSettingValue instanceof TimeValue) {
            String value = ((TimeValue)removedSettingValue).getStringRep();
        } else {
            String value = removedSettingValue.toString();
        }
        String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", removedSettingKey);
        String details = String.format(Locale.ROOT, "Remove the [%s] setting. %s", removedSettingKey, additionalDetailMessage);
        return new DeprecationIssue(deprecationLevel, message, url, details, false, null);
    }

    static DeprecationIssue javaVersionCheck(Settings nodeSettings, PluginsAndModules plugins, ClusterState clusterState, XPackLicenseState licenseState) {
        JavaVersion javaVersion = JavaVersion.current();
        if (javaVersion.compareTo(JavaVersion.parse((String)"11")) < 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, JAVA_DEPRECATION_MESSAGE, "https://ela.st/es-deprecation-7-java-version", "This node is running Java version [" + javaVersion.toString() + "]. Consider switching to a distribution of Elasticsearch with a bundled JDK or upgrade. If you are already using a distribution with a bundled JDK, ensure the JAVA_HOME environment variable is not set.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkMultipleDataPaths(Settings nodeSettings, PluginsAndModules plugins, ClusterState clusterState, XPackLicenseState licenseState) {
        List dataPaths = (List)Environment.PATH_DATA_SETTING.get(nodeSettings);
        if (dataPaths.size() > 1) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Specifying multiple data paths is deprecated", "https://ela.st/es-deprecation-7-multiple-paths", "The [path.data] setting contains a list of paths. Specify a single path as a string. Use RAID or other system level features to utilize multiple disks. If multiple data paths are configured, the node will fail to start in 8.0. ", false, null);
        }
        return null;
    }

    static DeprecationIssue checkDataPathsList(Settings nodeSettings, PluginsAndModules plugins, ClusterState clusterState, XPackLicenseState licenseState) {
        if (Environment.dataPathUsesList((Settings)nodeSettings)) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Multiple data paths are not supported", "https://ela.st/es-deprecation-7-multiple-paths", "The [path.data] setting contains a list of paths. Specify a single path as a string. Use RAID or other system level features to utilize multiple disks. If multiple data paths are configured, the node will fail to start in 8.0. ", false, null);
        }
        return null;
    }

    static DeprecationIssue checkSharedDataPathSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (Environment.PATH_SHARED_DATA_SETTING.exists(settings)) {
            String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", Environment.PATH_SHARED_DATA_SETTING.getKey());
            String url = "https://ela.st/es-deprecation-7-shared-path-settings";
            String details = String.format(Locale.ROOT, "Remove the [%s] setting. This setting has had no effect since 6.0.", Environment.PATH_SHARED_DATA_SETTING.getKey());
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, "https://ela.st/es-deprecation-7-shared-path-settings", details, false, null);
        }
        return null;
    }

    static DeprecationIssue checkSingleDataNodeWatermarkSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (!((Boolean)DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.get(settings)).booleanValue() && DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.exists(settings)) {
            String key = DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.getKey();
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, String.format(Locale.ROOT, "Setting [%s=false] is deprecated", key), "https://ela.st/es-deprecation-7-disk-watermark-enable-for-single-node-setting", String.format(Locale.ROOT, "Disk watermarks do not treat single-node clusters differently in versions 8.0 and later, and [%s] may not be set to [false] in these versions. Set [%s] to [true] to adopt the future behavior before upgrading.", key, key), false, null);
        }
        if (!((Boolean)DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.get(settings)).booleanValue() && clusterState.getNodes().getDataNodes().size() == 1 && clusterState.getNodes().getLocalNode().isMasterNode()) {
            String key = DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.getKey();
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Disk watermarks do not treat single-node clusters differently in versions 8.0 and later.", "https://ela.st/es-deprecation-7-disk-watermark-enable-for-single-node-setting", String.format(Locale.ROOT, "Disk watermarks do not treat single-node clusters differently in versions 8.0 and later, which will affect the behavior of this cluster. Set [%s] to [true] to adopt the future behavior before upgrading.", key), false, null);
        }
        return null;
    }

    static DeprecationIssue checkMonitoringExporterPassword(Settings settings, PluginsAndModules pluginsAndModules, ClusterState cs, XPackLicenseState licenseState) {
        Setting.AffixSetting AUTH_PASSWORD_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"auth.password", s -> Setting.simpleString((String)s, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        List passwords = AUTH_PASSWORD_SETTING.getAllConcreteSettings(settings).sorted(Comparator.comparing(Setting::getKey)).collect(Collectors.toList());
        if (passwords.isEmpty()) {
            return null;
        }
        String passwordSettings = passwords.stream().map(Setting::getKey).collect(Collectors.joining(","));
        String message = String.format(Locale.ROOT, "Monitoring exporters must use secure passwords", passwordSettings);
        String details = String.format(Locale.ROOT, "Remove the non-secure monitoring exporter password settings: [%s]. Configure secure passwords with [xpack.monitoring.exporters.*.auth.secure_password].", passwordSettings);
        String url = "https://ela.st/es-deprecation-7-monitoring-exporter-passwords";
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, "https://ela.st/es-deprecation-7-monitoring-exporter-passwords", details, false, null);
    }

    static DeprecationIssue checkJoinTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, JoinHelper.JOIN_TIMEOUT_SETTING, "https://ela.st/es-deprecation-7-cluster-join-timeout-setting", "Cluster join attempts never time out in 8.0.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkSearchRemoteSettings(Settings settings, PluginsAndModules pluginsAndModules, ClusterState cs, XPackLicenseState licenseState) {
        ArrayList<Setting> remoteClusterSettings = new ArrayList<Setting>();
        remoteClusterSettings.addAll(SniffConnectionStrategy.SEARCH_REMOTE_CLUSTERS_SEEDS.getAllConcreteSettings(settings).sorted(Comparator.comparing(Setting::getKey)).collect(Collectors.toList()));
        remoteClusterSettings.addAll(SniffConnectionStrategy.SEARCH_REMOTE_CLUSTERS_PROXY.getAllConcreteSettings(settings).sorted(Comparator.comparing(Setting::getKey)).collect(Collectors.toList()));
        remoteClusterSettings.addAll(RemoteClusterService.SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE.getAllConcreteSettings(settings).sorted(Comparator.comparing(Setting::getKey)).collect(Collectors.toList()));
        if (SniffConnectionStrategy.SEARCH_REMOTE_CONNECTIONS_PER_CLUSTER.exists(settings)) {
            remoteClusterSettings.add(SniffConnectionStrategy.SEARCH_REMOTE_CONNECTIONS_PER_CLUSTER);
        }
        if (RemoteClusterService.SEARCH_REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING.exists(settings)) {
            remoteClusterSettings.add(RemoteClusterService.SEARCH_REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING);
        }
        if (RemoteClusterService.SEARCH_REMOTE_NODE_ATTRIBUTE.exists(settings)) {
            remoteClusterSettings.add(RemoteClusterService.SEARCH_REMOTE_NODE_ATTRIBUTE);
        }
        if (RemoteClusterService.SEARCH_ENABLE_REMOTE_CLUSTERS.exists(settings)) {
            remoteClusterSettings.add(RemoteClusterService.SEARCH_ENABLE_REMOTE_CLUSTERS);
        }
        if (remoteClusterSettings.isEmpty()) {
            return null;
        }
        String remoteClusterSeedSettings = remoteClusterSettings.stream().map(Setting::getKey).collect(Collectors.joining(","));
        String message = "Remotes for cross cluster search must be configured with cluster remote settings";
        String details = String.format(Locale.ROOT, "Replace the search.remote settings [%s] with their secure [cluster.remote] equivalents", remoteClusterSeedSettings);
        String url = "https://ela.st/es-deprecation-7-search-remote-settings";
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Remotes for cross cluster search must be configured with cluster remote settings", "https://ela.st/es-deprecation-7-search-remote-settings", details, false, null);
    }

    static DeprecationIssue checkClusterRoutingAllocationIncludeRelocationsSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_INCLUDE_RELOCATIONS_SETTING, "https://ela.st/es-deprecation-7-cluster-routing-allocation-disk-include-relocations-setting", "Relocating shards are always taken into account in 8.0.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkFractionalByteValueSettings(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        HashMap<String, String> fractionalByteSettings = new HashMap<String, String>();
        for (String key : settings.keySet()) {
            try {
                settings.getAsBytesSize(key, ByteSizeValue.ZERO);
                String stringValue = settings.get(key);
                if (!stringValue.contains(".")) continue;
                fractionalByteSettings.put(key, stringValue);
            }
            catch (Exception stringValue) {}
        }
        if (fractionalByteSettings.isEmpty()) {
            return null;
        }
        String url = "https://ela.st/es-deprecation-7-fractional-byte-settings";
        String message = "Configuring fractional byte sizes is deprecated";
        String details = String.format(Locale.ROOT, "Set the following to whole numbers: [%s].", fractionalByteSettings.entrySet().stream().map(fractionalByteSetting -> (String)fractionalByteSetting.getKey()).collect(Collectors.joining(", ")));
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, url, details, false, null);
    }

    static DeprecationIssue checkFrozenCacheLeniency(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        List roles;
        ByteSizeValue cacheSize;
        String cacheSizeSettingKey = "xpack.searchable.snapshot.shared_cache.size";
        Setting cacheSizeSetting = Setting.byteSizeSetting((String)"xpack.searchable.snapshot.shared_cache.size", (ByteSizeValue)ByteSizeValue.ZERO, (Setting.Property[])new Setting.Property[0]);
        if (cacheSizeSetting.exists(settings) && (cacheSize = (ByteSizeValue)cacheSizeSetting.get(settings)).getBytes() > 0L && !DataTier.isFrozenNode(new HashSet(roles = (List)NodeRoleSettings.NODE_ROLES_SETTING.get(settings)))) {
            String message = String.format(Locale.ROOT, "Only frozen nodes can have a [%s] greater than zero.", "xpack.searchable.snapshot.shared_cache.size");
            String url = "https://ela.st/es-deprecation-7-searchable-snapshot-shared-cache-setting";
            String details = String.format(Locale.ROOT, "Set [%s] to zero on any node that doesn't have the [data_frozen] role.", "xpack.searchable.snapshot.shared_cache.size");
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
        }
        return null;
    }

    static DeprecationIssue checkSslServerEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        ArrayList<String> details = new ArrayList<String>();
        for (String prefix : new String[]{"xpack.security.transport.ssl", "xpack.security.http.ssl"}) {
            String enabledSettingKey = prefix + ".enabled";
            String enabledSettingValue = settings.get(enabledSettingKey);
            Settings sslSettings = settings.filter(setting -> setting.startsWith(prefix));
            if (enabledSettingValue != null || sslSettings.size() <= 0) continue;
            String keys = sslSettings.keySet().stream().collect(Collectors.joining(","));
            String detail = String.format(Locale.ROOT, "The [%s] setting is not configured, but the following SSL settings are: [%s]. To configure SSL, set [%s] or the node will fail to start in 8.0.", enabledSettingKey, keys, enabledSettingKey);
            details.add(detail);
        }
        if (details.isEmpty()) {
            return null;
        }
        String url = "https://ela.st/es-deprecation-7-explicit-ssl-required";
        String message = "Must explicitly enable or disable SSL to configure SSL settings";
        String detailsString = details.stream().collect(Collectors.joining("; "));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, detailsString, false, null);
    }

    static DeprecationIssue checkSslCertConfiguration(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        ArrayList<String> details = new ArrayList<String>();
        for (String prefix : new String[]{"xpack.security.transport.ssl", "xpack.security.http.ssl"}) {
            String detail;
            boolean certificatePathSettingExists;
            String enabledSettingKey = prefix + ".enabled";
            boolean sslEnabled = settings.getAsBoolean(enabledSettingKey, Boolean.valueOf(false));
            if (!sslEnabled) continue;
            String keystorePathSettingKey = prefix + "." + "keystore.path";
            String keyPathSettingKey = prefix + "." + "key";
            String certificatePathSettingKey = prefix + "." + "certificate";
            boolean keystorePathSettingExists = settings.get(keystorePathSettingKey) != null;
            boolean keyPathSettingExists = settings.get(keyPathSettingKey) != null;
            boolean bl = certificatePathSettingExists = settings.get(certificatePathSettingKey) != null;
            if (!(keystorePathSettingExists || keyPathSettingExists || certificatePathSettingExists)) {
                detail = String.format(Locale.ROOT, "None of [%s], [%s], or [%s] are set. If [%s] is true either use a keystore, or configure [%s] and [%s].", keystorePathSettingKey, keyPathSettingKey, certificatePathSettingKey, enabledSettingKey, keyPathSettingKey, certificatePathSettingKey);
                details.add(detail);
                continue;
            }
            if (keystorePathSettingExists && keyPathSettingExists && certificatePathSettingExists) {
                detail = String.format(Locale.ROOT, "All of [%s], [%s], and [%s] are set. Either use a keystore, or configure [%s] and [%s].", keystorePathSettingKey, keyPathSettingKey, certificatePathSettingKey, keyPathSettingKey, certificatePathSettingKey);
                details.add(detail);
                continue;
            }
            if (keystorePathSettingExists && (keyPathSettingExists || certificatePathSettingExists)) {
                detail = String.format(Locale.ROOT, "Do not configure both [%s] and [%s]. Either use a keystore, or configure [%s] and [%s].", keystorePathSettingKey, keyPathSettingExists ? keyPathSettingKey : certificatePathSettingKey, keyPathSettingKey, certificatePathSettingKey);
                details.add(detail);
                continue;
            }
            if ((!keyPathSettingExists || certificatePathSettingExists) && (keyPathSettingExists || !certificatePathSettingExists)) continue;
            detail = String.format(Locale.ROOT, "[%s] is set but [%s] is not", keyPathSettingExists ? keyPathSettingKey : certificatePathSettingKey, keyPathSettingExists ? certificatePathSettingKey : keyPathSettingKey);
            details.add(detail);
        }
        if (details.isEmpty()) {
            return null;
        }
        String url = "https://ela.st/es-deprecation-7-ssl-settings";
        String message = "Must either configure a keystore or set the key path and certificate path when SSL is enabled";
        String detailsString = details.stream().collect(Collectors.joining("; "));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, detailsString, false, null);
    }

    static DeprecationIssue checkNoPermitHandshakeFromIncompatibleBuilds(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState, Supplier<String> permitsHandshakesFromIncompatibleBuildsSupplier) {
        if (permitsHandshakesFromIncompatibleBuildsSupplier.get() != null) {
            String message = String.format(Locale.ROOT, "Setting the [%s] system property is deprecated", "es.unsafely_permit_handshake_from_incompatible_builds");
            String details = String.format(Locale.ROOT, "Remove the [%s] system property. Handshakes from incompatible builds are not allowed in 8.0.", "es.unsafely_permit_handshake_from_incompatible_builds");
            String url = "https://ela.st/es-deprecation-7-permit-handshake-from-incompatible-builds-setting";
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
        }
        return null;
    }

    static DeprecationIssue checkTransportClientProfilesFilterSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState cs, XPackLicenseState licenseState) {
        Setting.AffixSetting transportTypeProfileSetting = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.type", s -> Setting.simpleString((String)s, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        List transportProfiles = transportTypeProfileSetting.getAllConcreteSettings(settings).sorted(Comparator.comparing(Setting::getKey)).collect(Collectors.toList());
        if (transportProfiles.isEmpty()) {
            return null;
        }
        String transportProfilesSettings = transportProfiles.stream().map(Setting::getKey).collect(Collectors.joining(","));
        String message = String.format(Locale.ROOT, "Settings [%s] for the Transport client are deprecated", transportProfilesSettings);
        String details = "Remove all [transport.profiles] settings. The Transport client no longer exists in 8.0.";
        String url = "https://ela.st/es-deprecation-7-transport-profiles-settings";
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, "https://ela.st/es-deprecation-7-transport-profiles-settings", "Remove all [transport.profiles] settings. The Transport client no longer exists in 8.0.", false, null);
    }

    static DeprecationIssue checkDelayClusterStateRecoverySettings(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        ArrayList<Setting> deprecatedSettings = new ArrayList<Setting>();
        deprecatedSettings.add(GatewayService.EXPECTED_NODES_SETTING);
        deprecatedSettings.add(GatewayService.EXPECTED_MASTER_NODES_SETTING);
        deprecatedSettings.add(GatewayService.RECOVER_AFTER_NODES_SETTING);
        deprecatedSettings.add(GatewayService.RECOVER_AFTER_MASTER_NODES_SETTING);
        List existingSettings = deprecatedSettings.stream().filter(deprecatedSetting -> deprecatedSetting.exists(settings)).collect(Collectors.toList());
        if (existingSettings.isEmpty()) {
            return null;
        }
        String settingNames = existingSettings.stream().map(Setting::getKey).collect(Collectors.joining(","));
        String message = String.format(Locale.ROOT, "Delaying cluster state recovery based on the number of available master nodes is not supported", settingNames);
        String details = String.format(Locale.ROOT, "Use gateway.expected_data_nodes to wait for a certain number of data nodes. Remove the following settings or the node will fail to start in 8.0: [%s]", settingNames);
        String url = "https://ela.st/es-deprecation-7-deferred-cluster-state-recovery";
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, "https://ela.st/es-deprecation-7-deferred-cluster-state-recovery", details, false, null);
    }

    static DeprecationIssue checkFixedAutoQueueSizeThreadpool(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        ArrayList<Setting> deprecatedSettings = new ArrayList<Setting>();
        deprecatedSettings.add(Setting.intSetting((String)"thread_pool.search.min_queue_size", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}));
        deprecatedSettings.add(Setting.intSetting((String)"thread_pool.search.max_queue_size", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}));
        deprecatedSettings.add(Setting.intSetting((String)"thread_pool.search.auto_queue_frame_size", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}));
        deprecatedSettings.add(Setting.intSetting((String)"thread_pool.search.target_response_time", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}));
        deprecatedSettings.add(Setting.intSetting((String)"thread_pool.search_throttled.min_queue_size", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}));
        deprecatedSettings.add(Setting.intSetting((String)"thread_pool.search_throttled.max_queue_size", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}));
        deprecatedSettings.add(Setting.intSetting((String)"thread_pool.search_throttled.auto_queue_frame_size", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}));
        deprecatedSettings.add(Setting.intSetting((String)"thread_pool.search_throttled.target_response_time", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}));
        List existingSettings = deprecatedSettings.stream().filter(deprecatedSetting -> deprecatedSetting.exists(settings)).collect(Collectors.toList());
        if (existingSettings.isEmpty()) {
            return null;
        }
        String settingNames = existingSettings.stream().map(Setting::getKey).collect(Collectors.joining(","));
        String message = "The fixed_auto_queue_size threadpool type is not supported";
        String details = String.format(Locale.ROOT, "Remove the following settings or the node will fail to start in 8.0: [%s].", settingNames);
        String url = "https://ela.st/es-deprecation-7-fixed-auto-queue-size-settings";
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "The fixed_auto_queue_size threadpool type is not supported", "https://ela.st/es-deprecation-7-fixed-auto-queue-size-settings", details, false, null);
    }

    static DeprecationIssue checkClusterRoutingRequireSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, DataTierAllocationDecider.CLUSTER_ROUTING_REQUIRE_SETTING, "https://ela.st/es-deprecation-7-tier-filtering-settings", "Use [index.routing.allocation.include._tier_preference] to control allocation to data tiers.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkClusterRoutingIncludeSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, DataTierAllocationDecider.CLUSTER_ROUTING_INCLUDE_SETTING, "https://ela.st/es-deprecation-7-tier-filtering-settings", "Use [index.routing.allocation.include._tier_preference] to control allocation to data tiers.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkClusterRoutingExcludeSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, DataTierAllocationDecider.CLUSTER_ROUTING_EXCLUDE_SETTING, "https://ela.st/es-deprecation-7-tier-filtering-settings", "Use [index.routing.allocation.include._tier_preference] to control allocation to data tiers.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkAcceptDefaultPasswordSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, Setting.boolSetting((String)SecurityField.setting((String)"authc.accept_default_password"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}), "https://ela.st/es-deprecation-7-accept-default-password-setting", "This setting has not had any effect since 6.0.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkAcceptRolesCacheMaxSizeSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, Setting.intSetting((String)SecurityField.setting((String)"authz.store.roles.index.cache.max_size"), (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}), "https://ela.st/es-deprecation-7-roles-index-cache-settings", "Native role cache settings have had no effect since 5.2.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkRolesCacheTTLSizeSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, Setting.timeSetting((String)SecurityField.setting((String)"authz.store.roles.index.cache.ttl"), (TimeValue)TimeValue.timeValueMinutes((long)20L), (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}), "https://ela.st/es-deprecation-7-roles-index-cache-settings", "Native role cache settings have had no effect since 5.2.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkMaxLocalStorageNodesSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, NodeEnvironment.MAX_LOCAL_STORAGE_NODES_SETTING, "https://ela.st/es-deprecation-7-max-local-storage-nodes", "All nodes require local storage in 8.0 and cannot share data paths.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkSamlNameIdFormatSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        String principalKeySuffix = ".attributes.principal";
        List detailsList = SamlRealmSettings.PRINCIPAL_ATTRIBUTE.getAttribute().getAllConcreteSettings(settings).sorted(Comparator.comparing(Setting::getKey)).map(concreteSamlPrincipalSetting -> {
            String realm;
            String concreteNameIdFormatSettingKey;
            String concreteSamlPrincipalSettingKey = concreteSamlPrincipalSetting.getKey();
            int principalKeySuffixIndex = concreteSamlPrincipalSettingKey.indexOf(".attributes.principal");
            if (principalKeySuffixIndex > 0 && settings.get(concreteNameIdFormatSettingKey = (realm = concreteSamlPrincipalSettingKey.substring(0, principalKeySuffixIndex)) + ".nameid_format") == null) {
                return String.format(Locale.ROOT, "Configure \"%s\" for SAML realms: \"%s\".", concreteNameIdFormatSettingKey, realm);
            }
            return null;
        }).filter(detail -> detail != null).collect(Collectors.toList());
        if (detailsList.isEmpty()) {
            return null;
        }
        String message = "The SAML nameid_format is not set and no longer defaults to \"urn:oasis:names:tc:SAML:2.0:nameid-format:transient\"";
        String url = "https://ela.st/es-deprecation-7-saml-nameid-format";
        String details = detailsList.stream().collect(Collectors.joining(" "));
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, url, details, false, null);
    }

    static DeprecationIssue checkScriptContextCache(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        String detail = "Remove the context-specific cache settings and set [script.max_compilations_rate] to configure the rate limit for the general cache. If no limit is set, the rate defaults to 150 compilations per five minutes: 150/5m. Context-specific caches are no longer needed to prevent system scripts from triggering rate limits.";
        if (ScriptService.isUseContextCacheSet((Settings)settings)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Setting [script.max_compilations_rate] to [use-context] is deprecated", "https://ela.st/es-deprecation-7-script-context-cache", detail, false, null);
        }
        if (ScriptService.isImplicitContextCacheSet((Settings)settings)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, ScriptService.contextDeprecationMessage((Settings)settings), "https://ela.st/es-deprecation-7-script-context-cache", detail, false, null);
        }
        return null;
    }

    static DeprecationIssue checkScriptContextCompilationsRateLimitSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting.AffixSetting maxSetting = ScriptService.SCRIPT_MAX_COMPILATIONS_RATE_SETTING;
        Set contextCompilationRates = maxSetting.getAsMap(settings).keySet();
        if (!contextCompilationRates.isEmpty()) {
            String maxSettings = contextCompilationRates.stream().sorted().map(c -> maxSetting.getConcreteSettingForNamespace(c).getKey()).collect(Collectors.joining(","));
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Setting a context-specific rate limit is deprecated", "https://ela.st/es-deprecation-7-script-context-cache", String.format(Locale.ROOT, "Remove the context-specific rate limit settings: [%s]. Instead, set [%s] to configure the rate limit for the general cache.  If no limit is set, the rate defaults to 150 compilations per five minutes: 150/5m. Context-specific caches are no longer needed to prevent system scripts from triggering rate limits.", maxSettings, ScriptService.SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.getKey()), false, null);
        }
        return null;
    }

    static DeprecationIssue checkScriptContextCacheSizeSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting.AffixSetting cacheSizeSetting = ScriptService.SCRIPT_CACHE_SIZE_SETTING;
        Set contextCacheSizes = cacheSizeSetting.getAsMap(settings).keySet();
        if (!contextCacheSizes.isEmpty()) {
            String cacheSizeSettings = contextCacheSizes.stream().sorted().map(c -> cacheSizeSetting.getConcreteSettingForNamespace(c).getKey()).collect(Collectors.joining(","));
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Setting a context-specific cache size is deprecated", "https://ela.st/es-deprecation-7-script-context-cache", String.format(Locale.ROOT, "Remove the context-specific cache size settings: [%s]. Instead, set [script.cache_max_size] to configure the size of the general cache. Context-specific caches are no longer needed to prevent system scripts from triggering rate limits.", cacheSizeSettings), false, null);
        }
        return null;
    }

    static DeprecationIssue checkScriptContextCacheExpirationSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting.AffixSetting cacheExpireSetting = ScriptService.SCRIPT_CACHE_EXPIRE_SETTING;
        Set contextCacheExpires = cacheExpireSetting.getAsMap(settings).keySet();
        if (!contextCacheExpires.isEmpty()) {
            String cacheExpireSettings = contextCacheExpires.stream().sorted().map(c -> cacheExpireSetting.getConcreteSettingForNamespace(c).getKey()).collect(Collectors.joining(","));
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Setting a context-specific cache expiration is deprecated", "https://ela.st/es-deprecation-7-script-context-cache", String.format(Locale.ROOT, "Remove the context-specific cache expiration settings: [%s]. Instead, set [script.cache.expire] to configure the expiration of the general cache. Context-specific caches are no longer needed to prevent system scripts from triggering rate limits.", cacheExpireSettings), false, null);
        }
        return null;
    }

    private static DeprecationIssue deprecatedAffixSetting(Setting.AffixSetting<?> deprecatedAffixSetting, String detailPattern, String url, DeprecationIssue.Level warningLevel, Settings settings) {
        List deprecatedConcreteSettings = deprecatedAffixSetting.getAllConcreteSettings(settings).sorted(Comparator.comparing(Setting::getKey)).collect(Collectors.toList());
        if (deprecatedConcreteSettings.isEmpty()) {
            return null;
        }
        String concatSettingNames = deprecatedConcreteSettings.stream().map(Setting::getKey).collect(Collectors.joining(","));
        String message = String.format(Locale.ROOT, "The [%s] settings are deprecated and will be removed after 8.0", concatSettingNames);
        String details = String.format(Locale.ROOT, detailPattern, concatSettingNames);
        return new DeprecationIssue(warningLevel, message, url, details, false, null);
    }

    private static DeprecationIssue deprecatedAffixGroupedSetting(Setting.AffixSetting<Settings> deprecatedAffixSetting, String detailPattern, String url, DeprecationIssue.Level warningLevel, Settings settings) {
        List deprecatedConcreteSettings = deprecatedAffixSetting.getAllConcreteSettings(settings).sorted(Comparator.comparing(Setting::getKey)).collect(Collectors.toList());
        if (deprecatedConcreteSettings.isEmpty()) {
            return null;
        }
        String groupSettingNames = deprecatedConcreteSettings.stream().map(Setting::getKey).map(key -> key + "*").collect(Collectors.joining(","));
        String allSubSettings = deprecatedConcreteSettings.stream().map(affixSetting -> {
            String groupPrefix = affixSetting.getKey();
            Settings groupSettings = (Settings)affixSetting.get(settings);
            Set subSettings = groupSettings.keySet();
            return subSettings.stream().map(key -> groupPrefix + key).collect(Collectors.joining(","));
        }).collect(Collectors.joining(";"));
        String message = String.format(Locale.ROOT, "The [%s] settings are deprecated and will be removed after 8.0", groupSettingNames);
        String details = String.format(Locale.ROOT, detailPattern, allSubSettings);
        return new DeprecationIssue(warningLevel, message, url, details, false, null);
    }

    static DeprecationIssue genericMonitoringSetting(Settings settings, Setting<?> deprecated) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, deprecated, MONITORING_SETTING_DEPRECATION_LINK);
    }

    static DeprecationIssue genericMonitoringAffixSetting(Settings settings, String deprecatedSuffix) {
        return NodeDeprecationChecks.deprecatedAffixSetting(Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)deprecatedSuffix, x$0 -> Setting.simpleString((String)x$0, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]), "Remove the following settings from elasticsearch.yml: [%s]", MONITORING_SETTING_DEPRECATION_LINK, DeprecationIssue.Level.WARNING, settings);
    }

    static DeprecationIssue genericMonitoringAffixSecureSetting(Settings settings, String deprecatedSuffix) {
        return NodeDeprecationChecks.deprecatedAffixSetting(Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)deprecatedSuffix, k -> SecureSetting.secureString((String)k, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]), "Remove the following settings from the keystore: [%s]", MONITORING_SETTING_DEPRECATION_LINK, DeprecationIssue.Level.WARNING, settings);
    }

    static DeprecationIssue genericMonitoringAffixGroupedSetting(Settings settings, String deprecatedSuffix) {
        return NodeDeprecationChecks.deprecatedAffixGroupedSetting((Setting.AffixSetting<Settings>)Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)deprecatedSuffix, k -> Setting.groupSetting((String)(k + "."), (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]), "Remove the following settings from elasticsearch.yml: [%s]", MONITORING_SETTING_DEPRECATION_LINK, DeprecationIssue.Level.WARNING, settings);
    }

    static DeprecationIssue checkMonitoringSettingHistoryDuration(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.history.duration", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectIndexRecovery(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.index.recovery.active_only", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectIndices(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.indices", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectCcrTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.ccr.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectEnrichStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.enrich.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectIndexRecoveryStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.index.recovery.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectIndexStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.index.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectMlJobStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.ml.job.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectNodeStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.node.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectClusterStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.cluster.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingExportersHost(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "host");
    }

    static DeprecationIssue checkMonitoringSettingExportersBulkTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "bulk.timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersConnectionTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "connection.timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersConnectionReadTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "connection.read_timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersAuthUsername(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "auth.username");
    }

    static DeprecationIssue checkMonitoringSettingExportersAuthPass(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSecureSetting(settings, "auth.secure_password");
    }

    static DeprecationIssue checkMonitoringSettingExportersSSL(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixGroupedSetting(settings, "ssl");
    }

    static DeprecationIssue checkMonitoringSettingExportersProxyBase(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "proxy.base_path");
    }

    static DeprecationIssue checkMonitoringSettingExportersSniffEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "sniff.enabled");
    }

    static DeprecationIssue checkMonitoringSettingExportersHeaders(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixGroupedSetting(settings, "headers");
    }

    static DeprecationIssue checkMonitoringSettingExportersTemplateTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "index.template.master_timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersMasterTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "wait_master.timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "enabled");
    }

    static DeprecationIssue checkMonitoringSettingExportersType(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "type");
    }

    static DeprecationIssue checkMonitoringSettingExportersAlertsEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "cluster_alerts.management.enabled");
    }

    static DeprecationIssue checkMonitoringSettingExportersAlertsBlacklist(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "cluster_alerts.management.blacklist");
    }

    static DeprecationIssue checkMonitoringSettingExportersIndexNameTimeFormat(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(settings, "index.name.time_format");
    }

    static DeprecationIssue checkMonitoringSettingDecommissionAlerts(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.migration.decommission_alerts", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingEsCollectionEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.elasticsearch.collection.enabled", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectionEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.enabled", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectionInterval(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(settings, Setting.simpleString((String)"xpack.monitoring.collection.interval", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkExporterUseIngestPipelineSettings(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.deprecatedAffixSetting(Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"use_ingest", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]), "Remove the following settings from elasticsearch.yml: [%s]", "https://ela.st/es-deprecation-7-monitoring-exporter-use-ingest-setting", DeprecationIssue.Level.WARNING, settings);
    }

    static DeprecationIssue checkExporterPipelineMasterTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.deprecatedAffixSetting(Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.pipeline.master_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]), "Remove the following settings from elasticsearch.yml: [%s]", "https://ela.st/es-deprecation-7-monitoring-exporter-pipeline-timeout-setting", DeprecationIssue.Level.WARNING, settings);
    }

    static DeprecationIssue checkExporterCreateLegacyTemplateSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.deprecatedAffixSetting(Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.template.create_legacy_templates", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]), "Remove the following settings from elasticsearch.yml: [%s]", "https://ela.st/es-deprecation-7-monitoring-exporter-create-legacy-template-setting", DeprecationIssue.Level.WARNING, settings);
    }

    static DeprecationIssue checkSettingNoReplacement(Settings settings, Setting<?> deprecatedSetting, String url) {
        assert (deprecatedSetting.isDeprecated()) : deprecatedSetting;
        if (!deprecatedSetting.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", deprecatedSettingKey);
        String details = String.format(Locale.ROOT, "Remove the [%s] setting.", deprecatedSetting.getKey());
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
    }

    static DeprecationIssue checkReroutePrioritySetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ShardStateAction.FOLLOW_UP_REROUTE_PRIORITY_SETTING;
        String url = "https://ela.st/es-deprecation-7-reroute-priority-setting";
        return NodeDeprecationChecks.checkRemovedSetting(settings, deprecatedSetting, url, "In a future release this setting will have no effect and the priority will always be NORMAL.");
    }

    static DeprecationIssue checkZenBwcPingTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = DiscoveryUpgradeService.BWC_PING_TIMEOUT_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenUnsafeBootstrappingOnUpgradeSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = DiscoveryUpgradeService.ENABLE_UNSAFE_BOOTSTRAPPING_ON_UPGRADE_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenCommitTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = DiscoverySettings.COMMIT_TIMEOUT_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPublishDiffEnableSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = DiscoverySettings.PUBLISH_DIFF_ENABLE_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenConnectOnNetworkDisconnectSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = FaultDetection.CONNECT_ON_NETWORK_DISCONNECT_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPingIntervalSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = FaultDetection.PING_INTERVAL_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenFDPingTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = FaultDetection.PING_TIMEOUT_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPingRetriesSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = FaultDetection.PING_RETRIES_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenRegisterConnectionListenerSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = FaultDetection.REGISTER_CONNECTION_LISTENER_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenMinimumMasterNodesSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenHostsProviderSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = DiscoveryModule.LEGACY_DISCOVERY_HOSTS_PROVIDER_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenJoinRetryAttemptsSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ZenDiscovery.JOIN_RETRY_ATTEMPTS_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenJoinRetryDelaySetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ZenDiscovery.JOIN_RETRY_DELAY_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenJoinTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ZenDiscovery.JOIN_TIMEOUT_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenMasterElectionIgnoreNonMasterPingsSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ZenDiscovery.MASTER_ELECTION_IGNORE_NON_MASTER_PINGS_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenMasterElectionWaitForJoinsTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ZenDiscovery.MASTER_ELECTION_WAIT_FOR_JOINS_TIMEOUT_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenMaxPingsFromAnotherMasterSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ZenDiscovery.MAX_PINGS_FROM_ANOTHER_MASTER_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenNoMasterBlockSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = NoMasterBlockService.LEGACY_NO_MASTER_BLOCK_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPintUnicastConcurrentConnectssSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = SeedHostsResolver.LEGACY_DISCOVERY_ZEN_PING_UNICAST_CONCURRENT_CONNECTS_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPingUnicastHostsSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = SettingsBasedSeedHostsProvider.LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPingUnicastHostsResolveTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = SeedHostsResolver.LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_RESOLVE_TIMEOUT;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPingTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ZenDiscovery.PING_TIMEOUT_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPublishMaxPendingClusterStatesSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ZenDiscovery.MAX_PENDING_CLUSTER_STATES_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPublishTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = DiscoverySettings.PUBLISH_TIMEOUT_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkZenPingSendLeaveRequestSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = ZenDiscovery.SEND_LEAVE_REQUEST_SETTING;
        String url = "https://ela.st/es-deprecation-7-unused_zen_settings";
        return NodeDeprecationChecks.checkSettingNoReplacement(settings, deprecatedSetting, url);
    }

    static DeprecationIssue checkAutoImportDanglingIndicesSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = DanglingIndicesState.AUTO_IMPORT_DANGLING_INDICES_SETTING;
        String url = "https://ela.st/es-deprecation-7-auto-import-dangling-indices-setting";
        return NodeDeprecationChecks.checkRemovedSetting(settings, deprecatedSetting, url, "Use of this setting is unsafe.");
    }

    static DeprecationIssue checkHttpContentTypeRequiredSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = HttpTransportSettings.SETTING_HTTP_CONTENT_TYPE_REQUIRED;
        String url = "https://ela.st/es-deprecation-7-http-content-type-required-setting";
        return NodeDeprecationChecks.checkRemovedSetting(settings, deprecatedSetting, url, "This setting no longer has any effect.");
    }

    static DeprecationIssue checkFsRepositoryCompressionSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = FsRepository.REPOSITORIES_COMPRESS_SETTING;
        Setting replacementSetting = FsRepository.COMPRESS_SETTING;
        String url = "https://ela.st/es-deprecation-7-filesystem-repository-compression-setting";
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, url);
    }

    static DeprecationIssue checkHttpTcpNoDelaySetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = HttpTransportSettings.OLD_SETTING_HTTP_TCP_NO_DELAY;
        Setting replacementSetting = HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY;
        String url = "https://ela.st/es-deprecation-7-transport-settings";
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, url);
    }

    static DeprecationIssue checkNetworkTcpConnectTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = NetworkService.TCP_CONNECT_TIMEOUT;
        Setting replacementSetting = TransportSettings.CONNECT_TIMEOUT;
        String url = "https://ela.st/es-deprecation-7-transport-settings";
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, url);
    }

    static DeprecationIssue checkTransportTcpConnectTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = TransportSettings.TCP_CONNECT_TIMEOUT;
        Setting replacementSetting = TransportSettings.CONNECT_TIMEOUT;
        String url = "https://ela.st/es-deprecation-7-transport-settings";
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, url);
    }

    static DeprecationIssue checkTransportPortSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = TransportSettings.OLD_PORT;
        Setting replacementSetting = TransportSettings.PORT;
        String url = "https://ela.st/es-deprecation-7-transport-settings";
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, url);
    }

    static DeprecationIssue checkTcpNoDelaySetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = TransportSettings.OLD_TCP_NO_DELAY;
        Setting replacementSetting = TransportSettings.TCP_NO_DELAY;
        String url = "https://ela.st/es-deprecation-7-transport-settings";
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, url);
    }

    static DeprecationIssue checkTransportCompressSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = TransportSettings.OLD_TRANSPORT_COMPRESS;
        Setting replacementSetting = TransportSettings.TRANSPORT_COMPRESS;
        String url = "https://ela.st/es-deprecation-7-transport-settings";
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, deprecatedSetting, replacementSetting, url);
    }

    static DeprecationIssue checkXpackDataFrameEnabledSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = Setting.boolSetting((String)"xpack.data_frame.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
        String url = "https://ela.st/es-deprecation-7-xpack-dataframe-setting";
        return NodeDeprecationChecks.checkRemovedSetting(settings, deprecatedSetting, url, "As of 7.9.2 basic license level features are always enabled.");
    }

    static DeprecationIssue checkWatcherHistoryCleanerServiceSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = Monitoring.CLEAN_WATCHER_HISTORY;
        String url = "https://ela.st/es-deprecation-7-watcher-history-cleaner-setting";
        return NodeDeprecationChecks.checkRemovedSetting(settings, deprecatedSetting, url, "Watcher history indices are now managed by the watch-history-ilm-policy ILM policy.");
    }

    static DeprecationIssue checkLifecyleStepMasterTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = LifecycleSettings.LIFECYCLE_STEP_MASTER_TIMEOUT_SETTING;
        String url = "https://ela.st/es-deprecation-7-lifecycle-master-timeout-setting";
        return NodeDeprecationChecks.checkRemovedSetting(settings, deprecatedSetting, url, "As of 7.16 the timeout is always infinite.", DeprecationIssue.Level.WARNING);
    }

    static DeprecationIssue checkEqlEnabledSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = Setting.boolSetting((String)"xpack.eql.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.DeprecatedWarning});
        String url = "https://ela.st/es-deprecation-7-eql-enabled-setting";
        return NodeDeprecationChecks.checkRemovedSetting(settings, deprecatedSetting, url, "As of 7.9.2 basic license level features are always enabled.", DeprecationIssue.Level.WARNING);
    }
}

