/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.IOException;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.TerminalPolicyStep;
import org.elasticsearch.xpack.ilm.IndexLifecycleClusterStateUpdateTask;
import org.elasticsearch.xpack.ilm.IndexLifecycleRunner;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;
import org.elasticsearch.xpack.ilm.PolicyStepsRegistry;

public class ExecuteStepsUpdateTask
extends IndexLifecycleClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(ExecuteStepsUpdateTask.class);
    private final String policy;
    private final Step startStep;
    private final PolicyStepsRegistry policyStepsRegistry;
    private final IndexLifecycleRunner lifecycleRunner;
    private final LongSupplier nowSupplier;
    private Step.StepKey nextStepKey = null;
    private Exception failure = null;

    public ExecuteStepsUpdateTask(String policy, Index index, Step startStep, PolicyStepsRegistry policyStepsRegistry, IndexLifecycleRunner lifecycleRunner, LongSupplier nowSupplier) {
        super(index, startStep.getKey());
        this.policy = policy;
        this.startStep = startStep;
        this.policyStepsRegistry = policyStepsRegistry;
        this.nowSupplier = nowSupplier;
        this.lifecycleRunner = lifecycleRunner;
    }

    String getPolicy() {
        return this.policy;
    }

    Step getStartStep() {
        return this.startStep;
    }

    Step.StepKey getNextStepKey() {
        return this.nextStepKey;
    }

    @Override
    public ClusterState doExecute(ClusterState currentState) throws IOException {
        Step currentStep = this.startStep;
        IndexMetadata indexMetadata = currentState.metadata().index(this.index);
        if (indexMetadata == null) {
            logger.debug("lifecycle for index [{}] executed but index no longer exists", (Object)this.index.getName());
            return currentState;
        }
        Step registeredCurrentStep = IndexLifecycleRunner.getCurrentStep(this.policyStepsRegistry, this.policy, indexMetadata);
        if (currentStep.equals((Object)registeredCurrentStep)) {
            ClusterState state = currentState;
            while (currentStep instanceof ClusterStateActionStep || currentStep instanceof ClusterStateWaitStep) {
                if (currentStep instanceof ClusterStateActionStep) {
                    logger.trace("[{}] performing cluster state action ({}) [{}]", (Object)this.index.getName(), (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey());
                    try {
                        state = ((ClusterStateActionStep)currentStep).performAction(this.index, state);
                    }
                    catch (Exception exception) {
                        return this.moveToErrorStep(state, currentStep.getKey(), exception);
                    }
                    this.nextStepKey = currentStep.getNextStepKey();
                    if (this.nextStepKey == null) {
                        return state;
                    }
                    logger.trace("[{}] moving cluster state to next step [{}]", (Object)this.index.getName(), (Object)this.nextStepKey);
                    state = IndexLifecycleTransition.moveClusterStateToStep(this.index, state, this.nextStepKey, this.nowSupplier, this.policyStepsRegistry, false);
                } else {
                    ClusterStateWaitStep.Result result;
                    logger.trace("[{}] waiting for cluster state step condition ({}) [{}]", (Object)this.index.getName(), (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey());
                    try {
                        result = ((ClusterStateWaitStep)currentStep).isConditionMet(this.index, state);
                    }
                    catch (Exception exception) {
                        return this.moveToErrorStep(state, currentStep.getKey(), exception);
                    }
                    this.nextStepKey = currentStep.getNextStepKey();
                    if (result.isComplete()) {
                        logger.trace("[{}] cluster state step condition met successfully ({}) [{}], moving to next step {}", (Object)this.index.getName(), (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey(), (Object)this.nextStepKey);
                        if (this.nextStepKey == null) {
                            return state;
                        }
                        state = IndexLifecycleTransition.moveClusterStateToStep(this.index, state, this.nextStepKey, this.nowSupplier, this.policyStepsRegistry, false);
                    } else {
                        ToXContentObject stepInfo = result.getInfomationContext();
                        if (logger.isTraceEnabled()) {
                            logger.trace("[{}] condition not met ({}) [{}], returning existing state (info: {})", (Object)this.index.getName(), (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey(), (Object)(stepInfo == null ? "null" : Strings.toString((ToXContent)stepInfo)));
                        }
                        this.nextStepKey = null;
                        if (stepInfo == null) {
                            return state;
                        }
                        return IndexLifecycleTransition.addStepInfoToClusterState(this.index, state, stepInfo);
                    }
                }
                if (!currentStep.getKey().getPhase().equals(currentStep.getNextStepKey().getPhase())) {
                    return state;
                }
                currentStep = this.policyStepsRegistry.getStep(indexMetadata, currentStep.getNextStepKey());
            }
            return state;
        }
        return currentState;
    }

    @Override
    public void onClusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
        IndexMetadata indexMetadata = newState.metadata().index(this.index);
        if (indexMetadata != null) {
            LifecycleExecutionState exState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
            if ("ERROR".equals(exState.getStep()) && this.failure != null) {
                this.lifecycleRunner.registerFailedOperation(indexMetadata, this.failure);
            } else {
                this.lifecycleRunner.registerSuccessfulOperation(indexMetadata);
            }
            if (this.nextStepKey != null && this.nextStepKey != TerminalPolicyStep.KEY) {
                logger.trace("[{}] step sequence starting with {} has completed, running next step {} if it is an async action", (Object)this.index.getName(), (Object)this.startStep.getKey(), (Object)this.nextStepKey);
                this.lifecycleRunner.maybeRunAsyncAction(newState, indexMetadata, this.policy, this.nextStepKey);
            }
        }
    }

    @Override
    public void handleFailure(String source, Exception e) {
        logger.warn((Message)new ParameterizedMessage("policy [{}] for index [{}] failed on step [{}].", new Object[]{this.policy, this.index, this.startStep.getKey()}), (Throwable)e);
    }

    private ClusterState moveToErrorStep(ClusterState state, Step.StepKey currentStepKey, Exception cause) throws IOException {
        this.failure = cause;
        logger.warn("policy [{}] for index [{}] failed on cluster state step [{}]. Moving to ERROR step", (Object)this.policy, (Object)this.index.getName(), (Object)currentStepKey);
        return IndexLifecycleTransition.moveClusterStateToErrorStep(this.index, state, cause, this.nowSupplier, this.policyStepsRegistry::getStep);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteStepsUpdateTask that = (ExecuteStepsUpdateTask)o;
        return this.policy.equals(that.policy) && this.index.equals((Object)that.index) && Objects.equals(this.startStep, that.startStep);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.policy, this.index, this.startStep);
    }
}

