/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.math3.distribution.TDistribution;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.analytics.ttest.TTestState;
import org.elasticsearch.xpack.analytics.ttest.TTestStats;

public class PairedTTestState
implements TTestState {
    public static final String NAME = "P";
    private final TTestStats stats;
    private final int tails;

    public PairedTTestState(TTestStats stats, int tails) {
        this.stats = stats;
        this.tails = tails;
    }

    public PairedTTestState(StreamInput in) throws IOException {
        this.stats = new TTestStats(in);
        this.tails = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.stats.writeTo(out);
        out.writeVInt(this.tails);
    }

    @Override
    public double getValue() {
        if (this.stats.count < 2L) {
            return Double.NaN;
        }
        long n = this.stats.count - 1L;
        double meanDiff = this.stats.sum / (double)this.stats.count;
        double variance = (this.stats.sumOfSqrs - this.stats.sum * this.stats.sum / (double)this.stats.count) / (double)this.stats.count;
        if (variance <= 0.0) {
            return meanDiff == 0.0 ? Double.NaN : 0.0;
        }
        double stdDiv = Math.sqrt(variance);
        double stdErr = stdDiv / Math.sqrt(n);
        double t = Math.abs(meanDiff / stdErr);
        TDistribution dist = new TDistribution((double)n);
        return dist.cumulativeProbability(-t) * (double)this.tails;
    }

    @Override
    public TTestState reduce(Stream<TTestState> states) {
        TTestStats.Reducer reducer = new TTestStats.Reducer();
        states.forEach(tTestState -> {
            PairedTTestState state = (PairedTTestState)tTestState;
            reducer.accept(state.stats);
            if (state.tails != this.tails) {
                throw new IllegalStateException("Incompatible tails value in the reduce. Expected " + state.tails + " reduced with " + this.tails);
            }
        });
        return new PairedTTestState(reducer.result(), this.tails);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PairedTTestState that = (PairedTTestState)o;
        return this.tails == that.tails && this.stats.equals(that.stats);
    }

    public int hashCode() {
        return Objects.hash(this.stats, this.tails);
    }
}

