#!/bin/sh
echo "falconenv.sh -- Settings the environment to run Falcon test install"

if [ -z "$1" ]; then
   echo "Please, specify a command to run in shell"
   echo
   echo "To run falcon or another falcon command: falconenv.sh falcon ..."
   echo "To run a shell: falconenv.sh /bin/bash  (or another shell)"
   exit 1
fi

script_dir=`dirname $0`
curdir=`pwd`
cd $script_dir
script_dir=`pwd`
cd $curdir

echo "Script detected in $script_dir"
#discard everything past the install prefix -- retaining what comes before
root_prefix=/opt/local
# but first escape the path separators so that next sed is not confused.
root_prefix_escape=`echo $root_prefix | sed -e 's/\\//\\\\\\//g'`
root_path=`echo $script_dir | sed -e "s/$root_prefix_escape.*/$root_prefix_escape/"`

# We have our root path
echo "Falcon root path set to $root_path"

LIBDIR=lib
MODDIR=lib/falcon
BINDIR=bin

# Communicate with falcon that we're in a test environment.
FALCON_ENV_DIR=$root_path

PATH=$root_path/$BINDIR:$PATH
echo "System path set to $PATH"

LD_LIBRARY_PATH=$root_path/$LIBDIR:$LD_LIBRARY_PATH
echo "System LD path set to $LD_LIBRARY_PATH"

#complains with MacOSX
DYLD_LIBRARY_PATH=$LD_LIBRARY_PATH

#And this is for falcon
FALCON_LOAD_PATH=".;$root_path/$MODDIR"

export FALCON_ENV_DIR
export PATH
export LD_LIBRARY_PATH
export DYLD_LIBRARY_PATH
export FALCON_LOAD_PATH

echo
echo "Starting requested command: $*"
echo

$*
