/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* TypeDef Declarations                                                       *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_TYPEDEF_CLASSES
#undef GET_TYPEDEF_CLASSES


namespace mlir {
class DialectAsmParser;
class DialectAsmPrinter;
} // namespace mlir
namespace fir {
  class BoxCharType;
  class BoxProcType;
  class BoxType;
  class CharacterType;
  class ComplexType;
  class FieldType;
  class HeapType;
  class IntegerType;
  class LenType;
  class LogicalType;
  class PointerType;
  class RealType;
  class RecordType;
  class ReferenceType;
  class SequenceType;
  class ShapeShiftType;
  class ShapeType;
  class ShiftType;
  class SliceType;
  class TypeDescType;
  class VectorType;
  class VoidType;

  namespace detail {
    struct BoxCharTypeStorage;
  } // end namespace detail
  class BoxCharType : public ::mlir::Type::TypeBase<BoxCharType, ::mlir::Type,
                                         detail::BoxCharTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    using KindTy = unsigned;

    // a !fir.boxchar<k> always wraps a !fir.char<k, ?>
    CharacterType getElementType(mlir::MLIRContext *context) const;

    CharacterType getEleTy() const;
  
    static BoxCharType get(::mlir::MLIRContext *context, KindTy kind);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("boxchar");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    KindTy getKind() const;
  };

  namespace detail {
    struct BoxProcTypeStorage;
  } // end namespace detail
  class BoxProcType : public ::mlir::Type::TypeBase<BoxProcType, ::mlir::Type,
                                         detail::BoxProcTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;

    static BoxProcType get(::mlir::MLIRContext *context, mlir::Type eleTy);
    static BoxProcType getChecked(llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, mlir::Type eleTy);

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("boxproc");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    mlir::Type getEleTy() const;
  };

  namespace detail {
    struct BoxTypeStorage;
  } // end namespace detail
  class BoxType : public ::mlir::Type::TypeBase<BoxType, ::mlir::Type,
                                         detail::BoxTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    mlir::Type getElementType() const { return getEleTy(); }
    mlir::AffineMapAttr getLayoutMap() const { return getMap(); }
  
    static BoxType get(mlir::Type eleTy, mlir::AffineMapAttr map = {});
    static BoxType getChecked(llvm::function_ref<mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, mlir::AffineMapAttr map = {});

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, mlir::AffineMapAttr map);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("box");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    mlir::Type getEleTy() const;
    mlir::AffineMapAttr getMap() const;
  };

  namespace detail {
    struct CharacterTypeStorage;
  } // end namespace detail
  class CharacterType : public ::mlir::Type::TypeBase<CharacterType, ::mlir::Type,
                                         detail::CharacterTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    using KindTy = unsigned;
    using LenType = std::int64_t;

    /// Return unknown length Character type. e.g., CHARACTER(LEN=n).
    static CharacterType getUnknownLen(mlir::MLIRContext *ctxt, KindTy kind) {
      return get(ctxt, kind, unknownLen());
    }

    /// Return length 1 Character type. e.g., CHARACTER(LEN=1).
    static CharacterType getSingleton(mlir::MLIRContext *ctxt, KindTy kind) {
      return get(ctxt, kind, singleton());
    }

    /// Character is a singleton and has a LEN of 1.
    static constexpr LenType singleton() { return 1; }

    /// Character has a LEN value which is not a compile-time known constant.
    static constexpr LenType unknownLen() { return -1; }

    /// Character LEN is a runtime value.
    bool hasDynamicLen() { return getLen() == unknownLen(); }

    /// Character LEN is a compile-time cpnstant value.
    bool hasConstantLen() { return !hasDynamicLen(); }
  
    static CharacterType get(::mlir::MLIRContext *context, KindTy FKind, CharacterType::LenType len);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("char");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    KindTy getFKind() const;
    CharacterType::LenType getLen() const;
  };

  namespace detail {
    struct ComplexTypeStorage;
  } // end namespace detail
  class ComplexType : public ::mlir::Type::TypeBase<ComplexType, ::mlir::Type,
                                         detail::ComplexTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    using KindTy = unsigned;

    mlir::Type getElementType() const;
  
    static ComplexType get(::mlir::MLIRContext *context, KindTy fKind);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("complex");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    KindTy getFKind() const;
  };

  class FieldType : public ::mlir::Type::TypeBase<FieldType, ::mlir::Type, ::mlir::TypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("field");
    }
  };

  namespace detail {
    struct HeapTypeStorage;
  } // end namespace detail
  class HeapType : public ::mlir::Type::TypeBase<HeapType, ::mlir::Type,
                                         detail::HeapTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;

    static HeapType get(mlir::Type elementType);
    static HeapType getChecked(llvm::function_ref<mlir::InFlightDiagnostic()> emitError, mlir::Type elementType);

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("heap");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    mlir::Type getEleTy() const;
  };

  namespace detail {
    struct IntegerTypeStorage;
  } // end namespace detail
  class IntegerType : public ::mlir::Type::TypeBase<IntegerType, ::mlir::Type,
                                         detail::IntegerTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    using KindTy = unsigned;
  
    static IntegerType get(::mlir::MLIRContext *context, KindTy fKind);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("int");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    KindTy getFKind() const;
  };

  class LenType : public ::mlir::Type::TypeBase<LenType, ::mlir::Type, ::mlir::TypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("len");
    }
  };

  namespace detail {
    struct LogicalTypeStorage;
  } // end namespace detail
  class LogicalType : public ::mlir::Type::TypeBase<LogicalType, ::mlir::Type,
                                         detail::LogicalTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    using KindTy = unsigned;
  
    static LogicalType get(::mlir::MLIRContext *context, KindTy fKind);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("logical");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    KindTy getFKind() const;
  };

  namespace detail {
    struct PointerTypeStorage;
  } // end namespace detail
  class PointerType : public ::mlir::Type::TypeBase<PointerType, ::mlir::Type,
                                         detail::PointerTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    mlir::Type getElementType() const { return getEleTy(); }
  
    static PointerType get(mlir::Type elementType);
    static PointerType getChecked(llvm::function_ref<mlir::InFlightDiagnostic()> emitError, mlir::Type elementType);

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("ptr");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    mlir::Type getEleTy() const;
  };

  namespace detail {
    struct RealTypeStorage;
  } // end namespace detail
  class RealType : public ::mlir::Type::TypeBase<RealType, ::mlir::Type,
                                         detail::RealTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    using KindTy = unsigned;
  
    static RealType get(::mlir::MLIRContext *context, KindTy fKind);
    static RealType getChecked(llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, KindTy fKind);

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, KindTy fKind);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("real");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    KindTy getFKind() const;
  };

  namespace detail {
    struct RecordTypeStorage;
  } // end namespace detail
  class RecordType : public ::mlir::Type::TypeBase<RecordType, ::mlir::Type,
                                         detail::RecordTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    using TypePair = std::pair<std::string, mlir::Type>;
    using TypeList = std::vector<TypePair>;
    TypeList getTypeList() const;
    TypeList getLenParamList() const;

    mlir::Type getType(llvm::StringRef ident);
    // Returns the index of the field \p ident in the type list.
    // Returns maximum unsigned if ident is not a field of this RecordType.
    unsigned getFieldIndex(llvm::StringRef ident);
    mlir::Type getType(unsigned index) {
      assert(index < getNumFields());
      return getTypeList()[index].second;
    }
    unsigned getNumFields() { return getTypeList().size(); }
    unsigned getNumLenParams() { return getLenParamList().size(); }

    void finalize(llvm::ArrayRef<TypePair> lenPList,
                  llvm::ArrayRef<TypePair> typeList);

    detail::RecordTypeStorage const *uniqueKey() const;
  
    static RecordType get(::mlir::MLIRContext *context, ::llvm::StringRef name);
    static RecordType getChecked(llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::StringRef name);

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::StringRef name);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("type");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    ::llvm::StringRef getName() const;
  };

  namespace detail {
    struct ReferenceTypeStorage;
  } // end namespace detail
  class ReferenceType : public ::mlir::Type::TypeBase<ReferenceType, ::mlir::Type,
                                         detail::ReferenceTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    mlir::Type getElementType() const { return getEleTy(); }
  
    static ReferenceType get(mlir::Type elementType);
    static ReferenceType getChecked(llvm::function_ref<mlir::InFlightDiagnostic()> emitError, mlir::Type elementType);

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("ref");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    mlir::Type getEleTy() const;
  };

  namespace detail {
    struct SequenceTypeStorage;
  } // end namespace detail
  class SequenceType : public ::mlir::Type::TypeBase<SequenceType, ::mlir::Type,
                                         detail::SequenceTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    using Extent = int64_t;
    using Shape = llvm::SmallVector<Extent, 8>;
    using ShapeRef = llvm::ArrayRef<int64_t>;
    unsigned getConstantRows() const;

    // The number of dimensions of the sequence
    unsigned getDimension() const { return getShape().size(); }

    // Is the interior of the sequence constant? Check if the array is
    // one of constant shape (`array<C...xCxT>`), unknown shape
    // (`array<*xT>`), or rows with shape and ending with column(s) of
    // unknown extent (`array<C...xCx?...x?xT>`).
    bool hasConstantInterior() const;

    // Is the shape of the sequence constant?
    bool hasConstantShape() const { return getConstantRows() == getDimension(); }

    // Does the sequence have unknown shape? (`array<* x T>`)
    bool hasUnknownShape() const { return getShape().empty(); }

    // The value `-1` represents an unknown extent for a dimension
    static constexpr Extent getUnknownExtent() { return -1; }
  
    static SequenceType get(::mlir::MLIRContext *context, ::llvm::ArrayRef<int64_t> shape, mlir::Type eleTy, mlir::AffineMapAttr layoutMap);
    static SequenceType getChecked(llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::ArrayRef<int64_t> shape, mlir::Type eleTy, mlir::AffineMapAttr layoutMap);
    static SequenceType get(llvm::ArrayRef<int64_t> shape, mlir::Type eleTy);
    static SequenceType getChecked(llvm::function_ref<mlir::InFlightDiagnostic()> emitError, llvm::ArrayRef<int64_t> shape, mlir::Type eleTy);

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::ArrayRef<int64_t> shape, mlir::Type eleTy, mlir::AffineMapAttr layoutMap);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("array");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    ::llvm::ArrayRef<int64_t> getShape() const;
    mlir::Type getEleTy() const;
    mlir::AffineMapAttr getLayoutMap() const;
  };

  namespace detail {
    struct ShapeShiftTypeStorage;
  } // end namespace detail
  class ShapeShiftType : public ::mlir::Type::TypeBase<ShapeShiftType, ::mlir::Type,
                                         detail::ShapeShiftTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;

    static ShapeShiftType get(::mlir::MLIRContext *context, unsigned rank);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("shapeshift");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    unsigned getRank() const;
  };

  namespace detail {
    struct ShapeTypeStorage;
  } // end namespace detail
  class ShapeType : public ::mlir::Type::TypeBase<ShapeType, ::mlir::Type,
                                         detail::ShapeTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;

    static ShapeType get(::mlir::MLIRContext *context, unsigned rank);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("shape");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    unsigned getRank() const;
  };

  namespace detail {
    struct ShiftTypeStorage;
  } // end namespace detail
  class ShiftType : public ::mlir::Type::TypeBase<ShiftType, ::mlir::Type,
                                         detail::ShiftTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    using KindTy = unsigned;

    // a !fir.boxchar<k> always wraps a !fir.char<k, ?>
    CharacterType getElementType(mlir::MLIRContext *context) const;

    CharacterType getEleTy() const;
  
    static ShiftType get(::mlir::MLIRContext *context, unsigned rank);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("shift");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    unsigned getRank() const;
  };

  namespace detail {
    struct SliceTypeStorage;
  } // end namespace detail
  class SliceType : public ::mlir::Type::TypeBase<SliceType, ::mlir::Type,
                                         detail::SliceTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;

    static SliceType get(::mlir::MLIRContext *context, unsigned rank);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("slice");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    unsigned getRank() const;
  };

  namespace detail {
    struct TypeDescTypeStorage;
  } // end namespace detail
  class TypeDescType : public ::mlir::Type::TypeBase<TypeDescType, ::mlir::Type,
                                         detail::TypeDescTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;

    static TypeDescType get(mlir::Type elementType);
    static TypeDescType getChecked(llvm::function_ref<mlir::InFlightDiagnostic()> emitError, mlir::Type elementType);

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type ofTy);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("tdesc");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    mlir::Type getOfTy() const;
  };

  namespace detail {
    struct VectorTypeStorage;
  } // end namespace detail
  class VectorType : public ::mlir::Type::TypeBase<VectorType, ::mlir::Type,
                                         detail::VectorTypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;


    static bool isValidElementType(mlir::Type t);
  
    static VectorType get(uint64_t len, mlir::Type eleTy);
    static VectorType getChecked(llvm::function_ref<mlir::InFlightDiagnostic()> emitError, uint64_t len, mlir::Type eleTy);

    using Base::getChecked;
    static ::mlir::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, uint64_t len, mlir::Type eleTy);
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("vector");
    }

    static ::mlir::Type parse(::mlir::MLIRContext *context,
                             ::mlir::DialectAsmParser &parser);
    void print(::mlir::DialectAsmPrinter &printer) const;
    uint64_t getLen() const;
    mlir::Type getEleTy() const;
  };

  class VoidType : public ::mlir::Type::TypeBase<VoidType, ::mlir::Type, ::mlir::TypeStorage> {
  public:
    /// Inherit some necessary constructors from 'TypeBase'.
    using Base::Base;
    static constexpr ::llvm::StringLiteral getMnemonic() {
      return ::llvm::StringLiteral("void");
    }
  };
} // namespace fir

#endif  // GET_TYPEDEF_CLASSES

