/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.xmleditor;

import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.apache.batik.util.gui.xmleditor.XMLContext;
import org.apache.batik.util.gui.xmleditor.XMLDocument;
import org.apache.batik.util.gui.xmleditor.XMLView;

public class XMLEditorKit
extends DefaultEditorKit {
    public static final String XML_MIME_TYPE = "text/xml";
    protected XMLContext context;
    protected ViewFactory factory = new XMLViewFactory();

    public XMLEditorKit() {
        this(null);
    }

    public XMLEditorKit(XMLContext xMLContext) {
        this.context = xMLContext == null ? new XMLContext() : xMLContext;
    }

    public XMLContext getStylePreferences() {
        return this.context;
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        Font font = this.context.getSyntaxFont("default");
        if (font != null) {
            jEditorPane.setFont(font);
        }
    }

    public String getContentType() {
        return XML_MIME_TYPE;
    }

    public Object clone() {
        XMLEditorKit xMLEditorKit = new XMLEditorKit();
        xMLEditorKit.context = this.context;
        return xMLEditorKit;
    }

    public Document createDefaultDocument() {
        XMLDocument xMLDocument = new XMLDocument(this.context);
        return xMLDocument;
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }

    protected class XMLViewFactory
    implements ViewFactory {
        protected XMLViewFactory() {
        }

        public View create(Element element) {
            return new XMLView(XMLEditorKit.this.context, element);
        }
    }
}

