#line 1 "stdin"
!--------------------------------------------------------------------
! Copyright © 2017 United States Government as represented by the   |
! Administrator of the National Aeronautics and Space               |
! Administration. No copyright is claimed in the United States      |
! under Title 17, U.S. Code. All Other Rights Reserved.             |
!                                                                   |
! Licensed under the Apache License, Version 2.0.                   |
!--------------------------------------------------------------------









! Althoug the code below could be compressed to some degree,
! maintainability is enhanced by isolating each complication in
! its own decision block.
!
! User settable tokens:
!    (a)  __use_key
!    (b)  __use_key_rank  and __use_key_extents
!    (c)  __use_key_string and __use_key_string_deferred
!    (d)  __use_key_logical
!    (e)  __use_key_pointer
!    (f)  __use_key_allocatable
!    (g)  __use_key_procedure (not complete)
!
!    __USE_KEY_EQ
!
! Output macros
!
!    (a)  __KEY_ASSIGN(dest,src)  ! Set dest to have value src
!    (b)  __KEY_MOVE(dest,src)    ! If allocatable, move memory for src to variable dest
!                               ! otherwise, behave as __KEY_ASSIGN(dest,src)
!    (c)  __KEY_FREE(x)      ! Release memory associated with x (if allocatable)
!
! Output tokens
!
!    (a) __key_declare_component
!    (b) __key_declare_target
!    (c) __key_declare_dummy
!    (d) __key_declare_result
!    (e) __key_interface ! unused - keeping for later use with procedure pointers
!
! Other tokens are for internal use in this file and should be undefined at the end.

!-------------------------------------------------------------------------------
! 1) Declared type

#if defined(__use_key_string) | defined(__use_key_string_deferred)
#  define __key_target_type character(len=*)
#  if defined(__use_key_string)
#    define __key_declare_type character(len=__use_key_string)
#  else
#    define __key_declare_type character(len=:)
#  endif
#else
#  define __key_declare_type __use_key
#  if defined(__use_key_procedure)
#    define __key_interface
#    define __key_target_type __key_declare_type
#  else
#    define __key_target_type __key_declare_type
#  endif
#endif


!-------------------------------------------------------------------------------
! 2) Dimensions
!    (a) There are two cases to consider: deferred shape and non-deferred shape.
!    (b) Return pointers are always deferred shape.
#if defined (__use_key_rank)
#  define __key_rank __use_key_rank
#else
#  define __key_rank 0
#endif

#if __key_rank == 0
#  define __key_deferred_dim_attr
#elif (__key_rank == 1)
#  define __key_deferred_dim_attr , dimension(:)
#elif (__key_rank == 2)
#  define __key_deferred_dim_attr , dimension(:,:)
#elif (__key_rank == 3)
#  define __key_deferred_dim_attr , dimension(:,:,:)
#elif (__key_rank == 4)
#  define __key_deferred_dim_attr , dimension(:,:,:,:)
#elif (__key_rank == 5)
#  define __key_deferred_dim_attr , dimension(:,:,:,:,:)
#endif

#ifdef __use_key_extents
#  define __key_dimension_attr , dimension __use_key_extents
#else
#  define __key_dimension_attr __key_deferred_dim_attr
#endif

#define __key_result_dimension_attr __key_deferred_dim_attr


!-------------------------------------------------------------------------------
! 3) Does the type need to be wrapped
#if defined(__use_key_pointer)
#  define __key_wrapped
#elif defined(__use_key_allocatable)
#  define __key_wrapped
#elif defined(__use_key_string_deferred)
#  define __key_wrapped
#elif __key_rank > 0
#  define __key_wrapped
#endif




!-------------------------------------------------------------------------------
! 4) Attributes for component declaration

#if defined(__use_key_pointer)
#  if defined(__use_key_procedure)
#    define __key_component_attrs , pointer, nopass
#  else
#    define __key_component_attrs __key_dimension_attr, pointer
#  endif
#elif defined(__use_key_allocatable) | defined(__use_key_string_deferred)
#  define __key_component_attrs __key_dimension_attr, allocatable
#elif (__key_rank > 0)
#  if defined(__use_key_extents)
#     define __key_component_attrs __key_dimension_attr
#  else
#     define __key_component_attrs __key_dimension_attr, allocatable
#  endif
#else
#  define __key_component_attrs
#endif

! macros for testing equality

#ifdef __USE_KEY_EQ
#  define __KEY_EQ __USE_KEY_EQ
#else
#  ifdef __use_key_pointer
#    define __KEY_EQ(x,y) associated(x,y)
#  else
#    ifdef __USE_KEY_EQ_ELEMENT
#      define __KEY_EQ_ELEMENT(x,y) __USE_KEY_EQ_ELEMENT(x,y)    
#    else
#      ifdef __use_key_logical 
#         define __KEY_EQ_ELEMENT(x,y) (x .eqv. y)
#      else
#        define __KEY_EQ_ELEMENT(x,y) (x == y)
#      endif
#    endif
!    Array support
#    if (__use_key_rank > 0)
#       ifdef __use_key_extents
!         Assumes that __USE_KEY_EQ_ELEMENT is an elemental function.  If not
!         then the user must define their own __KEY_EQ(x,y).
#         define __KEY_EQ(x,y) all(__KEY_EQ_ELEMENT(x,y))
#       else
#         define __KEY_EQ(x,y) __PROC(eqArray)(x,y)
#       endif
#    else
#      define __KEY_EQ(x,y) __KEY_EQ_ELEMENT(x,y)
#    endif
#  endif
#endif


! macros for comparing order
! User can specify (or override):
#define __key_compare_well_defined
#ifdef __USE_KEY_LESS_THAN
#  define __KEY_LESS_THAN(x,y) __USE_KEY_LESS_THAN(x,y)
#else
#  if defined(__use_key_string) | defined(__use_key_string_deferred)
#    define __KEY_LESS_THAN(x,y) (x)<(y)
#  elif defined(__use_key_less_than_defined)
#    define __KEY_LESS_THAN(x,y) (x)<(y)
#  else
#    undef __key_compare_well_defined
! In most cases, we can provide a compare operator.  Not recommended for vector,
! but useful for set and keys for map:
#    if  !(defined(__use_key_allocatable) & !defined(__use_key_pointer))
#      define __KEY_LESS_THAN(x,y) defaultLessThan(x,y)
#      define __key_needs_default_compare
#    endif
#  endif
#endif





!-------------------------------------------------------------------------------
! 5) Attributes for target and dummy declaration

#if defined(__use_key_pointer)
#  if defined(__use_key_procedure)
#    define __key_target_attrs
#    define __key_dummy_attrs __key_target_attrs
#  else
#    define __key_target_attrs __key_dimension_attr, target
#    define __key_dummy_attrs __key_dimension_attr, target
#  endif
#else
#  define __key_target_attrs  __key_dimension_attr
#  define __key_dummy_attrs __key_dimension_attr
#endif


!-------------------------------------------------------------------------------
! 6) Attributes for function result declaration
!    Always used deferred shape here as pointer cannot work 
!    with non-deferred shape.

#define __key_result_attrs __key_deferred_dim_attr



!-------------------------------------------------------------------------------
! 8) Assembly

#define __key_declare_component __key_declare_type __key_component_attrs
#define __key_declare_target    __key_target_type __key_target_attrs
#define __key_declare_dummy     __key_target_type __key_dummy_attrs
#define __key_declare_result    __key_declare_type __key_result_attrs


!-------------------------------------------------------------------------------
! 9) Macros that manipulate storage

#ifdef __USE_KEY_ASSIGN
#  define __KEY_ASSIGN(dest,src) __USE_KEY_ASSIGN(dest,src)   
#  define __KEY_MOVE(dest,src) __USE_KEY_MOVE(dest,src)   
#  define __KEY_FREE(x) __USE_KEY_FREE(x)
#else
#  ifdef __use_key_pointer

#    define __KEY_ASSIGN(dest,src)  dest=>src
#    define __KEY_MOVE(dest,src)  dest=>src
!#    define __KEY_FREE(x)  nullify(x)
#    define __KEY_FREE(x)

#  elif defined(__use_key_allocatable)

#    define __KEY_ASSIGN(dest,src)  allocate(dest, source=src)
#    define __KEY_MOVE(dest,src)  call move_alloc(from=src, to=dest)
#    define __KEY_FREE(x)  deallocate(x)

#  elif defined (__use_key_rank) & (__use_key_rank > 0) & !defined(__use_key_extents)
#    define __KEY_ASSIGN(dest,src) __ASSIGN_DIM(dest,src)
#    define __KEY_MOVE(dest,src) call move_alloc(from=src, to=dest)
#    define __KEY_FREE(x)  deallocate(x)

#elif defined (__use_key_string_deferred)

#    define __KEY_ASSIGN(dest,src)  dest=src
#    ifdef __GFORTRAN__
#      define __KEY_MOVE(dest,src) dest=src;deallocate(src)
#    else
#    define __KEY_MOVE(dest,src) call move_alloc(from=src, to=dest)
#    endif
#    define __KEY_FREE(x)  deallocate(x)

#else

#    define __KEY_ASSIGN(dest,src)  dest=src
#    define __KEY_MOVE(dest,src) dest=src
#    define __KEY_FREE(x)

#  endif
#endif



