#line 1 "stdin"
!--------------------------------------------------------------------
! Copyright © 2017 United States Government as represented by the   |
! Administrator of the National Aeronautics and Space               |
! Administration. No copyright is claimed in the United States      |
! under Title 17, U.S. Code. All Other Rights Reserved.             |
!                                                                   |
! Licensed under the Apache License, Version 2.0.                   |
!--------------------------------------------------------------------









! These macros are used in tests, but are not needed for the container
! templates.
#ifdef _key_pointer

#  if defined(_key_allocatable)

#    define __key_allocatable_target
#    define __KEY_INIT_TARGET(trg, val) allocate(trg, source=val)

#  elif defined (_key_rank) & (_key_rank > 0) & !defined(_key_extents)
   ! The Intel compiler requires a flag to use F2003 allocate-on-assignment
   ! semantics.  To avoid assuming that users have that flag set,
   ! we use the more verbose option here.  Unfortunately, gfortran does not
   ! support this variant for arrays, so we do use the allocate-on-assignment
   ! for that compiler.
#    define __key_allocatable_target
#    ifdef __INTEL_COMPILER
#      define __KEY_INIT_TARGET(trg, val) allocate(trg, source=val)
#    else
#      define __KEY_INIT_TARGET(trg, val)  trg = val
#    endif

#  elif defined(_key_len) & (_key_len < 0)

#    define __key_allocatable_target
#    define __KEY_INIT_TARGET(trg, val) allocate(trg, source=val)

#  else

#    define __KEY_INIT_TARGET(trg, val) trg = val

#  endif

#endif
      

#ifdef _key_pointer
#  ifdef _key_procedure
#    define __KEY_INIT(var, val, trg) var => val
#    define __key_declare_local __key_declare_type, pointer
#  else
#    define __KEY_INIT(var, val, trg) __KEY_INIT_TARGET(trg, val); var => trg
#  endif
#else
#  define __KEY_INIT(var, val, trg) __KEY_ASSIGN(var,val)
#endif

#ifndef __key_declare_local
#  define __key_declare_local __key_declare_component
#endif

