#line 1 "stdin"
!--------------------------------------------------------------------
! Copyright © 2017 United States Government as represented by the   |
! Administrator of the National Aeronautics and Space               |
! Administration. No copyright is claimed in the United States      |
! under Title 17, U.S. Code. All Other Rights Reserved.             |
!                                                                   |
! Licensed under the Apache License, Version 2.0.                   |
!--------------------------------------------------------------------









! Althoug the code below could be compressed to some degree,
! maintainability is enhanced by isolating each complication in
! its own decision block.
!
! User settable tokens:
!    (a)  __use_value
!    (b)  __use_value_rank  and __use_value_extents
!    (c)  __use_value_string and __use_value_string_deferred
!    (d)  __use_value_logical
!    (e)  __use_value_pointer
!    (f)  __use_value_allocatable
!    (g)  __use_value_procedure (not complete)
!
!    __USE_VALUE_EQ
!
! Output macros
!
!    (a)  __VALUE_ASSIGN(dest,src)  ! Set dest to have value src
!    (b)  __VALUE_MOVE(dest,src)    ! If allocatable, move memory for src to variable dest
!                               ! otherwise, behave as __VALUE_ASSIGN(dest,src)
!    (c)  __VALUE_FREE(x)      ! Release memory associated with x (if allocatable)
!
! Output tokens
!
!    (a) __value_declare_component
!    (b) __value_declare_target
!    (c) __value_declare_dummy
!    (d) __value_declare_result
!    (e) __value_interface ! unused - keeping for later use with procedure pointers
!
! Other tokens are for internal use in this file and should be undefined at the end.

!-------------------------------------------------------------------------------
! 1) Declared type

#if defined(__use_value_string) | defined(__use_value_string_deferred)
#  define __value_target_type character(len=*)
#  if defined(__use_value_string)
#    define __value_declare_type character(len=__use_value_string)
#  else
#    define __value_declare_type character(len=:)
#  endif
#else
#  define __value_declare_type __use_value
#  if defined(__use_value_procedure)
#    define __value_interface
#    define __value_target_type __value_declare_type
#  else
#    define __value_target_type __value_declare_type
#  endif
#endif


!-------------------------------------------------------------------------------
! 2) Dimensions
!    (a) There are two cases to consider: deferred shape and non-deferred shape.
!    (b) Return pointers are always deferred shape.
#if defined (__use_value_rank)
#  define __value_rank __use_value_rank
#else
#  define __value_rank 0
#endif

#if __value_rank == 0
#  define __value_deferred_dim_attr
#elif (__value_rank == 1)
#  define __value_deferred_dim_attr , dimension(:)
#elif (__value_rank == 2)
#  define __value_deferred_dim_attr , dimension(:,:)
#elif (__value_rank == 3)
#  define __value_deferred_dim_attr , dimension(:,:,:)
#elif (__value_rank == 4)
#  define __value_deferred_dim_attr , dimension(:,:,:,:)
#elif (__value_rank == 5)
#  define __value_deferred_dim_attr , dimension(:,:,:,:,:)
#endif

#ifdef __use_value_extents
#  define __value_dimension_attr , dimension __use_value_extents
#else
#  define __value_dimension_attr __value_deferred_dim_attr
#endif

#define __value_result_dimension_attr __value_deferred_dim_attr


!-------------------------------------------------------------------------------
! 3) Does the type need to be wrapped
#if defined(__use_value_pointer)
#  define __value_wrapped
#elif defined(__use_value_allocatable)
#  define __value_wrapped
#elif defined(__use_value_string_deferred)
#  define __value_wrapped
#elif __value_rank > 0
#  define __value_wrapped
#endif




!-------------------------------------------------------------------------------
! 4) Attributes for component declaration

#if defined(__use_value_pointer)
#  if defined(__use_value_procedure)
#    define __value_component_attrs , pointer, nopass
#  else
#    define __value_component_attrs __value_dimension_attr, pointer
#  endif
#elif defined(__use_value_allocatable) | defined(__use_value_string_deferred)
#  define __value_component_attrs __value_dimension_attr, allocatable
#elif (__value_rank > 0)
#  if defined(__use_value_extents)
#     define __value_component_attrs __value_dimension_attr
#  else
#     define __value_component_attrs __value_dimension_attr, allocatable
#  endif
#else
#  define __value_component_attrs
#endif

! macros for testing equality

#ifdef __USE_VALUE_EQ
#  define __VALUE_EQ __USE_VALUE_EQ
#else
#  ifdef __use_value_pointer
#    define __VALUE_EQ(x,y) associated(x,y)
#  else
#    ifdef __USE_VALUE_EQ_ELEMENT
#      define __VALUE_EQ_ELEMENT(x,y) __USE_VALUE_EQ_ELEMENT(x,y)    
#    else
#      ifdef __use_value_logical 
#         define __VALUE_EQ_ELEMENT(x,y) (x .eqv. y)
#      else
#        define __VALUE_EQ_ELEMENT(x,y) (x == y)
#      endif
#    endif
!    Array support
#    if (__use_value_rank > 0)
#       ifdef __use_value_extents
!         Assumes that __USE_VALUE_EQ_ELEMENT is an elemental function.  If not
!         then the user must define their own __VALUE_EQ(x,y).
#         define __VALUE_EQ(x,y) all(__VALUE_EQ_ELEMENT(x,y))
#       else
#         define __VALUE_EQ(x,y) __PROC(eqArray)(x,y)
#       endif
#    else
#      define __VALUE_EQ(x,y) __VALUE_EQ_ELEMENT(x,y)
#    endif
#  endif
#endif


! macros for comparing order
! User can specify (or override):
#define __value_compare_well_defined
#ifdef __USE_VALUE_LESS_THAN
#  define __VALUE_LESS_THAN(x,y) __USE_VALUE_LESS_THAN(x,y)
#else
#  if defined(__use_value_string) | defined(__use_value_string_deferred)
#    define __VALUE_LESS_THAN(x,y) (x)<(y)
#  elif defined(__use_value_less_than_defined)
#    define __VALUE_LESS_THAN(x,y) (x)<(y)
#  else
#    undef __value_compare_well_defined
! In most cases, we can provide a compare operator.  Not recommended for vector,
! but useful for set and keys for map:
#    if  !(defined(__use_value_allocatable) & !defined(__use_value_pointer))
#      define __VALUE_LESS_THAN(x,y) defaultLessThan(x,y)
#      define __value_needs_default_compare
#    endif
#  endif
#endif





!-------------------------------------------------------------------------------
! 5) Attributes for target and dummy declaration

#if defined(__use_value_pointer)
#  if defined(__use_value_procedure)
#    define __value_target_attrs
#    define __value_dummy_attrs __value_target_attrs
#  else
#    define __value_target_attrs __value_dimension_attr, target
#    define __value_dummy_attrs __value_dimension_attr, target
#  endif
#else
#  define __value_target_attrs  __value_dimension_attr
#  define __value_dummy_attrs __value_dimension_attr
#endif


!-------------------------------------------------------------------------------
! 6) Attributes for function result declaration
!    Always used deferred shape here as pointer cannot work 
!    with non-deferred shape.

#define __value_result_attrs __value_deferred_dim_attr



!-------------------------------------------------------------------------------
! 8) Assembly

#define __value_declare_component __value_declare_type __value_component_attrs
#define __value_declare_target    __value_target_type __value_target_attrs
#define __value_declare_dummy     __value_target_type __value_dummy_attrs
#define __value_declare_result    __value_declare_type __value_result_attrs


!-------------------------------------------------------------------------------
! 9) Macros that manipulate storage

#ifdef __USE_VALUE_ASSIGN
#  define __VALUE_ASSIGN(dest,src) __USE_VALUE_ASSIGN(dest,src)   
#  define __VALUE_MOVE(dest,src) __USE_VALUE_MOVE(dest,src)   
#  define __VALUE_FREE(x) __USE_VALUE_FREE(x)
#else
#  ifdef __use_value_pointer

#    define __VALUE_ASSIGN(dest,src)  dest=>src
#    define __VALUE_MOVE(dest,src)  dest=>src
!#    define __VALUE_FREE(x)  nullify(x)
#    define __VALUE_FREE(x)

#  elif defined(__use_value_allocatable)

#    define __VALUE_ASSIGN(dest,src)  allocate(dest, source=src)
#    define __VALUE_MOVE(dest,src)  call move_alloc(from=src, to=dest)
#    define __VALUE_FREE(x)  deallocate(x)

#  elif defined (__use_value_rank) & (__use_value_rank > 0) & !defined(__use_value_extents)
#    define __VALUE_ASSIGN(dest,src) __ASSIGN_DIM(dest,src)
#    define __VALUE_MOVE(dest,src) call move_alloc(from=src, to=dest)
#    define __VALUE_FREE(x)  deallocate(x)

#elif defined (__use_value_string_deferred)

#    define __VALUE_ASSIGN(dest,src)  dest=src
#    ifdef __GFORTRAN__
#      define __VALUE_MOVE(dest,src) dest=src;deallocate(src)
#    else
#    define __VALUE_MOVE(dest,src) call move_alloc(from=src, to=dest)
#    endif
#    define __VALUE_FREE(x)  deallocate(x)

#else

#    define __VALUE_ASSIGN(dest,src)  dest=src
#    define __VALUE_MOVE(dest,src) dest=src
#    define __VALUE_FREE(x)

#  endif
#endif



