#line 1 "stdin"
!--------------------------------------------------------------------
! Copyright © 2017 United States Government as represented by the   |
! Administrator of the National Aeronautics and Space               |
! Administration. No copyright is claimed in the United States      |
! under Title 17, U.S. Code. All Other Rights Reserved.             |
!                                                                   |
! Licensed under the Apache License, Version 2.0.                   |
!--------------------------------------------------------------------









! These macros are used in tests, but are not needed for the container
! templates.
#ifdef _value_pointer

#  if defined(_value_allocatable)

#    define __value_allocatable_target
#    define __VALUE_INIT_TARGET(trg, val) allocate(trg, source=val)

#  elif defined (_value_rank) & (_value_rank > 0) & !defined(_value_extents)
   ! The Intel compiler requires a flag to use F2003 allocate-on-assignment
   ! semantics.  To avoid assuming that users have that flag set,
   ! we use the more verbose option here.  Unfortunately, gfortran does not
   ! support this variant for arrays, so we do use the allocate-on-assignment
   ! for that compiler.
#    define __value_allocatable_target
#    ifdef __INTEL_COMPILER
#      define __VALUE_INIT_TARGET(trg, val) allocate(trg, source=val)
#    else
#      define __VALUE_INIT_TARGET(trg, val)  trg = val
#    endif

#  elif defined(_value_len) & (_value_len < 0)

#    define __value_allocatable_target
#    define __VALUE_INIT_TARGET(trg, val) allocate(trg, source=val)

#  else

#    define __VALUE_INIT_TARGET(trg, val) trg = val

#  endif

#endif
      

#ifdef _value_pointer
#  ifdef _value_procedure
#    define __VALUE_INIT(var, val, trg) var => val
#    define __value_declare_local __value_declare_type, pointer
#  else
#    define __VALUE_INIT(var, val, trg) __VALUE_INIT_TARGET(trg, val); var => trg
#  endif
#else
#  define __VALUE_INIT(var, val, trg) __VALUE_ASSIGN(var,val)
#endif

#ifndef __value_declare_local
#  define __value_declare_local __value_declare_component
#endif

