;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; history.scm

(define-module readline.history
  (export-all))
(select-module readline.history)

;;; Incidentally, this single portion of readline gave me the most
;;; trouble (for a while I had a classic message-passing object system
;;; using continuations).

;;; I think that my problem was False Optimization.  The following
;;; is certainly bad, but it has two major advantages over previous
;;; versions:
;;;
;;;   1. It works.
;;;   2. It works transparently.
;;;
;;; Now that I've got a working/transparent copy, the optimization
;;; would be an easy task -- if I ever happen to think that this code
;;; is worth the effort.

(define (history-store state)
  (let ((hist (hash-table-get state 'last-history))
        (s (hash-table-get state 'string)))
    (unless (and (not (null? hist))
                 (string=? s (car hist)))
      (push! hist s)
      (hash-table-put! state 'last-history hist))
    (hash-table-put! state 'history hist)))

(define (history-previous state)
  (let1 hist (hash-table-get state 'history)
    (if (null? hist)
        #t
        (let1 tm (pop! hist)
          (hash-table-put! state 'history
            (append hist (list (hash-table-get state 'string))))
          (hash-table-put! state 'string tm)
          #f))))

(define (history-next state)
  (let1 hist (reverse (hash-table-get state 'history))
    (if (null? hist)
        #t
        (let1 tm (pop! hist)
          (hash-table-put! state 'history
            (reverse (append hist (list (hash-table-get state 'string)))))
          (hash-table-put! state 'string tm)
          #f))))

(provide "readline/history")
