#ifndef GAVL_CLOCK_NANOSLEEP_H_INCLUDED
#define GAVL_CLOCK_NANOSLEEP_H_INCLUDED

#include <time.h>
#include <unistd.h>

#ifdef __APPLE__
// macOS <10.12 doesn't have clockid_t / CLOCK_MONOTONIC
#ifndef CLOCK_MONOTONIC
typedef int clockid_t;
#define CLOCK_MONOTONIC 0
#endif
// macOS doesn't have clock_nanosleep
static inline
int clock_nanosleep(clockid_t clock_id, int flags,
    const struct timespec *tm, struct timespec *rem)
{
    (void) clock_id;
    (void) flags;
    (void) tm;
    (void) rem;
    errno = ENOSYS;
    return -1;
}
#endif // __APPLE__

#endif // GAVL_CLOCK_NANOSLEEP_H_INCLUDED
