/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorLookUpTable;
import gnu.java.awt.color.ColorSpaceConverter;
import gnu.java.awt.color.GrayScaleConverter;
import gnu.java.awt.color.ToneReproductionCurve;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ProfileDataException;

public class GrayProfileConverter
implements ColorSpaceConverter {
    private GrayScaleConverter gc;
    private ToneReproductionCurve trc;
    private ColorLookUpTable toPCS;
    private ColorLookUpTable fromPCS;

    public GrayProfileConverter(ICC_ProfileGray profile) {
        try {
            this.trc = new ToneReproductionCurve(profile.getGamma());
        }
        catch (ProfileDataException profileDataException) {
            this.trc = new ToneReproductionCurve(profile.getTRC());
        }
        this.gc = new GrayScaleConverter();
        try {
            this.toPCS = new ColorLookUpTable(profile, 1093812784);
        }
        catch (Exception exception) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = new ColorLookUpTable(profile, 1110589744);
        }
        catch (Exception exception) {
            this.fromPCS = null;
        }
    }

    public float[] toCIEXYZ(float[] in) {
        if (this.toPCS != null) {
            return this.toPCS.lookup(in);
        }
        float[] gray = new float[]{this.trc.lookup(in[0])};
        return this.gc.toCIEXYZ(gray);
    }

    public float[] toRGB(float[] in) {
        float[] gray = new float[]{this.trc.lookup(in[0])};
        return this.gc.toRGB(gray);
    }

    public float[] fromRGB(float[] in) {
        float[] gray = this.gc.fromRGB(in);
        gray[0] = this.trc.reverseLookup(gray[0]);
        return gray;
    }

    public float[] fromCIEXYZ(float[] in) {
        if (this.fromPCS != null) {
            return this.fromPCS.lookup(in);
        }
        float[] gray = this.gc.fromCIEXYZ(in);
        gray[0] = this.trc.reverseLookup(gray[0]);
        return gray;
    }
}

