/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.lang.reflect.Array;
import java.util.HashMap;

public class ArrayPersistenceDelegate
extends PersistenceDelegate {
    private static final HashMap NULL_VALUES = new HashMap();

    static {
        NULL_VALUES.put(Boolean.TYPE, Boolean.FALSE);
        NULL_VALUES.put(Byte.TYPE, (byte)0);
        NULL_VALUES.put(Short.TYPE, (short)0);
        NULL_VALUES.put(Integer.TYPE, 0);
        NULL_VALUES.put(Long.TYPE, 0L);
        NULL_VALUES.put(Float.TYPE, Float.valueOf(0.0f));
        NULL_VALUES.put(Double.TYPE, 0.0);
    }

    protected Expression instantiate(Object oldInstance, Encoder out) {
        Class<?> type = oldInstance.getClass().getComponentType();
        assert (type != null);
        return new Expression(oldInstance, Array.class, "newInstance", new Object[]{type, new Integer(Array.getLength(oldInstance))});
    }

    protected void initialize(Class type, Object oldInstance, Object newInstance, Encoder out) {
        int length = Array.getLength(oldInstance);
        if ((type = type.getComponentType()).isPrimitive()) {
            Object nullValue = NULL_VALUES.get(type);
            int i = 0;
            while (i < length) {
                Object oldValue = Array.get(oldInstance, i);
                if (!oldValue.equals(nullValue)) {
                    out.writeExpression(new Expression(Array.class, "get", new Object[]{oldInstance, i}));
                    out.writeStatement(new Statement(Array.class, "set", new Object[]{oldInstance, i, oldValue}));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                Object oldValue = Array.get(oldInstance, i);
                if (oldValue != null) {
                    out.writeExpression(new Expression(Array.class, "get", new Object[]{oldInstance, i}));
                    out.writeStatement(new Statement(Array.class, "set", new Object[]{oldInstance, i, oldValue}));
                }
                ++i;
            }
        }
    }
}

