/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_16Encoder
extends CharsetEncoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private final ByteOrder byteOrder;
    private final boolean useByteOrderMark;
    private boolean needsByteOrderMark;

    UTF_16Encoder(Charset cs, int byteOrder, boolean useByteOrderMark) {
        byte[] byArray;
        float f = useByteOrderMark ? 4.0f : 2.0f;
        if (byteOrder == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(cs, 2.0f, f, byArray);
        this.byteOrder = byteOrder == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.useByteOrderMark = useByteOrderMark;
        this.needsByteOrderMark = useByteOrderMark;
    }

    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        ByteOrder originalBO = out.order();
        out.order(this.byteOrder);
        if (this.needsByteOrderMark) {
            if (out.remaining() < 2) {
                out.order(originalBO);
                return CoderResult.OVERFLOW;
            }
            out.putChar('\ufeff');
            this.needsByteOrderMark = false;
        }
        int inPos = in.position();
        try {
            while (in.hasRemaining()) {
                char c = in.get();
                if ('\ud800' <= c && c <= '\udfff') {
                    if (c > '\udbff') {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (in.remaining() < 1) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    char d = in.get();
                    if (d < '\udc00' || d > '\udfff') {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    out.putChar(c);
                    out.putChar(d);
                    inPos += 2;
                    continue;
                }
                if (out.remaining() < 2) {
                    out.order(originalBO);
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                out.putChar(c);
                ++inPos;
            }
            out.order(originalBO);
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            in.position(inPos);
        }
    }

    protected void implReset() {
        this.needsByteOrderMark = this.useByteOrderMark;
    }
}

