/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.keyring;

import gnu.java.security.Registry;
import gnu.javax.crypto.keyring.GnuPrivateKeyring;
import gnu.javax.crypto.keyring.GnuPublicKeyring;
import gnu.javax.crypto.keyring.IKeyring;
import gnu.javax.crypto.keyring.IPrivateKeyring;
import gnu.javax.crypto.keyring.IPublicKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PrimitiveEntry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.crypto.SecretKey;

public class GnuKeyring
extends KeyStoreSpi {
    private static final Logger log = Logger.getLogger(GnuKeyring.class.getName());
    private static final String NOT_LOADED = "not loaded";
    private boolean loaded;
    private IPrivateKeyring privateKR;
    private IPublicKeyring publicKR;

    public Enumeration engineAliases() {
        Enumeration result;
        this.ensureLoaded();
        if (this.privateKR == null) {
            result = Collections.enumeration(Collections.EMPTY_SET);
        } else {
            String alias;
            HashSet aliases = new HashSet();
            Enumeration e = this.privateKR.aliases();
            while (e.hasMoreElements()) {
                alias = (String)e.nextElement();
                if (alias == null || (alias = alias.trim()).length() <= 0) continue;
                aliases.add(alias);
            }
            e = this.publicKR.aliases();
            while (e.hasMoreElements()) {
                alias = (String)e.nextElement();
                if (alias == null || (alias = alias.trim()).length() <= 0) continue;
                aliases.add(alias);
            }
            result = Collections.enumeration(aliases);
        }
        return result;
    }

    public boolean engineContainsAlias(String alias) {
        this.ensureLoaded();
        boolean inPrivateKR = this.privateKR.containsAlias(alias);
        boolean inPublicKR = this.publicKR.containsAlias(alias);
        boolean result = inPrivateKR || inPublicKR;
        return result;
    }

    public void engineDeleteEntry(String alias) {
        this.ensureLoaded();
        if (this.privateKR.containsAlias(alias)) {
            this.privateKR.remove(alias);
        } else if (this.publicKR.containsAlias(alias)) {
            this.publicKR.remove(alias);
        }
    }

    public Certificate engineGetCertificate(String alias) {
        this.ensureLoaded();
        Certificate result = this.publicKR.getCertificate(alias);
        return result;
    }

    public String engineGetCertificateAlias(Certificate cert) {
        this.ensureLoaded();
        String result = null;
        Enumeration aliases = this.publicKR.aliases();
        while (aliases.hasMoreElements()) {
            String alias = (String)aliases.nextElement();
            Certificate cert2 = this.publicKR.getCertificate(alias);
            if (!cert.equals(cert2)) continue;
            result = alias;
            break;
        }
        return result;
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.ensureLoaded();
        if (this.privateKR.containsAlias(alias)) {
            throw new KeyStoreException("Alias [" + alias + "] already exists and DOES NOT identify a " + "Trusted Certificate Entry");
        }
        if (this.publicKR.containsCertificate(alias)) {
            this.publicKR.remove(alias);
        }
        this.publicKR.putCertificate(alias, cert);
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        this.ensureLoaded();
        Certificate[] result = this.privateKR.getCertPath(alias);
        return result;
    }

    public Date engineGetCreationDate(String alias) {
        this.ensureLoaded();
        Date result = this.getCreationDate(alias, this.privateKR);
        if (result == null) {
            result = this.getCreationDate(alias, this.publicKR);
        }
        return result;
    }

    public Key engineGetKey(String alias, char[] password) throws UnrecoverableKeyException {
        this.ensureLoaded();
        Key result = null;
        if (password == null) {
            if (this.privateKR.containsPublicKey(alias)) {
                result = this.privateKR.getPublicKey(alias);
            }
        } else if (this.privateKR.containsPrivateKey(alias)) {
            result = this.privateKR.getPrivateKey(alias, password);
        }
        return result;
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.ensureLoaded();
        if (this.publicKR.containsAlias(alias)) {
            throw new KeyStoreException("Alias [" + alias + "] already exists and DOES NOT identify a " + "Key Entry");
        }
        if (key instanceof PublicKey) {
            this.privateKR.remove(alias);
            PublicKey pk = (PublicKey)key;
            this.privateKR.putPublicKey(alias, pk);
        } else {
            if (!(key instanceof PrivateKey) && !(key instanceof SecretKey)) {
                throw new KeyStoreException("cannot store keys of type " + key.getClass().getName());
            }
            this.privateKR.remove(alias);
            this.privateKR.putCertPath(alias, chain);
            this.privateKR.putPrivateKey(alias, key, password);
        }
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        KeyStoreException x = new KeyStoreException("method not supported");
        throw x;
    }

    public boolean engineIsCertificateEntry(String alias) {
        this.ensureLoaded();
        boolean result = this.publicKR.containsCertificate(alias);
        return result;
    }

    public boolean engineIsKeyEntry(String alias) {
        this.ensureLoaded();
        boolean result = this.privateKR.containsPublicKey(alias) || this.privateKR.containsPrivateKey(alias);
        return result;
    }

    public void engineLoad(InputStream in, char[] password) throws IOException {
        if (in != null) {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            this.loadPrivateKeyring(in, password);
            this.loadPublicKeyring(in, password);
        } else {
            this.createNewKeyrings();
        }
        this.loaded = true;
    }

    public void engineStore(OutputStream out, char[] password) throws IOException {
        this.ensureLoaded();
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("gun.crypto.keyring.data.out", out);
        attr.put("gnu.crypto.keyring.password", password);
        this.privateKR.store(attr);
        this.publicKR.store(attr);
    }

    public int engineSize() {
        int result = 0;
        Enumeration e = this.engineAliases();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++result;
        }
        return result;
    }

    private void ensureLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException(NOT_LOADED);
        }
    }

    private void loadPrivateKeyring(InputStream in, char[] password) throws MalformedKeyringException, IOException {
        in.mark(5);
        int i = 0;
        while (i < 4) {
            if (in.read() != Registry.GKR_MAGIC[i]) {
                throw new MalformedKeyringException("incorrect magic");
            }
            ++i;
        }
        int usage = in.read();
        in.reset();
        if (usage != 3) {
            throw new MalformedKeyringException("Was expecting a private keyring but got a wrong USAGE: " + Integer.toBinaryString(usage));
        }
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("gnu.crypto.keyring.data.in", in);
        attr.put("gnu.crypto.keyring.password", password);
        this.privateKR = new GnuPrivateKeyring();
        this.privateKR.load(attr);
    }

    private void loadPublicKeyring(InputStream in, char[] password) throws MalformedKeyringException, IOException {
        in.mark(5);
        int i = 0;
        while (i < 4) {
            if (in.read() != Registry.GKR_MAGIC[i]) {
                throw new MalformedKeyringException("incorrect magic");
            }
            ++i;
        }
        int usage = in.read();
        in.reset();
        if (usage != 4) {
            throw new MalformedKeyringException("Was expecting a public keyring but got a wrong USAGE: " + Integer.toBinaryString(usage));
        }
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("gnu.crypto.keyring.data.in", in);
        attr.put("gnu.crypto.keyring.password", password);
        this.publicKR = new GnuPublicKeyring();
        this.publicKR.load(attr);
    }

    private Date getCreationDate(String alias, IKeyring keyring) {
        Date result = null;
        if (keyring != null) {
            for (Object o : keyring.get(alias)) {
                if (!(o instanceof PrimitiveEntry)) continue;
                result = ((PrimitiveEntry)o).getCreationDate();
                break;
            }
        }
        return result;
    }

    private void createNewKeyrings() {
        this.privateKR = new GnuPrivateKeyring("HMAC-SHA-1", 20, "AES", "OFB", 16);
        this.publicKR = new GnuPublicKeyring("HMAC-SHA-1", 20);
    }
}

