/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.Handshake;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Certificate
implements Handshake.Body {
    protected ByteBuffer buffer;
    protected final CertificateType type;

    public Certificate(ByteBuffer buffer, CertificateType type) {
        buffer.getClass();
        ((Object)((Object)type)).getClass();
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.type = type;
    }

    @Override
    public int length() {
        return ((this.buffer.get(0) & 0xFF) << 24 | this.buffer.getShort(1)) + 3;
    }

    public List<java.security.cert.Certificate> certificates() throws CertificateException, NoSuchAlgorithmException {
        LinkedList<java.security.cert.Certificate> list2 = new LinkedList<java.security.cert.Certificate>();
        CertificateFactory factory = CertificateFactory.getInstance(this.type.toString());
        int length = (this.buffer.get(0) & 0xFF) << 16 | this.buffer.getShort(1) & 0xFFFF;
        ByteBuffer b = (ByteBuffer)this.buffer.duplicate().position(3);
        int i = 3;
        while (i < length) {
            int length2 = (b.get() & 0xFF) << 16 | b.getShort() & 0xFFFF;
            byte[] buf = new byte[length2];
            b.position(i + 3);
            b.get(buf);
            list2.add(factory.generateCertificate(new ByteArrayInputStream(buf)));
            b.position(i += length2 + 3);
        }
        return list2;
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        try {
            List<java.security.cert.Certificate> certs = this.certificates();
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  certificateList: [");
            out.print(certs.size());
            out.println("] {");
            for (java.security.cert.Certificate cert : certs) {
                if (prefix != null) {
                    out.print(prefix);
                }
                out.print("    ");
                if (cert instanceof X509Certificate) {
                    out.print(((X509Certificate)cert).getSubjectDN());
                } else {
                    out.print(cert);
                }
                out.println(";");
            }
            if (prefix != null) {
                out.print(prefix);
            }
            out.println("  };");
        }
        catch (CertificateException ce) {
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  ");
            out.print(ce);
            out.println(";");
        }
        catch (NoSuchAlgorithmException nsae) {
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  ");
            out.print(nsae);
            out.println(";");
        }
        out.print("} Certificate;");
        return str.toString();
    }
}

