/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public final class AndExpr
extends Expr {
    final Expr lhs;
    final Expr rhs;

    public AndExpr(Expr lhs, Expr rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Object evaluate(Node context, int pos, int len) {
        Object left = this.lhs.evaluate(context, pos, len);
        if (!AndExpr._boolean(context, left)) {
            return Boolean.FALSE;
        }
        Object right = this.rhs.evaluate(context, pos, len);
        return AndExpr._boolean(context, right) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Expr clone(Object context) {
        return new AndExpr(this.lhs.clone(context), this.rhs.clone(context));
    }

    public boolean references(QName var) {
        return this.lhs.references(var) || this.rhs.references(var);
    }

    public String toString() {
        return this.lhs + " and " + this.rhs;
    }
}

