/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.lang.CPStringBuilder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class Raster {
    protected SampleModel sampleModel;
    protected DataBuffer dataBuffer;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected int numBands;
    protected int numDataElements;
    protected Raster parent;

    protected Raster(SampleModel sampleModel, Point origin) {
        this(sampleModel, sampleModel.createDataBuffer(), origin);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Point origin) {
        this(sampleModel, dataBuffer, new Rectangle(origin.x, origin.y, sampleModel.getWidth(), sampleModel.getHeight()), origin, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle aRegion, Point sampleModelTranslate, Raster parent) {
        this.sampleModel = sampleModel;
        this.dataBuffer = dataBuffer;
        this.minX = aRegion.x;
        this.minY = aRegion.y;
        this.width = aRegion.width;
        this.height = aRegion.height;
        if (sampleModelTranslate != null) {
            this.sampleModelTranslateX = sampleModelTranslate.x;
            this.sampleModelTranslateY = sampleModelTranslate.y;
        }
        this.numBands = sampleModel.getNumBands();
        this.numDataElements = sampleModel.getNumDataElements();
        this.parent = parent;
    }

    public static WritableRaster createInterleavedRaster(int dataType, int w, int h, int bands, Point location) {
        int[] bandOffsets = new int[bands];
        int b = 0;
        while (b < bands) {
            bandOffsets[b] = b;
            ++b;
        }
        int scanlineStride = bands * w;
        return Raster.createInterleavedRaster(dataType, w, h, scanlineStride, bands, bandOffsets, location);
    }

    public static WritableRaster createInterleavedRaster(int dataType, int w, int h, int scanlineStride, int pixelStride, int[] bandOffsets, Point location) {
        ComponentSampleModel sm = new ComponentSampleModel(dataType, w, h, pixelStride, scanlineStride, bandOffsets);
        return Raster.createWritableRaster(sm, location);
    }

    public static WritableRaster createBandedRaster(int dataType, int w, int h, int bands, Point location) {
        BandedSampleModel sm = new BandedSampleModel(dataType, w, h, bands);
        return Raster.createWritableRaster(sm, location);
    }

    public static WritableRaster createBandedRaster(int dataType, int w, int h, int scanlineStride, int[] bankIndices, int[] bandOffsets, Point location) {
        BandedSampleModel sm = new BandedSampleModel(dataType, w, h, scanlineStride, bankIndices, bandOffsets);
        return Raster.createWritableRaster(sm, location);
    }

    public static WritableRaster createPackedRaster(int dataType, int w, int h, int[] bandMasks, Point location) {
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(dataType, w, h, bandMasks);
        return Raster.createWritableRaster(sm, location);
    }

    public static WritableRaster createPackedRaster(int dataType, int w, int h, int bands, int bitsPerBand, Point location) {
        SampleModel sm;
        if (bands <= 0 || bands * bitsPerBand > Raster.getTypeBits(dataType)) {
            throw new IllegalArgumentException();
        }
        if (bands == 1) {
            sm = new MultiPixelPackedSampleModel(dataType, w, h, bitsPerBand);
        } else {
            int[] bandMasks = new int[bands];
            int mask = 1;
            int bits = bitsPerBand;
            while (--bits != 0) {
                mask = mask << 1 | 1;
            }
            int i = 0;
            while (i < bands) {
                bandMasks[i] = mask;
                mask <<= bitsPerBand;
                ++i;
            }
            sm = new SinglePixelPackedSampleModel(dataType, w, h, bandMasks);
        }
        return Raster.createWritableRaster(sm, location);
    }

    public static WritableRaster createInterleavedRaster(DataBuffer dataBuffer, int w, int h, int scanlineStride, int pixelStride, int[] bandOffsets, Point location) {
        ComponentSampleModel sm = new ComponentSampleModel(dataBuffer.getDataType(), w, h, pixelStride, scanlineStride, bandOffsets);
        return Raster.createWritableRaster(sm, dataBuffer, location);
    }

    public static WritableRaster createBandedRaster(DataBuffer dataBuffer, int w, int h, int scanlineStride, int[] bankIndices, int[] bandOffsets, Point location) {
        BandedSampleModel sm = new BandedSampleModel(dataBuffer.getDataType(), w, h, scanlineStride, bankIndices, bandOffsets);
        return Raster.createWritableRaster(sm, dataBuffer, location);
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int w, int h, int scanlineStride, int[] bandMasks, Point location) {
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(dataBuffer.getDataType(), w, h, scanlineStride, bandMasks);
        return Raster.createWritableRaster(sm, dataBuffer, location);
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int w, int h, int bitsPerPixel, Point location) {
        MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(dataBuffer.getDataType(), w, h, bitsPerPixel);
        return Raster.createWritableRaster(sm, dataBuffer, location);
    }

    public static Raster createRaster(SampleModel sm, DataBuffer db, Point location) {
        return new Raster(sm, db, location);
    }

    public static WritableRaster createWritableRaster(SampleModel sm, Point location) {
        return new WritableRaster(sm, location);
    }

    public static WritableRaster createWritableRaster(SampleModel sm, DataBuffer db, Point location) {
        return new WritableRaster(sm, db, location);
    }

    public Raster getParent() {
        return this.parent;
    }

    public final int getSampleModelTranslateX() {
        return this.sampleModelTranslateX;
    }

    public final int getSampleModelTranslateY() {
        return this.sampleModelTranslateY;
    }

    public WritableRaster createCompatibleWritableRaster() {
        return new WritableRaster(this.getSampleModel(), new Point(this.minX, this.minY));
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        return this.createCompatibleWritableRaster(this.minX, this.minY, w, h);
    }

    public WritableRaster createCompatibleWritableRaster(Rectangle rect) {
        return this.createCompatibleWritableRaster(rect.x, rect.y, rect.width, rect.height);
    }

    public WritableRaster createCompatibleWritableRaster(int x, int y, int w, int h) {
        SampleModel sm = this.getSampleModel().createCompatibleSampleModel(w, h);
        return new WritableRaster(sm, sm.createDataBuffer(), new Point(x, y));
    }

    public Raster createTranslatedChild(int childMinX, int childMinY) {
        int tcx = this.sampleModelTranslateX - this.minX + childMinX;
        int tcy = this.sampleModelTranslateY - this.minY + childMinY;
        return new Raster(this.sampleModel, this.dataBuffer, new Rectangle(childMinX, childMinY, this.width, this.height), new Point(tcx, tcy), this);
    }

    public Raster createChild(int parentX, int parentY, int width, int height, int childMinX, int childMinY, int[] bandList) {
        if (parentX < this.minX || parentX + width > this.minX + this.width || parentY < this.minY || parentY + height > this.minY + this.height) {
            throw new RasterFormatException("Child raster extends beyond parent");
        }
        SampleModel sm = bandList == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(bandList);
        return new Raster(sm, this.dataBuffer, new Rectangle(childMinX, childMinY, width, height), new Point(this.sampleModelTranslateX + childMinX - parentX, this.sampleModelTranslateY + childMinY - parentY), this);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.minX, this.minY, this.width, this.height);
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public final int getNumDataElements() {
        return this.numDataElements;
    }

    public final int getTransferType() {
        return this.sampleModel.getTransferType();
    }

    public DataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public Object getDataElements(int x, int y, Object outData) {
        return this.sampleModel.getDataElements(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, outData, this.dataBuffer);
    }

    public Object getDataElements(int x, int y, int w, int h, Object outData) {
        return this.sampleModel.getDataElements(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, outData, this.dataBuffer);
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        return this.sampleModel.getPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, iArray, this.dataBuffer);
    }

    public float[] getPixel(int x, int y, float[] fArray) {
        return this.sampleModel.getPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public double[] getPixel(int x, int y, double[] dArray) {
        return this.sampleModel.getPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray) {
        return this.sampleModel.getPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, iArray, this.dataBuffer);
    }

    public float[] getPixels(int x, int y, int w, int h, float[] fArray) {
        return this.sampleModel.getPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, fArray, this.dataBuffer);
    }

    public double[] getPixels(int x, int y, int w, int h, double[] dArray) {
        return this.sampleModel.getPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, dArray, this.dataBuffer);
    }

    public int getSample(int x, int y, int b) {
        return this.sampleModel.getSample(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, this.dataBuffer);
    }

    public float getSampleFloat(int x, int y, int b) {
        return this.sampleModel.getSampleFloat(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, this.dataBuffer);
    }

    public double getSampleDouble(int x, int y, int b) {
        return this.sampleModel.getSampleDouble(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, this.dataBuffer);
    }

    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray) {
        return this.sampleModel.getSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, iArray, this.dataBuffer);
    }

    public float[] getSamples(int x, int y, int w, int h, int b, float[] fArray) {
        return this.sampleModel.getSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, fArray, this.dataBuffer);
    }

    public double[] getSamples(int x, int y, int w, int h, int b, double[] dArray) {
        return this.sampleModel.getSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, dArray, this.dataBuffer);
    }

    public String toString() {
        CPStringBuilder result = new CPStringBuilder();
        result.append(this.getClass().getName());
        result.append("[(");
        result.append(this.minX).append(",").append(this.minY).append("), ");
        result.append(this.width).append(" x ").append(this.height).append(",");
        result.append(this.sampleModel).append(",");
        result.append(this.dataBuffer);
        result.append("]");
        return result.toString();
    }

    private static int getTypeBits(int dataType) {
        switch (dataType) {
            case 0: {
                return 8;
            }
            case 1: 
            case 2: {
                return 16;
            }
            case 3: 
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        return 0;
    }
}

