/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.lang.CPStringBuilder;
import gnu.java.net.loader.FileURLLoader;
import gnu.java.net.loader.JarURLLoader;
import gnu.java.net.loader.RemoteURLLoader;
import gnu.java.net.loader.Resource;
import gnu.java.net.loader.URLLoader;
import gnu.java.net.loader.URLStreamHandlerCache;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLClassLoader
extends SecureClassLoader {
    private static URLStreamHandlerCache factoryCache = new URLStreamHandlerCache();
    private static final String URL_LOADER_PREFIX = "gnu.java.net.loader.Load_";
    private final Vector<URL> urls = new Vector();
    private final Vector<URLLoader> urlinfos = new Vector();
    private final URLStreamHandlerFactory factory;
    private final AccessControlContext securityContext;
    private String thisString;

    public URLClassLoader(URL[] urls) throws SecurityException {
        this.factory = null;
        this.securityContext = null;
        this.addURLs(urls);
    }

    public URLClassLoader(URL[] urls, ClassLoader parent) throws SecurityException {
        super(parent);
        this.factory = null;
        this.securityContext = null;
        this.addURLs(urls);
    }

    URLClassLoader(ClassLoader parent, AccessControlContext securityContext) {
        super(parent);
        this.factory = null;
        this.securityContext = securityContext;
    }

    public URLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) throws SecurityException {
        super(parent);
        this.securityContext = null;
        this.factory = factory;
        factoryCache.add(factory);
        this.addURLs(urls);
    }

    protected void addURL(URL newUrl) {
        this.urls.add(newUrl);
        this.addURLImpl(newUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addURLImpl(URL newUrl) {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            URL absoluteURL;
            if (newUrl == null) {
                return;
            }
            this.thisString = null;
            URLLoader loader = null;
            String file = newUrl.getFile();
            String protocol = newUrl.getProtocol();
            if ("file".equals(protocol)) {
                File dir = new File(file);
                try {
                    absoluteURL = dir.getCanonicalFile().toURL();
                }
                catch (IOException iOException) {
                    try {
                        absoluteURL = dir.getAbsoluteFile().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        absoluteURL = newUrl;
                    }
                }
            } else {
                absoluteURL = newUrl;
            }
            try {
                Class<?> handler = Class.forName(URL_LOADER_PREFIX + protocol);
                Class[] argTypes = new Class[]{URLClassLoader.class, URLStreamHandlerCache.class, URLStreamHandlerFactory.class, URL.class, URL.class};
                Constructor<?> k = handler.getDeclaredConstructor(argTypes);
                loader = (URLLoader)k.newInstance(this, factoryCache, this.factory, newUrl, absoluteURL);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException nsme) {
                InternalError vme = new InternalError("couldn't find URLLoader constructor");
                vme.initCause(nsme);
                throw vme;
            }
            catch (InstantiationException inste) {
                InternalError vme = new InternalError("couldn't instantiate URLLoader");
                vme.initCause(inste);
                throw vme;
            }
            catch (InvocationTargetException ite) {
                InternalError vme = new InternalError("error instantiating URLLoader");
                vme.initCause(ite);
                throw vme;
            }
            catch (IllegalAccessException illae) {
                InternalError vme = new InternalError("invalid access to URLLoader");
                vme.initCause(illae);
                throw vme;
            }
            if (loader == null) {
                loader = !file.endsWith("/") && !file.endsWith(File.separator) ? new JarURLLoader(this, factoryCache, this.factory, newUrl, absoluteURL) : ("file".equals(protocol) ? new FileURLLoader(this, factoryCache, this.factory, newUrl, absoluteURL) : new RemoteURLLoader(this, factoryCache, this.factory, newUrl));
            }
            this.urlinfos.add(loader);
            ArrayList<URLLoader> extra = loader.getClassPath();
            if (extra != null) {
                this.urlinfos.addAll((Collection<URLLoader>)extra);
            }
        }
    }

    private void addURLs(URL[] newUrls) {
        int i = 0;
        while (i < newUrls.length) {
            this.urls.add(newUrls[i]);
            this.addURLImpl(newUrls[i]);
            ++i;
        }
    }

    private String getAttributeValue(Attributes.Name name, Attributes first, Attributes second) {
        String result = null;
        if (first != null) {
            result = first.getValue(name);
        }
        if (result == null) {
            result = second.getValue(name);
        }
        return result;
    }

    protected Package definePackage(String name, Manifest manifest, URL url) throws IllegalArgumentException {
        CPStringBuilder xform = new CPStringBuilder(name);
        int i = xform.length() - 1;
        while (i >= 0) {
            if (xform.charAt(i) == '.') {
                xform.setCharAt(i, '/');
            }
            --i;
        }
        xform.append('/');
        String xformName = xform.toString();
        Attributes entryAttr = manifest.getAttributes(xformName);
        Attributes attr = manifest.getMainAttributes();
        String specTitle = this.getAttributeValue(Attributes.Name.SPECIFICATION_TITLE, entryAttr, attr);
        String specVersion = this.getAttributeValue(Attributes.Name.SPECIFICATION_VERSION, entryAttr, attr);
        String specVendor = this.getAttributeValue(Attributes.Name.SPECIFICATION_VENDOR, entryAttr, attr);
        String implTitle = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_TITLE, entryAttr, attr);
        String implVersion = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VERSION, entryAttr, attr);
        String implVendor = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VENDOR, entryAttr, attr);
        String sealed = attr.getValue(Attributes.Name.SEALED);
        if ("false".equals(sealed)) {
            url = null;
        }
        return this.definePackage(name, specTitle, specVendor, specVersion, implTitle, implVendor, implVersion, url);
    }

    @Override
    protected Class<?> findClass(final String className) throws ClassNotFoundException {
        String resourceName = String.valueOf(className.replace('.', '/')) + ".class";
        int max = this.urlinfos.size();
        Resource resource = null;
        int i = 0;
        while (i < max && resource == null) {
            URLLoader loader = this.urlinfos.elementAt(i);
            if (loader != null) {
                Class k = loader.getClass(className);
                if (k != null) {
                    return k;
                }
                resource = loader.getResource(resourceName);
            }
            ++i;
        }
        if (resource == null) {
            throw new ClassNotFoundException(String.valueOf(className) + " not found in " + this);
        }
        try {
            byte[] data;
            InputStream in = resource.getInputStream();
            try {
                int length = resource.getLength();
                if (length != -1) {
                    data = new byte[length];
                    int pos = 0;
                    while (length - pos > 0) {
                        int len = in.read(data, pos, length - pos);
                        if (len == -1) {
                            throw new EOFException("Not enough data reading from: " + in);
                        }
                        pos += len;
                    }
                } else {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                    byte[] b = new byte[4096];
                    int l = 0;
                    while (l != -1) {
                        l = in.read(b);
                        if (l == -1) continue;
                        out.write(b, 0, l);
                    }
                    data = out.toByteArray();
                }
            }
            finally {
                in.close();
            }
            final byte[] classData = data;
            final CodeSource source = resource.getCodeSource();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot != -1) {
                packageName = className.substring(0, lastDot);
            }
            if (packageName != null && this.getPackage(packageName) == null) {
                Manifest manifest = resource.getLoader().getManifest();
                if (manifest == null) {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                } else {
                    this.definePackage(packageName, manifest, resource.getLoader().getBaseURL());
                }
            }
            SecurityManager sm = System.getSecurityManager();
            Class result = null;
            result = sm != null && this.securityContext != null ? AccessController.doPrivileged(new PrivilegedAction<Class>(){

                @Override
                public Class run() {
                    return URLClassLoader.this.defineClass(className, classData, 0, classData.length, source);
                }
            }, this.securityContext) : this.defineClass(className, classData, 0, classData.length, source);
            Object[] resourceCertificates = resource.getCertificates();
            if (resourceCertificates != null) {
                super.setSigners(result, resourceCertificates);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(String.valueOf(className) + " not found in " + this, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            if (this.thisString == null) {
                CPStringBuilder sb = new CPStringBuilder();
                sb.append(this.getClass().getName());
                sb.append("{urls=[");
                URL[] thisURLs = this.getURLs();
                int i = 0;
                while (i < thisURLs.length) {
                    sb.append(thisURLs[i]);
                    if (i < thisURLs.length - 1) {
                        sb.append(',');
                    }
                    ++i;
                }
                sb.append(']');
                sb.append(", parent=");
                sb.append(this.getParent());
                sb.append('}');
                this.thisString = sb.toString();
            }
            return this.thisString;
        }
    }

    private Resource findURLResource(String resourceName) {
        int max = this.urlinfos.size();
        int i = 0;
        while (i < max) {
            Resource resource;
            URLLoader loader = this.urlinfos.elementAt(i);
            if (loader != null && (resource = loader.getResource(resourceName)) != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    @Override
    public URL findResource(String resourceName) {
        Resource resource = this.findURLResource(resourceName);
        if (resource != null) {
            return resource.getURL();
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String resourceName) throws IOException {
        Vector<URL> resources = new Vector<URL>();
        int max = this.urlinfos.size();
        int i = 0;
        while (i < max) {
            URLLoader loader = this.urlinfos.elementAt(i);
            Resource resource = loader.getResource(resourceName);
            if (resource != null) {
                resources.add(resource.getURL());
            }
            ++i;
        }
        return resources.elements();
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource source) {
        PermissionCollection permissions = super.getPermissions(source);
        URL url = source.getLocation();
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            String file = url.getFile();
            if (file.endsWith("/") || file.endsWith(File.separator)) {
                permissions.add(new FilePermission(String.valueOf(file) + "-", "read"));
            } else {
                permissions.add(new FilePermission(file, "read"));
            }
        } else {
            String host = url.getHost();
            if (host != null) {
                permissions.add(new SocketPermission(host, "connect,accept"));
            }
        }
        return permissions;
    }

    public URL[] getURLs() {
        return this.urls.toArray((S[])new URL[this.urls.size()]);
    }

    public static URLClassLoader newInstance(URL[] urls) throws SecurityException {
        return URLClassLoader.newInstance(urls, null);
    }

    public static URLClassLoader newInstance(URL[] urls, final ClassLoader parent) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return new URLClassLoader(urls, parent);
        }
        final Object securityContext = sm.getSecurityContext();
        if (!(securityContext instanceof AccessControlContext)) {
            throw new SecurityException("securityContext must be AccessControlContext: " + securityContext);
        }
        URLClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(parent, (AccessControlContext)securityContext);
            }
        });
        loader.addURLs(urls);
        return loader;
    }
}

