/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.UID;

public class ActivationID
implements Serializable {
    static final long serialVersionUID = -4608673054848209235L;
    transient Activator activator;
    transient UID uid;
    transient ActivationGroup group;

    public ActivationID(Activator an_activator) {
        this.activator = an_activator;
        this.uid = new UID();
    }

    public Remote activate(boolean force) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            return this.activator.activate(this, force).get();
        }
        catch (IOException e) {
            ActivationException acex = new ActivationException("id " + this.uid, e);
            throw acex;
        }
        catch (ClassNotFoundException e) {
            ActivationException acex = new ActivationException("id " + this.uid, e);
            throw acex;
        }
    }

    public int hashCode() {
        return this.uid == null ? 0 : this.uid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActivationID) {
            ActivationID that = (ActivationID)obj;
            return ActivationID.eq(this.uid, that.uid);
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.uid = (UID)in.readObject();
        this.activator = (Activator)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.writeObject(this.uid);
        out.writeObject(this.activator);
    }

    static final boolean eq(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public String toString() {
        return this.uid.toString();
    }
}

