/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import gnu.gcj.RawData;

public class Deflater {
    public static final int BEST_COMPRESSION = 9;
    public static final int BEST_SPEED = 1;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int NO_COMPRESSION = 0;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFLATED = 8;
    private int level;
    private int strategy = 0;
    private RawData zstream;
    private boolean is_finished;
    private int flush_flag;

    public Deflater() {
        this(-1, false);
    }

    public Deflater(int lvl) {
        this(lvl, false);
    }

    public Deflater(int lvl, boolean noHeader) {
        this.init(lvl, noHeader);
        this.setLevel(lvl);
    }

    private native void init(int var1, boolean var2);

    private native void update();

    public native void reset();

    public native void end();

    public native int getAdler();

    @Deprecated
    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    public native long getBytesRead();

    @Deprecated
    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    public native long getBytesWritten();

    protected void finalize() {
        this.end();
    }

    public native void finish();

    public synchronized boolean finished() {
        return this.is_finished;
    }

    public native boolean needsInput();

    public void setInput(byte[] input) {
        this.setInput(input, 0, input.length);
    }

    public native void setInput(byte[] var1, int var2, int var3);

    public synchronized void setLevel(int lvl) {
        if (lvl != -1 && (lvl < 0 || lvl > 9)) {
            throw new IllegalArgumentException();
        }
        this.level = lvl == -1 ? 6 : lvl;
        this.update();
    }

    public synchronized void setStrategy(int stgy) {
        if (stgy != 0 && stgy != 1 && stgy != 2) {
            throw new IllegalArgumentException();
        }
        this.strategy = stgy;
        this.update();
    }

    public int deflate(byte[] output) {
        return this.deflate(output, 0, output.length);
    }

    public native int deflate(byte[] var1, int var2, int var3);

    public void setDictionary(byte[] dict) {
        this.setDictionary(dict, 0, dict.length);
    }

    public native void setDictionary(byte[] var1, int var2, int var3);

    void flush() {
    }
}

