/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalCheckBoxIcon;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.plaf.metal.OceanTheme;

public class MetalIconFactory
implements Serializable {
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    private static Icon menuArrow;
    private static Icon menuItemArrow;
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon fileChooserDetailViewIcon;
    private static Icon fileChooserHomeFolderIcon;
    private static Icon fileChooserListViewIcon;
    private static Icon fileChooserNewFolderIcon;
    private static Icon fileChooserUpFolderIcon;
    private static RadioButtonIcon radioButtonIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon internalFrameDefaultMenuIcon;
    private static Icon treeComputerIcon;
    private static Icon treeFloppyDriveIcon;
    private static Icon treeHardDriveIcon;
    private static Icon horizontalSliderThumbIcon;
    private static Icon verticalSliderThumbIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new MetalCheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = new FileChooserDetailViewIcon();
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = new FileChooserHomeFolderIcon();
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = new FileChooserListViewIcon();
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = new FileChooserNewFolderIcon();
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = new FileChooserUpFolderIcon();
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getHorizontalSliderThumbIcon() {
        if (horizontalSliderThumbIcon == null) {
            horizontalSliderThumbIcon = new HorizontalSliderThumbIcon();
        }
        return horizontalSliderThumbIcon;
    }

    public static Icon getInternalFrameCloseIcon(int size) {
        return new InternalFrameCloseIcon(size);
    }

    public static Icon getInternalFrameDefaultMenuIcon() {
        if (internalFrameDefaultMenuIcon == null) {
            internalFrameDefaultMenuIcon = new InternalFrameDefaultMenuIcon();
        }
        return internalFrameDefaultMenuIcon;
    }

    public static Icon getInternalFrameMaximizeIcon(int size) {
        return new InternalFrameMaximizeIcon();
    }

    public static Icon getInternalFrameMinimizeIcon(int size) {
        return new InternalFrameMinimizeIcon();
    }

    public static Icon getInternalFrameAltMaximizeIcon(int size) {
        return new InternalFrameAltMaximizeIcon(size);
    }

    public static Icon getVerticalSliderThumbIcon() {
        if (verticalSliderThumbIcon == null) {
            verticalSliderThumbIcon = new VerticalSliderThumbIcon();
        }
        return verticalSliderThumbIcon;
    }

    public static Icon getTreeFolderIcon() {
        return new TreeFolderIcon();
    }

    public static Icon getTreeLeafIcon() {
        return new TreeLeafIcon();
    }

    public static Icon getTreeControlIcon(boolean isCollapsed) {
        return new TreeControlIcon(isCollapsed);
    }

    public static Icon getTreeComputerIcon() {
        if (treeComputerIcon == null) {
            treeComputerIcon = new TreeComputerIcon();
        }
        return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if (treeFloppyDriveIcon == null) {
            treeFloppyDriveIcon = new TreeFloppyDriveIcon();
        }
        return treeFloppyDriveIcon;
    }

    public static Icon getTreeHardDriveIcon() {
        if (treeHardDriveIcon == null) {
            treeHardDriveIcon = new TreeHardDriveIcon();
        }
        return treeHardDriveIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrow == null) {
            menuArrow = new Icon(){

                public int getIconHeight() {
                    return 8;
                }

                public int getIconWidth() {
                    return 4;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Color saved = g.getColor();
                    g.setColor(Color.BLACK);
                    int i = 0;
                    while (i < 4) {
                        g.drawLine(x + i, y + i, x + i, y + 7 - i);
                        ++i;
                    }
                    g.setColor(saved);
                }
            };
        }
        return menuArrow;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrow == null) {
            menuItemArrow = new Icon(){

                public int getIconHeight() {
                    return 8;
                }

                public int getIconWidth() {
                    return 4;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Color saved = g.getColor();
                    g.setColor(Color.BLACK);
                    int i = 0;
                    while (i < 4) {
                        g.drawLine(x + i, y + i, x + i, y + 7 - i);
                        ++i;
                    }
                    g.setColor(saved);
                }
            };
        }
        return menuItemArrow;
    }

    public static Icon getMenuItemCheckIcon() {
        return new Icon(){

            public int getIconHeight() {
                return 13;
            }

            public int getIconWidth() {
                return 13;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color saved = g.getColor();
                g.setColor(Color.BLACK);
                g.drawLine(3 + x, 5 + y, 3 + x, 9 + y);
                g.drawLine(4 + x, 5 + y, 4 + x, 9 + y);
                g.drawLine(5 + x, 7 + y, 9 + x, 3 + y);
                g.drawLine(5 + x, 8 + y, 9 + x, 4 + y);
                g.setColor(saved);
            }
        };
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)c;
            if (item.isArmed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(x, y, x + 8, y);
            g.drawLine(x, y + 1, x, y + 8);
            g.drawLine(x + 2, y + 8, x + 8, y + 8);
            g.drawLine(x + 8, y + 2, x + 8, y + 7);
            g.setColor(MetalLookAndFeel.getWhite());
            g.drawLine(x + 1, y + 1, x + 7, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y + 7);
            g.drawLine(x + 1, y + 9, x + 9, y + 9);
            g.drawLine(x + 9, y + 1, x + 9, y + 8);
            if (item.isSelected()) {
                g.setColor(MetalLookAndFeel.getBlack());
                g.fillRect(x + 2, y + 2, 2, 5);
                int i = 0;
                while (i < 6) {
                    g.drawLine(x + 8 - i, y + i, x + 9 - i, y + i);
                    ++i;
                }
            }
        }
    }

    private static class FileChooserDetailViewIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 2, y + 2, x + 5, y + 2);
            g.drawLine(x + 6, y + 3, x + 6, y + 7);
            g.drawLine(x + 2, y + 7, x + 6, y + 7);
            g.drawLine(x + 2, y + 2, x + 2, y + 7);
            g.drawLine(x + 2, y + 10, x + 5, y + 10);
            g.drawLine(x + 6, y + 11, x + 6, y + 15);
            g.drawLine(x + 2, y + 15, x + 6, y + 15);
            g.drawLine(x + 2, y + 10, x + 2, y + 15);
            g.drawLine(x + 8, y + 5, x + 15, y + 5);
            g.drawLine(x + 8, y + 13, x + 15, y + 13);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 3, y + 3, 3, 4);
            g.fillRect(x + 3, y + 11, 3, 4);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(x + 4, y + 4, x + 4, y + 5);
            g.drawLine(x + 4, y + 12, x + 4, y + 13);
            g.setColor(savedColor);
        }
    }

    private static class FileChooserHomeFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 1, y + 8, x + 8, y + 1);
            g.drawLine(x + 8, y + 1, x + 15, y + 8);
            g.drawLine(x + 3, y + 6, x + 3, y + 15);
            g.drawLine(x + 3, y + 15, x + 13, y + 15);
            g.drawLine(x + 13, y + 6, x + 13, y + 15);
            g.drawLine(x + 6, y + 9, x + 6, y + 15);
            g.drawLine(x + 6, y + 9, x + 10, y + 9);
            g.drawLine(x + 10, y + 9, x + 10, y + 15);
            g.drawLine(x + 11, y + 2, x + 11, y + 4);
            g.drawLine(x + 12, y + 2, x + 12, y + 5);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            int xx = x + 8;
            int i = 0;
            while (i < 4) {
                g.drawLine(xx - i, y + 2 + i, xx + i, y + 2 + i);
                ++i;
            }
            g.fillRect(x + 4, y + 6, 9, 2);
            g.drawLine(x + 9, y + 12, x + 9, y + 12);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.drawLine(x + 4, y + 8, x + 12, y + 8);
            g.fillRect(x + 4, y + 9, 2, 6);
            g.fillRect(x + 11, y + 9, 2, 6);
            g.setColor(savedColor);
        }
    }

    private static class FileChooserListViewIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 2, y + 2, x + 5, y + 2);
            g.drawLine(x + 6, y + 3, x + 6, y + 7);
            g.drawLine(x + 2, y + 7, x + 6, y + 7);
            g.drawLine(x + 2, y + 2, x + 2, y + 7);
            g.drawLine(x + 2, y + 10, x + 5, y + 10);
            g.drawLine(x + 6, y + 11, x + 6, y + 15);
            g.drawLine(x + 2, y + 15, x + 6, y + 15);
            g.drawLine(x + 2, y + 10, x + 2, y + 15);
            g.drawLine(x + 10, y + 2, x + 13, y + 2);
            g.drawLine(x + 14, y + 3, x + 14, y + 7);
            g.drawLine(x + 10, y + 7, x + 14, y + 7);
            g.drawLine(x + 10, y + 2, x + 10, y + 7);
            g.drawLine(x + 10, y + 10, x + 13, y + 10);
            g.drawLine(x + 14, y + 11, x + 14, y + 15);
            g.drawLine(x + 10, y + 15, x + 14, y + 15);
            g.drawLine(x + 10, y + 10, x + 10, y + 15);
            g.drawLine(x + 8, y + 5, x + 8, y + 5);
            g.drawLine(x + 8, y + 13, x + 8, y + 13);
            g.drawLine(x + 16, y + 5, x + 16, y + 5);
            g.drawLine(x + 16, y + 13, x + 16, y + 13);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 3, y + 3, 3, 4);
            g.fillRect(x + 3, y + 11, 3, 4);
            g.fillRect(x + 11, y + 3, 3, 4);
            g.fillRect(x + 11, y + 11, 3, 4);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(x + 4, y + 4, x + 4, y + 5);
            g.drawLine(x + 4, y + 12, x + 4, y + 13);
            g.drawLine(x + 12, y + 4, x + 12, y + 5);
            g.drawLine(x + 12, y + 12, x + 12, y + 13);
            g.setColor(savedColor);
        }
    }

    private static class FileChooserNewFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 2, y + 5, x + 9, y + 5);
            g.drawLine(x + 10, y + 6, x + 15, y + 6);
            g.drawLine(x + 15, y + 5, x + 15, y + 14);
            g.drawLine(x + 2, y + 14, x + 15, y + 14);
            g.drawLine(x + 1, y + 6, x + 1, y + 14);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(x + 11, y + 3, x + 15, y + 3);
            g.drawLine(x + 10, y + 4, x + 15, y + 4);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 3, y + 7, 7, 7);
            g.fillRect(x + 10, y + 8, 5, 6);
            g.drawLine(x + 10, y + 5, x + 14, y + 5);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(x + 10, y + 7, x + 14, y + 7);
            g.drawLine(x + 2, y + 6, x + 9, y + 6);
            g.drawLine(x + 2, y + 6, x + 2, y + 13);
            g.setColor(savedColor);
        }
    }

    private static class FileChooserUpFolderIcon
    extends FileChooserNewFolderIcon {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            super.paintIcon(c, g, x, y);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 8, y + 9, x + 8, y + 16);
            int xx = x + 8;
            int i = 0;
            while (i < 4) {
                g.drawLine(xx - i, y + 9 + i, xx + i, y + 9 + i);
                ++i;
            }
            g.setColor(savedColor);
        }
    }

    public static class FileIcon16
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16 + this.getAdditionalHeight();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x, y += this.getShift(), x + 9, y);
            g.drawLine(x, y + 1, x, y + 15);
            g.drawLine(x, y + 15, x + 12, y + 15);
            g.drawLine(x + 12, y + 15, x + 12, y + 6);
            g.drawLine(x + 12, y + 6, x + 9, y);
            g.drawLine(x + 7, y + 2, x + 11, y + 6);
            g.drawLine(x + 8, y + 1, x + 9, y + 1);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.drawLine(x + 1, y + 1, x + 7, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + 14);
            g.drawLine(x + 1, y + 14, x + 11, y + 14);
            g.drawLine(x + 11, y + 14, x + 11, y + 7);
            g.drawLine(x + 8, y + 2, x + 10, y + 4);
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getShift() {
            return 0;
        }
    }

    public static class FolderIcon16
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16 + this.getAdditionalHeight();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x, (y += this.getShift()) + 6, x, y + 15);
            g.drawLine(x, y + 15, x + 15, y + 15);
            g.drawLine(x + 15, y + 15, x + 15, y + 5);
            g.drawLine(x + 14, y + 6, x + 9, y + 6);
            g.drawLine(x + 8, y + 5, x + 1, y + 5);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 2, y + 7, 7, 8);
            g.fillRect(x + 9, y + 8, 6, 7);
            g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            g.drawLine(x + 9, y + 5, x + 14, y + 5);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(x + 9, y + 4, x + 15, y + 4);
            g.drawLine(x + 10, y + 3, x + 15, y + 3);
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getShift() {
            return 0;
        }
    }

    private static class HorizontalSliderThumbIcon
    implements Icon,
    UIResource,
    Serializable {
        int[][] gradientMask;

        public HorizontalSliderThumbIcon() {
            int[][] nArrayArray = new int[13][];
            int[] nArray = new int[2];
            nArray[1] = 12;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[2];
            nArray2[1] = 12;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[2];
            nArray3[1] = 12;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[2];
            nArray4[1] = 12;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[2];
            nArray5[1] = 12;
            nArrayArray[4] = nArray5;
            int[] nArray6 = new int[2];
            nArray6[1] = 12;
            nArrayArray[5] = nArray6;
            int[] nArray7 = new int[2];
            nArray7[1] = 12;
            nArrayArray[6] = nArray7;
            nArrayArray[7] = new int[]{1, 11};
            nArrayArray[8] = new int[]{2, 10};
            nArrayArray[9] = new int[]{3, 9};
            nArrayArray[10] = new int[]{4, 8};
            nArrayArray[11] = new int[]{5, 7};
            nArrayArray[12] = new int[]{6, 6};
            this.gradientMask = nArrayArray;
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean enabled = false;
            boolean focus = false;
            if (c != null) {
                enabled = c.isEnabled();
                focus = c.hasFocus();
            }
            if (enabled) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(x + 1, y, x + 13, y);
            g.drawLine(x + 14, y + 1, x + 14, y + 7);
            g.drawLine(x + 14, y + 8, x + 7, y + 15);
            g.drawLine(x + 6, y + 14, x, y + 8);
            g.drawLine(x, y + 7, x, y + 1);
            if (focus) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControl());
            }
            g.fillRect(x + 1, y + 2, 13, 7);
            g.drawLine(x + 2, y + 9, x + 12, y + 9);
            g.drawLine(x + 3, y + 10, x + 11, y + 10);
            g.drawLine(x + 4, y + 11, x + 10, y + 11);
            g.drawLine(x + 5, y + 12, x + 9, y + 12);
            g.drawLine(x + 6, y + 13, x + 8, y + 13);
            g.drawLine(x + 7, y + 14, x + 7, y + 14);
            if (c.isEnabled() && !(MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme)) {
                if (focus) {
                    g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    g.setColor(MetalLookAndFeel.getBlack());
                }
                g.drawLine(x + 3, y + 3, x + 3, y + 3);
                g.drawLine(x + 7, y + 3, x + 7, y + 3);
                g.drawLine(x + 11, y + 3, x + 11, y + 3);
                g.drawLine(x + 5, y + 5, x + 5, y + 5);
                g.drawLine(x + 9, y + 5, x + 9, y + 5);
                g.drawLine(x + 3, y + 7, x + 3, y + 7);
                g.drawLine(x + 7, y + 7, x + 7, y + 7);
                g.drawLine(x + 11, y + 7, x + 11, y + 7);
                if (focus) {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    g.setColor(MetalLookAndFeel.getWhite());
                }
                g.drawLine(x + 1, y + 1, x + 13, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 8);
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                g.drawLine(x + 6, y + 2, x + 6, y + 2);
                g.drawLine(x + 10, y + 2, x + 10, y + 2);
                g.drawLine(x + 4, y + 4, x + 4, y + 4);
                g.drawLine(x + 8, y + 4, x + 8, y + 4);
                g.drawLine(x + 2, y + 6, x + 2, y + 6);
                g.drawLine(x + 6, y + 6, x + 6, y + 6);
                g.drawLine(x + 10, y + 6, x + 10, y + 6);
            }
        }
    }

    private static class InternalFrameAltMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        private int size;

        public InternalFrameAltMaximizeIcon(int size) {
            this.size = size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton b = (AbstractButton)c;
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControl());
            }
            g.fillRect(x + 2, y + 6, 7, 7);
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            g.drawLine(x + 12, y + 1, x + 13, y + 1);
            g.drawLine(x + 11, y + 2, x + 12, y + 2);
            g.drawLine(x + 10, y + 3, x + 11, y + 3);
            g.drawLine(x + 8, y + 2, x + 8, y + 3);
            g.fillRect(x + 8, y + 4, 3, 3);
            g.drawLine(x + 11, y + 6, x + 12, y + 6);
            g.drawLine(x + 1, y + 5, x + 5, y + 5);
            g.drawLine(x + 1, y + 6, x + 1, y + 12);
            g.drawLine(x + 9, y + 9, x + 9, y + 12);
            g.drawLine(x + 1, y + 13, x + 9, y + 13);
            g.drawLine(x + 2, y + 12, x + 2, y + 12);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 12, y, x + 9, y + 3);
            g.drawLine(x + 7, y + 1, x + 8, y + 1);
            g.drawLine(x + 7, y + 2, x + 7, y + 6);
            g.drawLine(x + 11, y + 5, x + 12, y + 5);
            g.drawLine(x, y + 4, x + 5, y + 4);
            g.drawLine(x, y + 5, x, y + 13);
            g.drawLine(x + 3, y + 12, x + 8, y + 12);
            g.drawLine(x + 8, y + 8, x + 8, y + 11);
            g.drawLine(x + 9, y + 8, x + 9, y + 8);
            g.setColor(MetalLookAndFeel.getWhite());
            g.drawLine(x + 9, y + 2, x + 9, y + 2);
            g.drawLine(x + 11, y + 4, x + 13, y + 2);
            g.drawLine(x + 13, y + 6, x + 13, y + 6);
            g.drawLine(x + 8, y + 7, x + 13, y + 7);
            g.drawLine(x + 6, y + 5, x + 6, y + 5);
            g.drawLine(x + 10, y + 8, x + 10, y + 13);
            g.drawLine(x + 1, y + 14, x + 10, y + 14);
            if (!b.getModel().isPressed()) {
                g.drawLine(x + 2, y + 6, x + 6, y + 6);
                g.drawLine(x + 2, y + 6, x + 2, y + 11);
            }
            g.setColor(savedColor);
        }
    }

    private static class InternalFrameCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        private int size;

        public InternalFrameCloseIcon(int size) {
            this.size = size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton b = (AbstractButton)c;
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControl());
            }
            g.fillRect(x + 2, y + 2, 10, 10);
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                boolean selected = true;
                if (selected) {
                    g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                }
            }
            g.drawLine(x + 1, y + 1, x + 13, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y + 12);
            g.drawLine(x + 1, y + 13, x + 13, y + 13);
            g.drawLine(x + 13, y + 2, x + 13, y + 12);
            g.drawLine(x + 2, y + 12, x + 2, y + 12);
            g.drawLine(x + 12, y + 2, x + 12, y + 2);
            g.fillRect(x + 4, y + 4, 2, 2);
            g.fillRect(x + 5, y + 5, 4, 4);
            g.drawLine(x + 9, y + 4, x + 10, y + 4);
            g.drawLine(x + 9, y + 4, x + 9, y + 5);
            g.drawLine(x + 4, y + 9, x + 4, y + 10);
            g.drawLine(x + 4, y + 9, x + 5, y + 9);
            g.drawLine(x + 9, y + 8, x + 9, y + 10);
            g.drawLine(x + 8, y + 9, x + 10, y + 9);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x, y, x + 13, y);
            g.drawLine(x, y + 1, x, y + 13);
            g.drawLine(x + 3, y + 4, x + 4, y + 3);
            g.drawLine(x + 3, y + 9, x + 5, y + 7);
            g.drawLine(x + 7, y + 5, x + 9, y + 3);
            g.drawLine(x + 12, y + 3, x + 12, y + 11);
            g.drawLine(x + 3, y + 12, x + 12, y + 12);
            g.setColor(MetalLookAndFeel.getWhite());
            g.drawLine(x + 1, y + 14, x + 14, y + 14);
            g.drawLine(x + 14, y + 1, x + 14, y + 14);
            if (!b.getModel().isPressed()) {
                g.drawLine(x + 5, y + 10, x + 5, y + 10);
                g.drawLine(x + 6, y + 9, x + 7, y + 9);
                g.drawLine(x + 10, y + 5, x + 10, y + 5);
                g.drawLine(x + 9, y + 6, x + 9, y + 7);
                g.drawLine(x + 10, y + 10, x + 11, y + 10);
                g.drawLine(x + 10, y + 11, x + 10, y + 11);
            }
            g.setColor(savedColor);
        }
    }

    private static class InternalFrameDefaultMenuIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.fillRect(x + 1, y, 14, 2);
            g.fillRect(x, y + 1, 2, 14);
            g.fillRect(x + 1, y + 14, 14, 2);
            g.fillRect(x + 14, y + 1, 2, 14);
            g.drawLine(x + 2, y + 5, x + 14, y + 5);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 2, y + 2, 12, 3);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(x + 3, y + 3, x + 3, y + 3);
            g.drawLine(x + 6, y + 3, x + 6, y + 3);
            g.drawLine(x + 9, y + 3, x + 9, y + 3);
            g.drawLine(x + 12, y + 3, x + 12, y + 3);
            g.setColor(MetalLookAndFeel.getWhite());
            g.fillRect(x + 2, y + 6, 12, 8);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            g.drawLine(x + 5, y + 2, x + 5, y + 2);
            g.drawLine(x + 8, y + 2, x + 8, y + 2);
            g.drawLine(x + 11, y + 2, x + 11, y + 2);
        }
    }

    private static class InternalFrameMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton b = (AbstractButton)c;
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControl());
            }
            g.fillRect(x + 2, y + 6, 7, 7);
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            g.drawLine(x + 9, y + 1, x + 10, y + 1);
            g.fillRect(x + 11, y + 1, 3, 3);
            g.fillRect(x + 12, y + 4, 2, 2);
            g.drawLine(x + 10, y + 3, x + 10, y + 3);
            g.drawLine(x + 9, y + 4, x + 10, y + 4);
            g.drawLine(x + 1, y + 5, x + 9, y + 5);
            g.drawLine(x + 1, y + 6, x + 1, y + 12);
            g.drawLine(x + 9, y + 6, x + 9, y + 12);
            g.drawLine(x + 1, y + 13, x + 9, y + 13);
            g.drawLine(x + 7, y + 6, x + 8, y + 6);
            g.drawLine(x + 6, y + 7, x + 8, y + 7);
            g.drawLine(x + 5, y + 8, x + 6, y + 8);
            g.drawLine(x + 4, y + 9, x + 5, y + 9);
            g.drawLine(x + 3, y + 10, x + 4, y + 10);
            g.drawLine(x + 2, y + 11, x + 3, y + 11);
            g.drawLine(x + 2, y + 12, x + 4, y + 12);
            g.drawLine(x + 8, y + 8, x + 8, y + 8);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 8, y, x + 13, y);
            g.drawLine(x + 8, y + 1, x + 8, y + 1);
            g.drawLine(x + 10, y + 2, x + 9, y + 3);
            g.drawLine(x, y + 4, x + 8, y + 4);
            g.drawLine(x, y + 5, x, y + 13);
            g.drawLine(x + 2, y + 10, x + 6, y + 6);
            g.drawLine(x + 8, y + 9, x + 8, y + 11);
            g.drawLine(x + 5, y + 12, x + 8, y + 12);
            g.setColor(MetalLookAndFeel.getWhite());
            if (!b.getModel().isPressed()) {
                g.drawLine(x + 2, y + 6, x + 5, y + 6);
                g.drawLine(x + 2, y + 7, x + 2, y + 9);
                g.drawLine(x + 4, y + 11, x + 7, y + 8);
            }
            g.drawLine(x + 1, y + 14, x + 10, y + 14);
            g.drawLine(x + 10, y + 5, x + 10, y + 13);
            g.drawLine(x + 9, y + 2, x + 9, y + 2);
            g.drawLine(x + 11, y + 4, x + 11, y + 5);
            g.drawLine(x + 13, y + 6, x + 14, y + 6);
            g.drawLine(x + 14, y + 1, x + 14, y + 5);
            g.setColor(savedColor);
        }
    }

    private static class InternalFrameMinimizeIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton b = (AbstractButton)c;
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            g.drawLine(x + 12, y + 1, x + 13, y + 1);
            g.drawLine(x + 11, y + 2, x + 12, y + 2);
            g.drawLine(x + 10, y + 3, x + 11, y + 3);
            g.drawLine(x + 8, y + 2, x + 8, y + 3);
            g.fillRect(x + 8, y + 4, 3, 3);
            g.drawLine(x + 11, y + 6, x + 12, y + 6);
            g.drawLine(x + 1, y + 8, x + 6, y + 8);
            g.drawLine(x + 1, y + 9, x + 1, y + 12);
            g.drawLine(x + 6, y + 9, x + 6, y + 12);
            g.drawLine(x + 1, y + 13, x + 6, y + 13);
            g.drawLine(x + 5, y + 9, x + 5, y + 9);
            g.drawLine(x + 2, y + 12, x + 2, y + 12);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 12, y, x + 9, y + 3);
            g.drawLine(x + 7, y + 1, x + 8, y + 1);
            g.drawLine(x + 7, y + 2, x + 7, y + 6);
            g.drawLine(x, y + 7, x + 6, y + 7);
            g.drawLine(x, y + 8, x, y + 13);
            g.drawLine(x + 3, y + 12, x + 5, y + 12);
            g.drawLine(x + 5, y + 10, x + 5, y + 11);
            g.drawLine(x + 11, y + 5, x + 12, y + 5);
            g.setColor(MetalLookAndFeel.getWhite());
            g.drawLine(x + 9, y + 2, x + 9, y + 2);
            g.drawLine(x + 11, y + 4, x + 13, y + 2);
            g.drawLine(x + 13, y + 6, x + 13, y + 6);
            g.drawLine(x + 8, y + 7, x + 13, y + 7);
            g.drawLine(x + 7, y + 9, x + 7, y + 13);
            g.drawLine(x + 1, y + 14, x + 7, y + 14);
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                g.fillRect(x + 2, y + 9, 3, 3);
            } else {
                g.drawLine(x + 2, y + 9, x + 4, y + 9);
                g.drawLine(x + 2, y + 10, x + 2, y + 11);
            }
            g.setColor(savedColor);
        }
    }

    public static class PaletteCloseIcon
    implements Icon,
    Serializable,
    UIResource {
        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton button = (AbstractButton)c;
            if (button.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.fillRect(x + 2, y + 2, 3, 3);
            g.drawLine(x + 1, y, x + 1, y + 2);
            g.drawLine(x, y + 1, x + 2, y + 1);
            g.drawLine(x + 5, y, x + 5, y + 2);
            g.drawLine(x + 4, y + 1, x + 6, y + 1);
            g.drawLine(x + 1, y + 4, x + 1, y + 6);
            g.drawLine(x, y + 5, x + 2, y + 5);
            g.drawLine(x + 5, y + 4, x + 5, y + 6);
            g.drawLine(x + 4, y + 5, x + 6, y + 5);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(x + 2, y + 6, x + 3, y + 5);
            g.drawLine(x + 5, y + 3, x + 6, y + 2);
            g.drawLine(x + 6, y + 6, x + 6, y + 6);
            g.setColor(savedColor);
        }
    }

    static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static int[][] gradientMask;

        static {
            int[][] nArrayArray = new int[10][];
            nArrayArray[0] = new int[]{3, 7};
            nArrayArray[1] = new int[]{1, 9};
            nArrayArray[2] = new int[]{1, 9};
            int[] nArray = new int[2];
            nArray[1] = 10;
            nArrayArray[3] = nArray;
            int[] nArray2 = new int[2];
            nArray2[1] = 10;
            nArrayArray[4] = nArray2;
            int[] nArray3 = new int[2];
            nArray3[1] = 10;
            nArrayArray[5] = nArray3;
            int[] nArray4 = new int[2];
            nArray4[1] = 10;
            nArrayArray[6] = nArray4;
            nArrayArray[7] = new int[]{1, 9};
            nArrayArray[8] = new int[]{1, 9};
            nArrayArray[9] = new int[]{3, 7};
            gradientMask = nArrayArray;
        }

        RadioButtonIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (UIManager.get("RadioButton.gradient") != null) {
                MetalUtils.paintGradient(g, x + 2, y + 2, 8, 8, 1, "RadioButton.gradient", gradientMask);
            }
            Color savedColor = g.getColor();
            JRadioButton b = (JRadioButton)c;
            if (b.isEnabled()) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControlDisabled());
            }
            g.drawLine(x + 2, y + 1, x + 3, y + 1);
            g.drawLine(x + 4, y, x + 7, y);
            g.drawLine(x + 8, y + 1, x + 9, y + 1);
            g.drawLine(x + 10, y + 2, x + 10, y + 3);
            g.drawLine(x + 11, y + 4, x + 11, y + 7);
            g.drawLine(x + 10, y + 8, x + 10, y + 9);
            g.drawLine(x + 8, y + 10, x + 9, y + 10);
            g.drawLine(x + 4, y + 11, x + 7, y + 11);
            g.drawLine(x + 2, y + 10, x + 3, y + 10);
            g.drawLine(x + 1, y + 9, x + 1, y + 8);
            g.drawLine(x, y + 7, x, y + 4);
            g.drawLine(x + 1, y + 2, x + 1, y + 3);
            if (b.getModel().isArmed()) {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawLine(x + 4, y + 1, x + 7, y + 1);
                g.drawLine(x + 4, y + 10, x + 7, y + 10);
                g.drawLine(x + 1, y + 4, x + 1, y + 7);
                g.drawLine(x + 10, y + 4, x + 10, y + 7);
                g.fillRect(x + 2, y + 2, 8, 8);
            } else if (b.isEnabled()) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x + 2, y + 8, x + 2, y + 9);
                g.drawLine(x + 1, y + 4, x + 1, y + 7);
                g.drawLine(x + 2, y + 2, x + 2, y + 3);
                g.drawLine(x + 3, y + 2, x + 3, y + 2);
                g.drawLine(x + 4, y + 1, x + 7, y + 1);
                g.drawLine(x + 8, y + 2, x + 9, y + 2);
            }
            if (b.isEnabled()) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x + 10, y + 1, x + 10, y + 1);
                g.drawLine(x + 11, y + 2, x + 11, y + 3);
                g.drawLine(x + 12, y + 4, x + 12, y + 7);
                g.drawLine(x + 11, y + 8, x + 11, y + 9);
                g.drawLine(x + 10, y + 10, x + 10, y + 10);
                g.drawLine(x + 8, y + 11, x + 9, y + 11);
                g.drawLine(x + 4, y + 12, x + 7, y + 12);
                g.drawLine(x + 2, y + 11, x + 3, y + 11);
            }
            if (b.isSelected()) {
                if (b.isEnabled()) {
                    g.setColor(MetalLookAndFeel.getBlack());
                } else {
                    g.setColor(MetalLookAndFeel.getControlDisabled());
                }
                g.drawLine(x + 4, y + 3, x + 7, y + 3);
                g.fillRect(x + 3, y + 4, 6, 4);
                g.drawLine(x + 4, y + 8, x + 7, y + 8);
            }
            g.setColor(savedColor);
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)c;
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 2, y, x + 6, y);
            g.drawLine(x + 7, y + 1, x + 7, y + 1);
            g.drawLine(x + 8, y + 2, x + 8, y + 6);
            g.drawLine(x + 7, y + 7, x + 7, y + 7);
            g.drawLine(x + 2, y + 8, x + 6, y + 8);
            g.drawLine(x + 1, y + 7, x + 1, y + 7);
            g.drawLine(x, y + 2, x, y + 6);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            if (item.isSelected()) {
                g.drawLine(x + 3, y + 2, x + 5, y + 2);
                g.fillRect(x + 2, y + 3, 5, 3);
                g.drawLine(x + 3, y + 6, x + 5, y + 6);
            }
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(x + 3, y + 1, x + 6, y + 1);
            g.drawLine(x + 8, y + 1, x + 8, y + 1);
            g.drawLine(x + 9, y + 2, x + 9, y + 7);
            g.drawLine(x + 8, y + 8, x + 8, y + 8);
            g.drawLine(x + 2, y + 9, x + 7, y + 9);
            g.drawLine(x + 1, y + 8, x + 1, y + 8);
            g.drawLine(x + 1, y + 3, x + 1, y + 6);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            g.setColor(savedColor);
        }
    }

    private static class TreeComputerIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color saved = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 3, y + 1, x + 12, y + 1);
            g.drawLine(x + 2, y + 2, x + 2, y + 8);
            g.drawLine(x + 13, y + 2, x + 13, y + 8);
            g.drawLine(x + 3, y + 9, x + 3, y + 9);
            g.drawLine(x + 12, y + 9, x + 12, y + 9);
            g.drawRect(x + 1, y + 10, 13, 4);
            g.drawLine(x + 5, y + 3, x + 10, y + 3);
            g.drawLine(x + 5, y + 8, x + 10, y + 8);
            g.drawLine(x + 4, y + 4, x + 4, y + 7);
            g.drawLine(x + 11, y + 4, x + 11, y + 7);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 5, y + 4, 6, 4);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(x + 6, y + 12, x + 8, y + 12);
            g.drawLine(x + 10, y + 12, x + 12, y + 12);
            g.setColor(saved);
        }
    }

    public static class TreeControlIcon
    implements Icon,
    Serializable {
        protected boolean isLight;
        private boolean collapsed;

        public TreeControlIcon(boolean isCollapsed) {
            this.collapsed = isCollapsed;
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color dark = new Color(99, 130, 191);
            Color light = new Color(163, 184, 204);
            Color white = Color.white;
            g.setColor(light);
            g.drawOval(x += 8, y += 6, 6, 6);
            g.setColor(dark);
            g.fillOval(x + 1, y + 1, 5, 5);
            if (this.collapsed) {
                g.fillRect(x + 6, y + 1 + 1, 6, 2);
            } else {
                g.fillRect(x + 1 + 1, y + 6, 2, 6);
            }
            g.setColor(white);
            g.fillRect(x + 1 + 1, y + 1 + 1, 2, 2);
        }

        public void paintMe(Component c, Graphics g, int x, int y) {
            this.paintIcon(c, g, x, y);
        }
    }

    private static class TreeFloppyDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color saved = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 1, y + 1, x + 13, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + 14);
            g.drawLine(x + 1, y + 14, x + 14, y + 14);
            g.drawLine(x + 14, y + 2, x + 14, y + 14);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 2, y + 2, 12, 12);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.fillRect(x + 5, y + 2, 6, 5);
            g.drawLine(x + 4, y + 8, x + 11, y + 8);
            g.drawLine(x + 3, y + 9, x + 3, y + 13);
            g.drawLine(x + 12, y + 9, x + 12, y + 13);
            g.setColor(MetalLookAndFeel.getWhite());
            g.fillRect(x + 8, y + 3, 2, 3);
            g.fillRect(x + 4, y + 9, 8, 5);
            g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            g.drawLine(x + 5, y + 10, x + 9, y + 10);
            g.drawLine(x + 5, y + 12, x + 8, y + 12);
            g.setColor(saved);
        }
    }

    public static class TreeFolderIcon
    extends FolderIcon16 {
        public int getAdditionalHeight() {
            return 2;
        }

        public int getShift() {
            return -1;
        }
    }

    private static class TreeHardDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color saved = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 1, y + 4, x + 1, y + 5);
            g.drawLine(x + 14, y + 4, x + 14, y + 5);
            g.drawLine(x + 1, y + 7, x + 1, y + 8);
            g.drawLine(x + 14, y + 7, x + 14, y + 8);
            g.drawLine(x + 1, y + 10, x + 1, y + 11);
            g.drawLine(x + 14, y + 10, x + 14, y + 11);
            g.drawLine(x + 2, y + 3, x + 3, y + 3);
            g.drawLine(x + 12, y + 3, x + 13, y + 3);
            g.drawLine(x + 2, y + 6, x + 3, y + 6);
            g.drawLine(x + 12, y + 6, x + 13, y + 6);
            g.drawLine(x + 2, y + 9, x + 3, y + 9);
            g.drawLine(x + 12, y + 9, x + 13, y + 9);
            g.drawLine(x + 2, y + 12, x + 3, y + 12);
            g.drawLine(x + 12, y + 12, x + 13, y + 12);
            g.drawLine(x + 4, y + 2, x + 11, y + 2);
            g.drawLine(x + 4, y + 7, x + 11, y + 7);
            g.drawLine(x + 4, y + 10, x + 11, y + 10);
            g.drawLine(x + 4, y + 13, x + 11, y + 13);
            g.setColor(MetalLookAndFeel.getWhite());
            g.fillRect(x + 4, y + 3, 2, 2);
            g.drawLine(x + 6, y + 4, x + 6, y + 4);
            g.drawLine(x + 7, y + 3, x + 9, y + 3);
            g.drawLine(x + 8, y + 4, x + 8, y + 4);
            g.drawLine(x + 11, y + 3, x + 11, y + 3);
            g.fillRect(x + 2, y + 4, 2, 2);
            g.fillRect(x + 2, y + 7, 2, 2);
            g.fillRect(x + 2, y + 10, 2, 2);
            g.drawLine(x + 4, y + 6, x + 4, y + 6);
            g.drawLine(x + 4, y + 9, x + 4, y + 9);
            g.drawLine(x + 4, y + 12, x + 4, y + 12);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(x + 13, y + 4, x + 13, y + 4);
            g.drawLine(x + 12, y + 5, x + 13, y + 5);
            g.drawLine(x + 13, y + 7, x + 13, y + 7);
            g.drawLine(x + 12, y + 8, x + 13, y + 8);
            g.drawLine(x + 13, y + 10, x + 13, y + 10);
            g.drawLine(x + 12, y + 11, x + 13, y + 11);
            g.drawLine(x + 10, y + 5, x + 10, y + 5);
            g.drawLine(x + 7, y + 6, x + 7, y + 6);
            g.drawLine(x + 9, y + 6, x + 9, y + 6);
            g.drawLine(x + 11, y + 6, x + 11, y + 6);
            g.drawLine(x + 10, y + 8, x + 10, y + 8);
            g.drawLine(x + 7, y + 9, x + 7, y + 9);
            g.drawLine(x + 9, y + 9, x + 9, y + 9);
            g.drawLine(x + 11, y + 9, x + 11, y + 9);
            g.drawLine(x + 10, y + 11, x + 10, y + 11);
            g.drawLine(x + 7, y + 12, x + 7, y + 12);
            g.drawLine(x + 9, y + 12, x + 9, y + 12);
            g.drawLine(x + 11, y + 12, x + 11, y + 12);
            g.setColor(saved);
        }
    }

    public static class TreeLeafIcon
    extends FileIcon16 {
        public int getAdditionalHeight() {
            return 4;
        }

        public int getShift() {
            return 2;
        }
    }

    private static class VerticalSliderThumbIcon
    implements Icon,
    UIResource,
    Serializable {
        int[][] gradientMask;

        public VerticalSliderThumbIcon() {
            int[][] nArrayArray = new int[13][];
            int[] nArray = new int[2];
            nArray[1] = 12;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[2];
            nArray2[1] = 12;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[2];
            nArray3[1] = 12;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[2];
            nArray4[1] = 12;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[2];
            nArray5[1] = 12;
            nArrayArray[4] = nArray5;
            int[] nArray6 = new int[2];
            nArray6[1] = 12;
            nArrayArray[5] = nArray6;
            int[] nArray7 = new int[2];
            nArray7[1] = 12;
            nArrayArray[6] = nArray7;
            nArrayArray[7] = new int[]{1, 11};
            nArrayArray[8] = new int[]{2, 10};
            nArrayArray[9] = new int[]{3, 9};
            nArrayArray[10] = new int[]{4, 8};
            nArrayArray[11] = new int[]{5, 7};
            nArrayArray[12] = new int[]{6, 6};
            this.gradientMask = nArrayArray;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean enabled = false;
            boolean focus = false;
            if (c != null) {
                enabled = c.isEnabled();
                focus = c.hasFocus();
            }
            if (enabled) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(x + 1, y, x + 7, y);
            g.drawLine(x + 8, y, x + 15, y + 7);
            g.drawLine(x + 14, y + 8, x + 8, y + 14);
            g.drawLine(x + 8, y + 14, x + 1, y + 14);
            g.drawLine(x, y + 13, x, y + 1);
            if (focus) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControl());
            }
            g.fillRect(x + 2, y + 1, 7, 13);
            g.drawLine(x + 9, y + 2, x + 9, y + 12);
            g.drawLine(x + 10, y + 3, x + 10, y + 11);
            g.drawLine(x + 11, y + 4, x + 11, y + 10);
            g.drawLine(x + 12, y + 5, x + 12, y + 9);
            g.drawLine(x + 13, y + 6, x + 13, y + 8);
            g.drawLine(x + 14, y + 7, x + 14, y + 7);
            if (enabled && !(MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme)) {
                if (focus) {
                    g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    g.setColor(MetalLookAndFeel.getBlack());
                }
                g.drawLine(x + 3, y + 3, x + 3, y + 3);
                g.drawLine(x + 3, y + 7, x + 3, y + 7);
                g.drawLine(x + 3, y + 11, x + 3, y + 11);
                g.drawLine(x + 5, y + 5, x + 5, y + 5);
                g.drawLine(x + 5, y + 9, x + 5, y + 9);
                g.drawLine(x + 7, y + 3, x + 7, y + 3);
                g.drawLine(x + 7, y + 7, x + 7, y + 7);
                g.drawLine(x + 7, y + 11, x + 7, y + 11);
                if (focus) {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    g.setColor(MetalLookAndFeel.getWhite());
                }
                g.drawLine(x + 1, y + 1, x + 8, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 13);
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                g.drawLine(x + 2, y + 6, x + 2, y + 6);
                g.drawLine(x + 2, y + 10, x + 2, y + 10);
                g.drawLine(x + 4, y + 4, x + 4, y + 4);
                g.drawLine(x + 4, y + 8, x + 4, y + 8);
                g.drawLine(x + 6, y + 2, x + 6, y + 2);
                g.drawLine(x + 6, y + 6, x + 6, y + 6);
                g.drawLine(x + 6, y + 10, x + 6, y + 10);
            }
        }
    }
}

