/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Type;
import gnu.classpath.tools.gjdoc.AbstractTagImpl;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.MemberDocImpl;
import gnu.classpath.tools.gjdoc.ParseException;
import gnu.classpath.tools.gjdoc.Parser;

public class SerialFieldTagImpl
extends AbstractTagImpl
implements SerialFieldTag {
    private String fieldName;
    private String fieldType;
    private String description;
    private ClassDoc fieldTypeDoc;
    private ClassDocImpl contextClass;

    public SerialFieldTagImpl(String text, ClassDocImpl contextClass, MemberDocImpl contextMember) {
        super(text);
        this.contextClass = contextClass;
        if (this.fieldName == null) {
            this.fieldName = "";
        }
        if (this.fieldType == null) {
            this.fieldType = "";
        }
        if (this.description == null) {
            this.description = "";
        }
        int state = 1;
        char[] textArr = text.toCharArray();
        int i = 0;
        while (i < textArr.length) {
            char c = textArr[i];
            switch (state) {
                case 1: {
                    if (Parser.isWhitespace(c)) {
                        state = 2;
                        break;
                    }
                    this.fieldName = String.valueOf(this.fieldName) + c;
                    break;
                }
                case 2: {
                    if (Parser.isWhitespace(c)) {
                        state = 3;
                        break;
                    }
                    this.fieldType = String.valueOf(this.fieldType) + c;
                    break;
                }
                case 3: {
                    this.description = String.valueOf(this.description) + c;
                }
            }
            ++i;
        }
        this.setBody(this.description, contextClass, contextMember);
    }

    public void resolve() {
        super.resolve();
        try {
            Type type = this.contextClass.typeForString(this.fieldType);
            this.fieldTypeDoc = type.asClassDoc();
        }
        catch (ParseException e) {
            System.err.println("FIXME: add try-catch to force compilation" + e);
        }
    }

    public ClassDoc fieldTypeDoc() {
        return this.fieldTypeDoc;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String fieldType() {
        return this.fieldType;
    }

    public String description() {
        return this.description;
    }

    public String kind() {
        return "@serialField";
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof SerialFieldTagImpl) {
            return this.fieldName().compareTo(((SerialFieldTagImpl)o).fieldName());
        }
        return 0;
    }
}

