/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.Keywords;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import org.objectweb.asm.Type;

public class CniPrintStream
extends PrintStream {
    int currentModifiers = 2;
    boolean sawArray;
    HashSet allClasses = new HashSet();
    String[] previousPackage = new String[0];

    public CniPrintStream(OutputStream out) {
        super(out);
    }

    public void addClass(ClassWrapper cw) {
        this.allClasses.add(cw.name);
    }

    public void setModifiers(int newMods) {
        if ((newMods &= 7) != this.currentModifiers) {
            switch (newMods) {
                case 1: {
                    this.println("public:");
                    break;
                }
                case 4: {
                    this.println("public: // actually protected");
                    break;
                }
                case 2: {
                    this.println("private:");
                    break;
                }
                default: {
                    this.println("public: // actually package-private");
                }
            }
            this.currentModifiers = newMods;
        }
    }

    private String getName(Type type) {
        if (type == Type.BOOLEAN_TYPE) {
            return "jboolean";
        }
        if (type == Type.BYTE_TYPE) {
            return "jbyte";
        }
        if (type == Type.CHAR_TYPE) {
            return "jchar";
        }
        if (type == Type.SHORT_TYPE) {
            return "jshort";
        }
        if (type == Type.INT_TYPE) {
            return "jint";
        }
        if (type == Type.LONG_TYPE) {
            return "jlong";
        }
        if (type == Type.FLOAT_TYPE) {
            return "jfloat";
        }
        if (type == Type.DOUBLE_TYPE) {
            return "jdouble";
        }
        assert (type == Type.VOID_TYPE);
        return "void";
    }

    public String getClassName(Type type) {
        String name = type.toString();
        name = name.substring(1, name.length() - 1);
        this.allClasses.add(name);
        return name;
    }

    public void print(Type type) {
        int arrayCount = 0;
        if (type.getSort() == 9) {
            arrayCount = type.getDimensions();
            int i = 0;
            while (i < arrayCount) {
                this.print("JArray< ");
                ++i;
            }
            type = type.getElementType();
            this.sawArray = true;
        }
        if (type.getSort() == 10) {
            this.print("::");
            this.printName(this.getClassName(type));
            this.print(" *");
        } else {
            this.print(this.getName(type));
        }
        if (arrayCount > 0) {
            while (arrayCount-- > 0) {
                this.print(" > *");
            }
        }
    }

    public static final void printName(PrintStream out, String name) {
        String[] parts = name.split("::|/");
        int i = 0;
        while (i < parts.length) {
            if (i != 0) {
                out.print("::");
            }
            out.print(Keywords.getCxxName(parts[i]));
            ++i;
        }
    }

    public static final void printlnName(PrintStream out, String name) {
        CniPrintStream.printName(out, name);
        out.println();
    }

    final void printName(String name) {
        CniPrintStream.printName(this, name);
    }

    private void indent(PrintStream out, int n) {
        int i = 0;
        while (i < n) {
            out.print("  ");
            ++i;
        }
    }

    private void moveToPackage(PrintStream out, String[] pkgParts) {
        int commonIndex = 0;
        while (commonIndex < this.previousPackage.length) {
            if (commonIndex >= pkgParts.length || !this.previousPackage[commonIndex].equals(pkgParts[commonIndex])) break;
            ++commonIndex;
        }
        int j = this.previousPackage.length - 1;
        while (j >= commonIndex) {
            this.indent(out, j + 1);
            out.println("}");
            --j;
        }
        j = commonIndex;
        while (j < pkgParts.length) {
            this.indent(out, j + 1);
            out.print("namespace ");
            CniPrintStream.printlnName(out, pkgParts[j]);
            this.indent(out, j + 1);
            out.println("{");
            ++j;
        }
        this.previousPackage = pkgParts;
    }

    private void writeClass(PrintStream out, String klass) {
        int index = klass.lastIndexOf(47);
        String pkg = index == -1 ? "" : klass.substring(0, index);
        String[] pkgParts = index == -1 ? new String[]{} : pkg.split("/");
        String className = index == -1 ? klass : klass.substring(index + 1);
        this.moveToPackage(out, pkgParts);
        this.indent(out, pkgParts.length + 2);
        out.print("class ");
        CniPrintStream.printName(out, className);
        out.println(";");
    }

    public void printNamespaces(PrintStream out) {
        if (this.sawArray) {
            out.println("#include <gcj/array.h>");
            out.println();
        }
        Object[] classes = this.allClasses.toArray(new String[0]);
        Arrays.sort(classes);
        boolean first = true;
        boolean seen = false;
        int i = 0;
        while (i < classes.length) {
            Object klass = classes[i];
            if (!(((String)klass).startsWith("java/lang/") || ((String)klass).startsWith("java/io/") || ((String)klass).startsWith("java/util/"))) {
                if (first) {
                    out.println("extern \"Java\"");
                    out.println("{");
                    first = false;
                    seen = true;
                }
                this.writeClass(out, (String)klass);
            }
            ++i;
        }
        if (seen) {
            this.moveToPackage(out, new String[0]);
            out.println("}");
        }
    }
}

