/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmic;

import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.rmic.ClassRmicCompiler;
import gnu.classpath.tools.rmic.Messages;
import gnu.classpath.tools.rmic.RmicBackend;
import gnu.classpath.tools.rmic.SourceGiopRmicCompiler;
import gnu.classpath.tools.rmic.SourceRmicCompiler;
import java.util.ArrayList;

public class Main {
    private boolean noWrite;
    private boolean warnings = true;
    private boolean verbose;
    private boolean force;
    private String classpath = ".";
    private String outputDirectory = ".";
    private boolean poa;
    private boolean need11Stubs = false;
    private boolean need12Stubs = true;
    private boolean keep;
    private boolean iiop;
    private boolean jrmp;

    private Parser initializeParser() {
        ClasspathToolParser parser = new ClasspathToolParser("rmic", true);
        parser.setHeader(Messages.getString("Main.Usage"));
        parser.add(new Option("nowarn", Messages.getString("Main.NoWarn")){

            public void parsed(String argument) throws OptionException {
                Main.this.warnings = false;
            }
        });
        parser.add(new Option("nowrite", Messages.getString("Main.NoWrite")){

            public void parsed(String argument) throws OptionException {
                Main.this.noWrite = true;
            }
        });
        parser.add(new Option("verbose", Messages.getString("Main.Verbose")){

            public void parsed(String argument) throws OptionException {
                Main.this.verbose = true;
            }
        });
        parser.add(new Option("d", Messages.getString("Main.DirOpt"), Messages.getString("Main.DirArg")){

            public void parsed(String argument) throws OptionException {
                Main.this.outputDirectory = argument;
            }
        });
        parser.add(new Option("classpath", Messages.getString("Main.ClasspathOpt"), Messages.getString("Main.ClasspathArg")){

            public void parsed(String argument) throws OptionException {
                Main.this.classpath = argument;
            }
        });
        parser.add(new Option("bootclasspath", Messages.getString("Main.BootclasspathOpt"), Messages.getString("Main.BootclasspathArg")){

            public void parsed(String argument) throws OptionException {
            }
        });
        parser.add(new Option("extdirs", Messages.getString("Main.ExtdirsOpt"), Messages.getString("Main.ExtdirsArg")){

            public void parsed(String argument) throws OptionException {
            }
        });
        parser.add(new Option("iiop", Messages.getString("Main.IIOP")){

            public void parsed(String argument) throws OptionException {
                Main.this.iiop = true;
            }
        });
        parser.add(new Option("always", Messages.getString("Main.Always")){

            public void parsed(String argument) throws OptionException {
                Main.this.force = true;
            }
        });
        parser.add(new Option("alwaysgenerate", Messages.getString("Main.AlwaysGenerate")){

            public void parsed(String argument) throws OptionException {
                Main.this.force = true;
            }
        });
        parser.add(new Option("nolocalstubs", Messages.getString("Main.NoLocalStubs")){

            public void parsed(String argument) throws OptionException {
            }
        });
        parser.add(new Option("poa", Messages.getString("Main.POA")){

            public void parsed(String argument) throws OptionException {
                Main.this.poa = true;
            }
        });
        parser.add(new Option("keep", Messages.getString("Main.Keep")){

            public void parsed(String argument) throws OptionException {
                Main.this.keep = true;
            }
        });
        parser.add(new Option("keepgenerated", Messages.getString("Main.KeepGenerated")){

            public void parsed(String argument) throws OptionException {
                Main.this.keep = true;
            }
        });
        parser.add(new Option("v1.1", Messages.getString("Main.v11")){

            public void parsed(String argument) throws OptionException {
                Main.this.need11Stubs = true;
                Main.this.need12Stubs = false;
                Main.this.jrmp = true;
            }
        });
        parser.add(new Option("v1.2", Messages.getString("Main.v12")){

            public void parsed(String argument) throws OptionException {
                Main.this.jrmp = true;
            }
        });
        parser.add(new Option("vcompat", Messages.getString("Main.vcompat")){

            public void parsed(String argument) throws OptionException {
                Main.this.need11Stubs = true;
                Main.this.need12Stubs = true;
                Main.this.jrmp = true;
            }
        });
        parser.add(new Option("g", Messages.getString("Main.DebugInfo")){

            public void parsed(String argument) throws OptionException {
            }
        });
        return parser;
    }

    private void run(String[] args) {
        Parser p = this.initializeParser();
        String[] files = p.parse(args);
        if (files.length == 0) {
            p.printHelp();
            System.exit(1);
        }
        ArrayList<RmicBackend> backends = new ArrayList<RmicBackend>();
        if (this.iiop) {
            backends.add(new SourceGiopRmicCompiler());
            if (this.jrmp) {
                backends.add(new ClassRmicCompiler());
                if (this.keep) {
                    backends.add(new SourceRmicCompiler());
                }
            }
        } else {
            backends.add(new ClassRmicCompiler());
            if (this.keep) {
                backends.add(new SourceRmicCompiler());
            }
        }
        int i = 0;
        while (i < backends.size()) {
            RmicBackend b = (RmicBackend)backends.get(i);
            b.setup(this.keep, this.need11Stubs, this.need12Stubs, this.iiop, this.poa, false, this.warnings, this.noWrite, this.verbose, this.force, this.classpath, null, null, this.outputDirectory);
            if (!b.run(files)) {
                System.exit(1);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        Main rmicprogram = new Main();
        try {
            rmicprogram.run(args);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("Main.InternalError"));
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

