/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public class ArrayReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeLength(bb, os);
                    break;
                }
                case 2: {
                    this.executeGetValues(bb, os);
                    break;
                }
                case 3: {
                    this.executeSetValues(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in Array Reference Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private void executeLength(ByteBuffer bb, DataOutputStream os) throws InvalidObjectException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Object array = oid.getObject();
        os.writeInt(Array.getLength(array));
    }

    private void executeGetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Object array = oid.getObject();
        int first = bb.getInt();
        int length = bb.getInt();
        Class<?> clazz = array.getClass().getComponentType();
        if (clazz == Byte.TYPE) {
            os.writeByte(66);
        } else if (clazz == Character.TYPE) {
            os.writeByte(67);
        } else if (clazz == Float.TYPE) {
            os.writeByte(70);
        } else if (clazz == Double.TYPE) {
            os.writeByte(68);
        } else if (clazz == Integer.TYPE) {
            os.writeByte(66);
        } else if (clazz == Long.TYPE) {
            os.writeByte(74);
        } else if (clazz == Short.TYPE) {
            os.writeByte(83);
        } else if (clazz == Void.TYPE) {
            os.writeByte(86);
        } else if (clazz == Boolean.TYPE) {
            os.writeByte(90);
        } else if (clazz.isArray()) {
            os.writeByte(91);
        } else if (String.class.isAssignableFrom(clazz)) {
            os.writeByte(115);
        } else if (Thread.class.isAssignableFrom(clazz)) {
            os.writeByte(116);
        } else if (ThreadGroup.class.isAssignableFrom(clazz)) {
            os.writeByte(103);
        } else if (ClassLoader.class.isAssignableFrom(clazz)) {
            os.writeByte(108);
        } else if (Class.class.isAssignableFrom(clazz)) {
            os.writeByte(99);
        } else {
            os.writeByte(76);
        }
        int i = first;
        while (i < first + length) {
            Value val = ValueFactory.createFromObject(Array.get(array, i), clazz);
            if (clazz.isPrimitive()) {
                val.writeUntagged(os);
            } else {
                val.writeTagged(os);
            }
            ++i;
        }
    }

    private void executeSetValues(ByteBuffer bb, DataOutputStream os) throws IOException, JdwpException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Object array = oid.getObject();
        int first = bb.getInt();
        int length = bb.getInt();
        Class<?> type = array.getClass().getComponentType();
        int i = first;
        while (i < first + length) {
            Object value = Value.getUntaggedObject(bb, type);
            Array.set(array, i, value);
            ++i;
        }
    }
}

