/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.lang.CPStringBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Locale;

public class DecimalFormat
extends NumberFormat {
    private static final long serialVersionUID = 864413376551465018L;
    private static final int DEFAULT_INTEGER_DIGITS = 309;
    private static final int DEFAULT_FRACTION_DIGITS = 340;
    private static final DecimalFormatSymbols nonLocalizedSymbols = new DecimalFormatSymbols(Locale.US);
    private boolean parseBigDecimal;
    private boolean useCurrencySeparator;
    private boolean decimalSeparatorAlwaysShown;
    private boolean showDecimalSeparator;
    private boolean groupingSeparatorInPattern;
    private byte groupingSize;
    private byte minExponentDigits;
    private int exponentRound;
    private int multiplier;
    private int negativePatternMultiplier;
    private String negativePrefix;
    private String negativeSuffix;
    private String positivePrefix;
    private String positiveSuffix;
    private DecimalFormatSymbols symbols;
    private boolean useExponentialNotation;
    private int maxIntegerDigitsExponent;
    private boolean hasNegativePrefix;
    private boolean hasFractionalPattern;
    private ArrayList<FieldPosition> attributes = new ArrayList();

    public DecimalFormat() {
        this("#,##0.###");
    }

    public DecimalFormat(String pattern2) {
        this(pattern2, new DecimalFormatSymbols());
    }

    public DecimalFormat(String pattern2, DecimalFormatSymbols symbols) {
        this.symbols = (DecimalFormatSymbols)symbols.clone();
        this.applyPatternWithSymbols(pattern2, nonLocalizedSymbols);
    }

    public void applyLocalizedPattern(String pattern2) {
        this.applyPatternWithSymbols(pattern2, this.symbols);
    }

    public void applyPattern(String pattern2) {
        this.applyPatternWithSymbols(pattern2, nonLocalizedSymbols);
    }

    public Object clone() {
        DecimalFormat c = (DecimalFormat)super.clone();
        c.symbols = (DecimalFormatSymbols)this.symbols.clone();
        return c;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat dup = (DecimalFormat)obj;
        return this.decimalSeparatorAlwaysShown == dup.decimalSeparatorAlwaysShown && this.groupingUsed == dup.groupingUsed && this.groupingSeparatorInPattern == dup.groupingSeparatorInPattern && this.groupingSize == dup.groupingSize && this.multiplier == dup.multiplier && this.useExponentialNotation == dup.useExponentialNotation && this.minExponentDigits == dup.minExponentDigits && this.minimumIntegerDigits == dup.minimumIntegerDigits && this.maximumIntegerDigits == dup.maximumIntegerDigits && this.minimumFractionDigits == dup.minimumFractionDigits && this.maximumFractionDigits == dup.maximumFractionDigits && this.parseBigDecimal == dup.parseBigDecimal && this.useCurrencySeparator == dup.useCurrencySeparator && this.showDecimalSeparator == dup.showDecimalSeparator && this.exponentRound == dup.exponentRound && this.negativePatternMultiplier == dup.negativePatternMultiplier && this.maxIntegerDigitsExponent == dup.maxIntegerDigitsExponent && this.equals(this.negativePrefix, dup.negativePrefix) && this.equals(this.negativeSuffix, dup.negativeSuffix) && this.equals(this.positivePrefix, dup.positivePrefix) && this.equals(this.positiveSuffix, dup.positiveSuffix) && this.symbols.equals(dup.symbols);
    }

    public int hashCode() {
        return this.toPattern().hashCode();
    }

    public final StringBuffer format(Object obj, StringBuffer sbuf, FieldPosition pos) {
        if (obj instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)obj);
            this.formatInternal(decimal, true, sbuf, pos);
            return sbuf;
        }
        if (obj instanceof BigDecimal) {
            this.formatInternal((BigDecimal)obj, true, sbuf, pos);
            return sbuf;
        }
        return super.format(obj, sbuf, pos);
    }

    public StringBuffer format(double number, StringBuffer dest, FieldPosition fieldPos) {
        if (Double.isNaN(number)) {
            String nan = this.symbols.getNaN();
            dest.append(nan);
            if (fieldPos.getField() == 0 || fieldPos.getFieldAttribute() == NumberFormat.Field.INTEGER) {
                int index = dest.length();
                fieldPos.setBeginIndex(index - nan.length());
                fieldPos.setEndIndex(index);
            }
        } else if (Double.isInfinite(number)) {
            if (number < 0.0) {
                dest.append(this.negativePrefix);
            } else {
                dest.append(this.positivePrefix);
            }
            dest.append(this.symbols.getInfinity());
            if (number < 0.0) {
                dest.append(this.negativeSuffix);
            } else {
                dest.append(this.positiveSuffix);
            }
            if (fieldPos.getField() == 0 || fieldPos.getFieldAttribute() == NumberFormat.Field.INTEGER) {
                fieldPos.setBeginIndex(dest.length());
                fieldPos.setEndIndex(0);
            }
        } else {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(number));
            this.formatInternal(bigDecimal, false, dest, fieldPos);
        }
        return dest;
    }

    public StringBuffer format(long number, StringBuffer dest, FieldPosition fieldPos) {
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(number));
        this.formatInternal(bigDecimal, true, dest, fieldPos);
        return dest;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object value) {
        if (value == null) {
            throw new NullPointerException("Passed Object is null");
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Cannot format given Object as a Number");
        }
        StringBuffer text = new StringBuffer();
        this.attributes.clear();
        super.format(value, text, new FieldPosition(0));
        AttributedString as = new AttributedString(text.toString());
        int i = 0;
        while (i < this.attributes.size()) {
            FieldPosition pos = this.attributes.get(i);
            Format.Field attribute = pos.getFieldAttribute();
            as.addAttribute(attribute, attribute, pos.getBeginIndex(), pos.getEndIndex());
            ++i;
        }
        return as.getIterator();
    }

    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return (DecimalFormatSymbols)this.symbols.clone();
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setParseBigDecimal(boolean newValue) {
        this.parseBigDecimal = newValue;
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public Number parse(String str, ParsePosition pos) {
        int i;
        if (str.contains(this.symbols.getNaN())) {
            return Double.NaN;
        }
        CPStringBuilder number = new CPStringBuilder();
        char minus = this.symbols.getMinusSign();
        int start = pos.getIndex();
        String _negativePrefix = this.negativePrefix.compareTo("") == 0 ? String.valueOf(minus) + this.positivePrefix : this.negativePrefix;
        int positiveLen = this.positivePrefix.length();
        int negativeLen = _negativePrefix.length();
        boolean isNegative = str.startsWith(_negativePrefix);
        boolean isPositive = str.startsWith(this.positivePrefix);
        if (isPositive && isNegative) {
            if (negativeLen > positiveLen) {
                start += _negativePrefix.length();
                isNegative = true;
            } else {
                start += this.positivePrefix.length();
                isPositive = true;
                if (negativeLen < positiveLen) {
                    isNegative = false;
                }
            }
        } else if (isNegative) {
            start += _negativePrefix.length();
            isPositive = false;
        } else if (isPositive) {
            start += this.positivePrefix.length();
            isNegative = false;
        } else {
            pos.setErrorIndex(start);
            return null;
        }
        char decimalSeparator = this.symbols.getDecimalSeparator();
        char zero = this.symbols.getZeroDigit();
        char exponent = this.symbols.getExponential();
        int stop = start + this.maximumIntegerDigits + this.maximumFractionDigits + 2;
        if (this.useExponentialNotation) {
            stop += this.minExponentDigits + 1;
        }
        boolean inExponent = false;
        int len = str.length();
        if (len < stop) {
            stop = len;
        }
        char groupingSeparator = this.symbols.getGroupingSeparator();
        for (i = start; i < stop; ++i) {
            char ch = str.charAt(i);
            if (ch >= zero && ch <= zero + 9) {
                number.append(ch);
                continue;
            }
            if (this.parseIntegerOnly) {
                --i;
                break;
            }
            if (ch == decimalSeparator) {
                number.append('.');
                continue;
            }
            if (ch == exponent) {
                number.append(ch);
                inExponent = !inExponent;
                continue;
            }
            if (ch != '+' && ch != '-' && ch != minus) continue;
            if (inExponent) {
                number.append(ch);
                continue;
            }
            --i;
            break;
        }
        if (str.contains(this.symbols.getInfinity())) {
            int inf = str.indexOf(this.symbols.getInfinity());
            pos.setIndex(inf);
            if (this.parseBigDecimal) {
                if (isNegative) {
                    return BigDecimal.valueOf(Double.NEGATIVE_INFINITY);
                }
                return BigDecimal.valueOf(Double.POSITIVE_INFINITY);
            }
            if (isNegative) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (i == start || number.length() == 0) {
            pos.setErrorIndex(i);
            return null;
        }
        boolean hasNegativeSuffix = str.endsWith(this.negativeSuffix);
        boolean hasPositiveSuffix = str.endsWith(this.positiveSuffix);
        boolean positiveEqualsNegative = this.negativeSuffix.equals(this.positiveSuffix);
        positiveLen = this.positiveSuffix.length();
        negativeLen = this.negativeSuffix.length();
        if (isNegative && !hasNegativeSuffix) {
            pos.setErrorIndex(i);
            return null;
        }
        if (hasNegativeSuffix && !positiveEqualsNegative && negativeLen > positiveLen) {
            isNegative = true;
        } else if (!hasPositiveSuffix) {
            pos.setErrorIndex(i);
            return null;
        }
        if (isNegative) {
            number.insert(0, '-');
        }
        pos.setIndex(i);
        BigDecimal bigDecimal = new BigDecimal(number.toString());
        if (this.parseBigDecimal) {
            return bigDecimal;
        }
        if (this.parseIntegerOnly) {
            return bigDecimal.longValue();
        }
        if (isNegative && bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return -0.0;
        }
        try {
            BigDecimal integer = bigDecimal.setScale(0, 7);
            return integer.longValue();
        }
        catch (ArithmeticException arithmeticException) {
            return bigDecimal.doubleValue();
        }
    }

    public void setCurrency(Currency currency) {
        Currency current = this.symbols.getCurrency();
        if (current != currency) {
            int negSuf;
            int posSuf;
            int negPre;
            String oldSymbol = this.symbols.getCurrencySymbol();
            int len = oldSymbol.length();
            this.symbols.setCurrency(currency);
            String newSymbol = this.symbols.getCurrencySymbol();
            int posPre = this.positivePrefix.indexOf(oldSymbol);
            if (posPre != -1) {
                this.positivePrefix = String.valueOf(this.positivePrefix.substring(0, posPre)) + newSymbol + this.positivePrefix.substring(posPre + len);
            }
            if ((negPre = this.negativePrefix.indexOf(oldSymbol)) != -1) {
                this.negativePrefix = String.valueOf(this.negativePrefix.substring(0, negPre)) + newSymbol + this.negativePrefix.substring(negPre + len);
            }
            if ((posSuf = this.positiveSuffix.indexOf(oldSymbol)) != -1) {
                this.positiveSuffix = String.valueOf(this.positiveSuffix.substring(0, posSuf)) + newSymbol + this.positiveSuffix.substring(posSuf + len);
            }
            if ((negSuf = this.negativeSuffix.indexOf(oldSymbol)) != -1) {
                this.negativeSuffix = String.valueOf(this.negativeSuffix.substring(0, negSuf)) + newSymbol + this.negativeSuffix.substring(negSuf + len);
            }
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        this.symbols = (DecimalFormatSymbols)newSymbols.clone();
    }

    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
        this.decimalSeparatorAlwaysShown = newValue;
    }

    public void setGroupingSize(int groupSize) {
        this.groupingSize = (byte)groupSize;
    }

    public void setMaximumIntegerDigits(int newValue) {
        newValue = newValue > 0 ? newValue : 0;
        super.setMaximumIntegerDigits(Math.min(newValue, 309));
    }

    public void setMinimumIntegerDigits(int newValue) {
        newValue = newValue > 0 ? newValue : 0;
        super.setMinimumIntegerDigits(Math.min(newValue, 309));
    }

    public void setMaximumFractionDigits(int newValue) {
        newValue = newValue > 0 ? newValue : 0;
        super.setMaximumFractionDigits(Math.min(newValue, 340));
    }

    public void setMinimumFractionDigits(int newValue) {
        newValue = newValue > 0 ? newValue : 0;
        super.setMinimumFractionDigits(Math.min(newValue, 340));
    }

    public void setMultiplier(int newValue) {
        this.multiplier = newValue;
    }

    public void setNegativePrefix(String newValue) {
        this.negativePrefix = newValue;
    }

    public void setNegativeSuffix(String newValue) {
        this.negativeSuffix = newValue;
    }

    public void setPositivePrefix(String newValue) {
        this.positivePrefix = newValue;
    }

    public void setPositiveSuffix(String newValue) {
        this.positiveSuffix = newValue;
    }

    public String toLocalizedPattern() {
        return this.computePattern(this.symbols);
    }

    public String toPattern() {
        return this.computePattern(nonLocalizedSymbols);
    }

    private boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    private String patternChars(DecimalFormatSymbols syms) {
        CPStringBuilder buf = new CPStringBuilder();
        buf.append(syms.getDecimalSeparator());
        buf.append(syms.getDigit());
        buf.append(syms.getExponential());
        buf.append(syms.getGroupingSeparator());
        buf.append(syms.getMinusSign());
        buf.append(syms.getPatternSeparator());
        buf.append(syms.getPercent());
        buf.append(syms.getPerMill());
        buf.append(syms.getZeroDigit());
        buf.append('\'');
        buf.append('\u00a4');
        return buf.toString();
    }

    private CPStringBuilder quoteFix(String text, String patChars) {
        CPStringBuilder buf = new CPStringBuilder();
        int len = text.length();
        int index = 0;
        while (index < len) {
            char ch = text.charAt(index);
            if (patChars.indexOf(ch) != -1) {
                buf.append('\'');
                buf.append(ch);
                if (ch != '\'') {
                    buf.append('\'');
                }
            } else {
                buf.append(ch);
            }
            ++index;
        }
        return buf;
    }

    private String computePattern(DecimalFormatSymbols symbols) {
        StringBuilder mainPattern = new StringBuilder();
        int _groupingSize = this.groupingUsed ? this.groupingSize + 1 : this.groupingSize;
        int totalDigits = Math.max(this.minimumIntegerDigits, _groupingSize);
        if (!this.useExponentialNotation) {
            mainPattern.append(symbols.getDigit());
        }
        int i = 1;
        while (i < totalDigits - this.minimumIntegerDigits) {
            mainPattern.append(symbols.getDigit());
            ++i;
        }
        i = totalDigits - this.minimumIntegerDigits;
        while (i < totalDigits) {
            mainPattern.append(symbols.getZeroDigit());
            ++i;
        }
        if (this.groupingUsed) {
            mainPattern.insert(mainPattern.length() - this.groupingSize, symbols.getGroupingSeparator());
        }
        if (this.minimumFractionDigits > 0 || this.maximumFractionDigits > 0 || this.decimalSeparatorAlwaysShown) {
            mainPattern.append(symbols.getDecimalSeparator());
        }
        i = 0;
        while (i < this.minimumFractionDigits) {
            mainPattern.append(symbols.getZeroDigit());
            ++i;
        }
        i = this.minimumFractionDigits;
        while (i < this.maximumFractionDigits) {
            mainPattern.append(symbols.getDigit());
            ++i;
        }
        if (this.useExponentialNotation) {
            mainPattern.append(symbols.getExponential());
            i = 0;
            while (i < this.minExponentDigits) {
                mainPattern.append(symbols.getZeroDigit());
                ++i;
            }
            if (this.minExponentDigits == 0) {
                mainPattern.append(symbols.getDigit());
            }
        }
        String pattern2 = mainPattern.toString();
        String patternChars = this.patternChars(symbols);
        mainPattern.insert(0, this.quoteFix(this.positivePrefix, patternChars));
        mainPattern.append(this.quoteFix(this.positiveSuffix, patternChars));
        if (this.hasNegativePrefix) {
            mainPattern.append(symbols.getPatternSeparator());
            mainPattern.append(this.quoteFix(this.negativePrefix, patternChars));
            mainPattern.append(pattern2);
            mainPattern.append(this.quoteFix(this.negativeSuffix, patternChars));
        }
        return mainPattern.toString();
    }

    private void applyPatternWithSymbols(String pattern2, DecimalFormatSymbols symbols) {
        this.setDefaultValues();
        int len = pattern2.length();
        if (len == 0) {
            this.minimumIntegerDigits = 1;
            this.maximumIntegerDigits = 309;
            this.minimumFractionDigits = 0;
            this.maximumFractionDigits = 340;
            this.minExponentDigits = 0;
            this.showDecimalSeparator = true;
            this.groupingUsed = true;
            this.groupingSize = (byte)3;
            return;
        }
        int start = this.scanFix(pattern2, symbols, 0, true);
        if (start < len) {
            start = this.scanNumberInteger(pattern2, symbols, start);
        }
        if (start < len) {
            start = this.scanFractionalPortion(pattern2, symbols, start);
        } else {
            this.minimumFractionDigits = 0;
            this.maximumFractionDigits = 0;
        }
        if (start < len) {
            start = this.scanExponent(pattern2, symbols, start);
        }
        if (start < len) {
            start = this.scanFix(pattern2, symbols, start, false);
        }
        if (start < len) {
            this.scanNegativePattern(pattern2, symbols, start);
        }
        if (this.useExponentialNotation && this.maxIntegerDigitsExponent > this.minimumIntegerDigits && this.maxIntegerDigitsExponent > 1) {
            this.minimumIntegerDigits = 1;
            this.exponentRound = this.maxIntegerDigitsExponent;
        }
        if (this.useExponentialNotation) {
            this.maximumIntegerDigits = this.maxIntegerDigitsExponent;
        }
        if (!this.hasFractionalPattern && this.showDecimalSeparator) {
            this.decimalSeparatorAlwaysShown = true;
        }
    }

    private int scanFix(String pattern2, DecimalFormatSymbols sourceSymbols, int start, boolean prefix) {
        CPStringBuilder buffer = new CPStringBuilder();
        char decimalSeparator = sourceSymbols.getDecimalSeparator();
        char patternSeparator = sourceSymbols.getPatternSeparator();
        char groupingSeparator = sourceSymbols.getGroupingSeparator();
        char digit = sourceSymbols.getDigit();
        char zero = sourceSymbols.getZeroDigit();
        char minus = sourceSymbols.getMinusSign();
        char percent = sourceSymbols.getPercent();
        char permille = sourceSymbols.getPerMill();
        String currencySymbol = this.symbols.getCurrencySymbol();
        boolean quote = false;
        char ch = pattern2.charAt(start);
        if (ch == patternSeparator) {
            this.hasNegativePrefix = true;
            return ++start;
        }
        int len = pattern2.length();
        int i = start;
        while (i < len) {
            ch = pattern2.charAt(i);
            if (!quote && ch == patternSeparator) {
                if (this.hasNegativePrefix) {
                    throw new IllegalArgumentException("Invalid pattern found: " + start);
                }
                this.hasNegativePrefix = true;
                ++i;
                break;
            }
            if (!quote && (ch == minus || ch == digit || ch == zero || ch == groupingSeparator)) break;
            if (!quote && ch == decimalSeparator) {
                this.showDecimalSeparator = true;
                break;
            }
            if (quote && ch != '\'') {
                buffer.append(ch);
            } else if (ch == '\u00a4') {
                currencySymbol = this.symbols.getCurrencySymbol();
                if (i + 1 < len && pattern2.charAt(i + 1) == '\u00a4') {
                    currencySymbol = this.symbols.getInternationalCurrencySymbol();
                    ++i;
                }
                this.useCurrencySeparator = true;
                buffer.append(currencySymbol);
            } else if (ch == percent) {
                this.multiplier = 100;
                buffer.append(this.symbols.getPercent());
            } else if (ch == permille) {
                this.multiplier = 1000;
                buffer.append(this.symbols.getPerMill());
            } else if (ch == '\'') {
                if (i + 1 < len && pattern2.charAt(i + 1) == '\'') {
                    buffer.append(ch);
                    ++i;
                } else {
                    quote = !quote;
                }
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        if (prefix) {
            this.positivePrefix = buffer.toString();
            this.negativePrefix = String.valueOf(minus) + this.positivePrefix;
        } else {
            this.positiveSuffix = buffer.toString();
        }
        return i;
    }

    private int scanNumberInteger(String pattern2, DecimalFormatSymbols symbols, int start) {
        char digit = symbols.getDigit();
        char zero = symbols.getZeroDigit();
        char groupingSeparator = symbols.getGroupingSeparator();
        char decimalSeparator = symbols.getDecimalSeparator();
        char exponent = symbols.getExponential();
        char patternSeparator = symbols.getPatternSeparator();
        int zeros = 0;
        int _groupingSize = 0;
        this.maxIntegerDigitsExponent = 0;
        boolean intPartTouched = false;
        int len = pattern2.length();
        int i = start;
        while (i < len) {
            char ch = pattern2.charAt(i);
            if (ch == decimalSeparator || ch == exponent) break;
            if (this.hasNegativePrefix && ch == patternSeparator) {
                throw new IllegalArgumentException("Invalid pattern found: " + start);
            }
            if (ch == digit) {
                if (zeros > 0) {
                    throw new IllegalArgumentException("digit mark following zero in positive subpattern, not allowed. Position: " + i);
                }
                ++_groupingSize;
                intPartTouched = true;
                ++this.maxIntegerDigitsExponent;
            } else if (ch == zero) {
                ++zeros;
                ++_groupingSize;
                ++this.maxIntegerDigitsExponent;
            } else {
                if (ch != groupingSeparator) break;
                this.groupingSeparatorInPattern = true;
                this.groupingUsed = true;
                _groupingSize = 0;
            }
            ++i;
        }
        if (this.groupingSeparatorInPattern) {
            this.groupingSize = (byte)_groupingSize;
        }
        this.minimumIntegerDigits = zeros;
        if (intPartTouched && this.maximumIntegerDigits > 0 && this.minimumIntegerDigits == 0) {
            this.minimumIntegerDigits = 1;
        }
        return i;
    }

    private int scanFractionalPortion(String pattern2, DecimalFormatSymbols symbols, int start) {
        char digit = symbols.getDigit();
        char zero = symbols.getZeroDigit();
        char groupingSeparator = symbols.getGroupingSeparator();
        char decimalSeparator = symbols.getDecimalSeparator();
        char exponent = symbols.getExponential();
        char patternSeparator = symbols.getPatternSeparator();
        char ch = pattern2.charAt(start);
        if (ch != decimalSeparator) {
            this.minimumFractionDigits = 0;
            this.maximumFractionDigits = 0;
            return start;
        }
        this.hasFractionalPattern = true;
        this.minimumFractionDigits = 0;
        int digits = 0;
        int len = pattern2.length();
        int i = ++start;
        while (i < len) {
            ch = pattern2.charAt(i);
            if (ch == exponent || ch == patternSeparator) break;
            if (ch == groupingSeparator || ch == decimalSeparator) {
                throw new IllegalArgumentException("unexpected character '" + ch + "' " + "in fractional subpattern. Position: " + i);
            }
            if (ch == digit) {
                ++digits;
            } else {
                if (ch != zero) break;
                if (digits > 0) {
                    throw new IllegalArgumentException("digit mark following zero in positive subpattern, not allowed. Position: " + i);
                }
                ++this.minimumFractionDigits;
            }
            ++i;
        }
        if (i == start) {
            this.hasFractionalPattern = false;
        }
        this.maximumFractionDigits = this.minimumFractionDigits + digits;
        this.showDecimalSeparator = true;
        return i;
    }

    private int scanExponent(String pattern2, DecimalFormatSymbols symbols, int start) {
        char digit = symbols.getDigit();
        char zero = symbols.getZeroDigit();
        char groupingSeparator = symbols.getGroupingSeparator();
        char decimalSeparator = symbols.getDecimalSeparator();
        char exponent = symbols.getExponential();
        char ch = pattern2.charAt(start);
        if (ch == decimalSeparator) {
            ++start;
        }
        if (ch != exponent) {
            this.useExponentialNotation = false;
            return start;
        }
        this.minExponentDigits = 0;
        int len = pattern2.length();
        int i = ++start;
        while (i < len) {
            ch = pattern2.charAt(i);
            if (ch == groupingSeparator || ch == decimalSeparator || ch == digit || ch == exponent) {
                throw new IllegalArgumentException("unexpected character '" + ch + "' " + "in exponential subpattern. Position: " + i);
            }
            if (ch != zero) break;
            this.minExponentDigits = (byte)(this.minExponentDigits + 1);
            ++i;
        }
        this.useExponentialNotation = true;
        return i;
    }

    private void scanNegativePattern(String pattern2, DecimalFormatSymbols sourceSymbols, int start) {
        char ch;
        String CURRENCY_SYMBOL;
        StringBuilder buffer = new StringBuilder();
        char decimalSeparator = sourceSymbols.getDecimalSeparator();
        char patternSeparator = sourceSymbols.getPatternSeparator();
        char groupingSeparator = sourceSymbols.getGroupingSeparator();
        char digit = sourceSymbols.getDigit();
        char zero = sourceSymbols.getZeroDigit();
        char minus = sourceSymbols.getMinusSign();
        char percent = sourceSymbols.getPercent();
        char permille = sourceSymbols.getPerMill();
        String currencySymbol = CURRENCY_SYMBOL = this.symbols.getCurrencySymbol();
        boolean quote = false;
        boolean prefixDone = false;
        int len = pattern2.length();
        if (len > 0) {
            this.hasNegativePrefix = true;
        }
        if ((ch = pattern2.charAt(start)) == patternSeparator) {
            if (start + 1 > len) {
                throw new IllegalArgumentException("unexpected character '" + ch + "' " + "in negative subpattern.");
            }
            ++start;
        }
        int i = start;
        while (i < len) {
            ch = pattern2.charAt(i);
            if (!(quote || ch != digit && ch != zero && ch != decimalSeparator && ch != patternSeparator && ch != groupingSeparator)) {
                if (!prefixDone) {
                    this.negativePrefix = buffer.toString();
                    buffer.delete(0, buffer.length());
                    prefixDone = true;
                }
            } else if (ch == minus) {
                buffer.append(this.symbols.getMinusSign());
            } else if (quote && ch != '\'') {
                buffer.append(ch);
            } else if (ch == '\u00a4') {
                currencySymbol = CURRENCY_SYMBOL;
                if (i + 1 < len && pattern2.charAt(i + 1) == '\u00a4') {
                    currencySymbol = this.symbols.getInternationalCurrencySymbol();
                    i += 2;
                }
                buffer.append(currencySymbol);
            } else if (ch == percent) {
                this.negativePatternMultiplier = 100;
                buffer.append(this.symbols.getPercent());
            } else if (ch == permille) {
                this.negativePatternMultiplier = 1000;
                buffer.append(this.symbols.getPerMill());
            } else if (ch == '\'') {
                if (i + 1 < len && pattern2.charAt(i + 1) == '\'') {
                    buffer.append(ch);
                    ++i;
                } else {
                    quote = !quote;
                }
            } else {
                if (ch == patternSeparator) {
                    throw new IllegalArgumentException("unexpected character '" + ch + "' in negative subpattern.");
                }
                buffer.append(ch);
            }
            ++i;
        }
        if (prefixDone) {
            this.negativeSuffix = buffer.toString();
        } else {
            this.negativePrefix = buffer.toString();
        }
    }

    private void formatInternal(BigDecimal number, boolean isLong, StringBuffer dest, FieldPosition fieldPos) {
        int intPartLen;
        int dot;
        boolean isNegative;
        if (fieldPos == null) {
            fieldPos = new FieldPosition(0);
        }
        int _multiplier = this.multiplier;
        int attributeStart = -1;
        boolean bl = isNegative = number.signum() < 0;
        if (isNegative) {
            attributeStart = dest.length();
            dest.append(this.negativePrefix);
            number = number.abs();
            _multiplier = this.negativePatternMultiplier;
            this.addAttribute(NumberFormat.Field.SIGN, attributeStart, dest.length());
        } else {
            dest.append(this.positivePrefix);
        }
        int beginIndexInt = dest.length();
        int endIndexInt = 0;
        number = number.multiply(BigDecimal.valueOf(_multiplier));
        if (this.maximumIntegerDigits == 0 && this.maximumFractionDigits == 0) {
            number = BigDecimal.ZERO;
            this.maximumIntegerDigits = 1;
            this.minimumIntegerDigits = 1;
        }
        number = number.abs();
        int scale = this.maximumFractionDigits;
        long exponent = 0L;
        if (this.useExponentialNotation) {
            exponent = this.getExponent(number);
            number = number.movePointLeft((int)exponent);
        }
        number = number.setScale(scale, 6);
        String plain = number.toPlainString();
        String intPart = null;
        String fractPart = null;
        int minusIndex = plain.lastIndexOf(45, 0);
        if (minusIndex > -1) {
            plain = plain.substring(minusIndex + 1);
        }
        if ((dot = plain.indexOf(46)) > -1) {
            intPart = plain.substring(0, dot);
            fractPart = this.useExponentialNotation ? plain.substring(dot, dot + scale) : plain.substring(++dot);
        } else {
            intPart = plain;
        }
        endIndexInt = intPartLen = intPart.length();
        int zeroes = this.minimumIntegerDigits - intPartLen;
        if (zeroes > 0) {
            attributeStart = Math.max(dest.length() - 1, 0);
            this.appendZero(dest, zeroes, this.minimumIntegerDigits);
        }
        if (this.useExponentialNotation) {
            if (attributeStart < 0) {
                attributeStart = Math.max(dest.length() - 1, 0);
            }
            this.appendDigit(intPart, dest, this.groupingUsed);
        } else {
            intPartLen = intPart.length();
            int canary = Math.min(intPartLen, this.maximumIntegerDigits);
            intPart = intPart.substring(intPartLen - canary);
            endIndexInt = intPart.length() + 1;
            if (this.maximumIntegerDigits > 0 && (this.minimumIntegerDigits != 0 || intPart.compareTo(String.valueOf(this.symbols.getZeroDigit())) != 0)) {
                if (attributeStart < 0) {
                    attributeStart = Math.max(dest.length() - 1, 0);
                }
                this.appendDigit(intPart, dest, this.groupingUsed);
            }
        }
        this.addAttribute(NumberFormat.Field.INTEGER, attributeStart, dest.length());
        if (fieldPos.getField() == 0 || fieldPos.getFieldAttribute() == NumberFormat.Field.INTEGER) {
            fieldPos.setBeginIndex(beginIndexInt);
            fieldPos.setEndIndex(endIndexInt);
        }
        this.handleFractionalPart(dest, fractPart, fieldPos, isLong);
        if (this.useExponentialNotation) {
            attributeStart = dest.length();
            dest.append(this.symbols.getExponential());
            this.addAttribute(NumberFormat.Field.EXPONENT_SYMBOL, attributeStart, dest.length());
            attributeStart = dest.length();
            if (exponent < 0L) {
                dest.append(this.symbols.getMinusSign());
                exponent = -exponent;
                this.addAttribute(NumberFormat.Field.EXPONENT_SIGN, attributeStart, dest.length());
            }
            attributeStart = dest.length();
            String exponentString = String.valueOf(exponent);
            int exponentLength = exponentString.length();
            int i = 0;
            while (i < this.minExponentDigits - exponentLength) {
                dest.append(this.symbols.getZeroDigit());
                ++i;
            }
            i = 0;
            while (i < exponentLength) {
                dest.append(exponentString.charAt(i));
                ++i;
            }
            this.addAttribute(NumberFormat.Field.EXPONENT, attributeStart, dest.length());
        }
        if (isNegative) {
            dest.append(this.negativeSuffix);
        } else {
            dest.append(this.positiveSuffix);
        }
    }

    private void handleFractionalPart(StringBuffer dest, String fractPart, FieldPosition fieldPos, boolean isLong) {
        int dotStart = 0;
        int dotEnd = 0;
        boolean addDecimal = false;
        if (this.decimalSeparatorAlwaysShown || (!isLong || this.useExponentialNotation) && this.showDecimalSeparator && this.maximumFractionDigits > 0 || this.minimumFractionDigits > 0) {
            dotStart = dest.length();
            if (this.useCurrencySeparator) {
                dest.append(this.symbols.getMonetaryDecimalSeparator());
            } else {
                dest.append(this.symbols.getDecimalSeparator());
            }
            dotEnd = dest.length();
            addDecimal = true;
        }
        int fractStart = 0;
        int fractEnd = 0;
        boolean addFractional = false;
        if ((!isLong || this.useExponentialNotation) && this.maximumFractionDigits > 0 || this.minimumFractionDigits > 0) {
            fractEnd = fractStart = dest.length();
            int digits = this.minimumFractionDigits;
            if (this.useExponentialNotation && (digits = this.minimumIntegerDigits + this.minimumFractionDigits - dest.length()) < 0) {
                digits = 0;
            }
            fractPart = this.adjustTrailingZeros(fractPart, digits);
            boolean allZeros = true;
            char[] fracts = fractPart.toCharArray();
            int i = 0;
            while (i < fracts.length) {
                if (fracts[i] != '0') {
                    allZeros = false;
                }
                ++i;
            }
            if (!allZeros || this.minimumFractionDigits > 0) {
                this.appendDigit(fractPart, dest, false);
                fractEnd = dest.length();
                addDecimal = true;
                addFractional = true;
            } else if (!this.decimalSeparatorAlwaysShown) {
                dest.deleteCharAt(dest.length() - 1);
                addDecimal = false;
            } else {
                fractEnd = dest.length();
                addFractional = true;
            }
        }
        if (addDecimal) {
            this.addAttribute(NumberFormat.Field.DECIMAL_SEPARATOR, dotStart, dotEnd);
        }
        if (addFractional) {
            this.addAttribute(NumberFormat.Field.FRACTION, fractStart, fractEnd);
        }
        if (fieldPos.getField() == 1 || fieldPos.getFieldAttribute() == NumberFormat.Field.FRACTION) {
            fieldPos.setBeginIndex(fractStart);
            fieldPos.setEndIndex(fractEnd);
        }
    }

    private void appendZero(StringBuffer dest, int zeroes, int totalDigitCount) {
        char ch = this.symbols.getZeroDigit();
        char gSeparator = this.symbols.getGroupingSeparator();
        int i = 0;
        int gPos = totalDigitCount;
        i = 0;
        while (i < zeroes) {
            if (this.groupingSeparatorInPattern && this.groupingUsed && this.groupingSize != 0 && gPos % this.groupingSize == 0 && i > 0) {
                dest.append(gSeparator);
            }
            dest.append(ch);
            ++i;
            --gPos;
        }
        if (this.groupingSeparatorInPattern && this.groupingUsed && this.groupingSize != 0 && gPos % this.groupingSize == 0) {
            dest.append(gSeparator);
        }
    }

    private void appendDigit(String src, StringBuffer dest, boolean groupingUsed) {
        int zero = this.symbols.getZeroDigit() - 48;
        char gSeparator = this.symbols.getGroupingSeparator();
        int len = src.length();
        int i = 0;
        int gPos = len;
        while (i < len) {
            char ch = src.charAt(i);
            if (groupingUsed && this.groupingSize != 0 && gPos % this.groupingSize == 0 && i > 0) {
                dest.append(gSeparator);
            }
            dest.append((char)(zero + ch));
            ++i;
            --gPos;
        }
    }

    private long getExponent(BigDecimal number) {
        long exponent = 0L;
        if (number.signum() > 0) {
            double _number = number.doubleValue();
            exponent = (long)Math.floor(Math.log10(_number));
            exponent -= exponent % (long)this.exponentRound;
            if (this.minimumIntegerDigits > 0) {
                exponent -= (long)(this.minimumIntegerDigits - 1);
            }
        }
        return exponent;
    }

    private String adjustTrailingZeros(String src, int minimumDigits) {
        String result;
        int len = src.length();
        if (len > minimumDigits) {
            int zeros = 0;
            int i = len - 1;
            while (i > minimumDigits) {
                if (src.charAt(i) != '0') break;
                ++zeros;
                --i;
            }
            result = src.substring(0, len - zeros);
        } else {
            char zero = this.symbols.getZeroDigit();
            CPStringBuilder _result = new CPStringBuilder(src);
            int i = len;
            while (i < minimumDigits) {
                _result.append(zero);
                ++i;
            }
            result = _result.toString();
        }
        return result;
    }

    private void addAttribute(NumberFormat.Field field, int begin, int end) {
        FieldPosition pos = new FieldPosition(field);
        pos.setBeginIndex(begin);
        pos.setEndIndex(end);
        this.attributes.add(pos);
    }

    private void setDefaultValues() {
        this.negativePrefix = String.valueOf(this.symbols.getMinusSign());
        this.negativeSuffix = "";
        this.positivePrefix = "";
        this.positiveSuffix = "";
        this.multiplier = 1;
        this.negativePatternMultiplier = 1;
        this.exponentRound = 1;
        this.hasNegativePrefix = false;
        this.minimumIntegerDigits = 1;
        this.maximumIntegerDigits = 309;
        this.minimumFractionDigits = 0;
        this.maximumFractionDigits = 340;
        this.minExponentDigits = 0;
        this.groupingSize = 0;
        this.decimalSeparatorAlwaysShown = false;
        this.showDecimalSeparator = false;
        this.useExponentialNotation = false;
        this.groupingUsed = false;
        this.groupingSeparatorInPattern = false;
        this.useCurrencySeparator = false;
        this.hasFractionalPattern = false;
    }
}

