/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class BooleanControl
extends Control {
    private boolean value;
    private String trueLabel;
    private String falseLabel;

    protected BooleanControl(Type type, boolean init) {
        super(type);
        this.value = init;
        this.trueLabel = "true";
        this.falseLabel = "false";
    }

    protected BooleanControl(Type type, boolean init, String trueLabel, String falseLabel) {
        super(type);
        this.value = init;
        this.trueLabel = trueLabel;
        this.falseLabel = falseLabel;
    }

    public String getStateLabel(boolean state) {
        return state ? this.trueLabel : this.falseLabel;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.getStateLabel(this.value);
    }

    public static class Type
    extends Control.Type {
        public static final Type APPLY_REVERB = new Type("Apply reverb");
        public static final Type MUTE = new Type("Mute");

        protected Type(String name) {
            super(name);
        }
    }
}

