/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.doclets.htmldoclet;

import gnu.classpath.tools.IOToolkit;
import gnu.classpath.tools.doclets.htmldoclet.CssClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class HtmlPage {
    private File file;
    private PrintWriter out;
    private String pathToRoot;
    private String docType;
    private String baseUrl;
    private File rootDir;
    public static final String DOCTYPE_FRAMESET = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">";

    public HtmlPage(File file, String pathToRoot, String encoding, String baseUrl, File rootDir) throws IOException {
        this(file, pathToRoot, encoding, baseUrl, rootDir, "<!DOCTYPE html PUBLIC \"-//gnu.org///DTD XHTML 1.1 plus Target 1.0//EN\" \"" + pathToRoot + "/resources/xhtml11-target10.dtd\">");
    }

    public HtmlPage(File file, String pathToRoot, String encoding, String baseUrl, File rootDir, String docType) throws IOException {
        this.file = file;
        FileOutputStream fileOut = new FileOutputStream(file);
        OutputStreamWriter writer = encoding != null ? new OutputStreamWriter((OutputStream)fileOut, encoding) : new OutputStreamWriter(fileOut);
        this.out = new PrintWriter(new BufferedWriter(writer));
        this.pathToRoot = pathToRoot;
        this.docType = docType;
        this.baseUrl = baseUrl;
        this.rootDir = rootDir;
    }

    public void beginElement(String elementName) {
        this.print('<');
        this.print(elementName);
        this.print('>');
    }

    public void beginElement(String elementName, String attributeName, String attributeValue) {
        this.print('<');
        this.print(elementName);
        this.print(' ');
        this.print(attributeName);
        this.print('=');
        this.print('\"');
        this.print(attributeValue);
        this.print('\"');
        this.print('>');
    }

    public void beginElement(String elementName, String[] attributeNames, String[] attributeValues) {
        this.print('<');
        this.print(elementName);
        int i = 0;
        while (i < attributeNames.length) {
            if (attributeValues[i] != null) {
                this.print(' ');
                this.print(attributeNames[i]);
                this.print('=');
                this.print('\"');
                this.print(attributeValues[i]);
                this.print('\"');
            }
            ++i;
        }
        this.print('>');
    }

    public void beginElement(String elementName, String attributeName, String attributeValue, String[] attributeNames, String[] attributeValues) {
        this.print('<');
        this.print(elementName);
        this.print(' ');
        this.print(attributeName);
        this.print('=');
        this.print('\"');
        this.print(attributeValue);
        this.print('\"');
        if (attributeNames != null) {
            int i = 0;
            while (i < attributeNames.length) {
                if (attributeValues[i] != null) {
                    this.print(' ');
                    this.print(attributeNames[i]);
                    this.print('=');
                    this.print('\"');
                    this.print(attributeValues[i]);
                    this.print('\"');
                }
                ++i;
            }
        }
        this.print('>');
    }

    public void atomicElement(String elementName) {
        this.print('<');
        this.print(elementName);
        this.print("/>");
    }

    public void atomicElement(String elementName, String attributeName, String attributeValue) {
        this.print('<');
        this.print(elementName);
        this.print(' ');
        this.print(attributeName);
        this.print('=');
        this.print('\"');
        this.print(attributeValue);
        this.print('\"');
        this.print("/>");
    }

    public void atomicElement(String elementName, String[] attributeNames, String[] attributeValues) {
        this.print('<');
        this.print(elementName);
        int i = 0;
        while (i < attributeNames.length) {
            if (attributeValues[i] != null) {
                this.print(' ');
                this.print(attributeNames[i]);
                this.print('=');
                this.print('\"');
                this.print(attributeValues[i]);
                this.print('\"');
            }
            ++i;
        }
        this.print("/>");
    }

    public void endElement(String elementName) {
        this.print("</");
        this.print(elementName);
        this.print('>');
    }

    public void beginDiv(CssClass cssClass) {
        String[] divAttributeNames = cssClass.getAttributeNames();
        String[] divAttributeValues = cssClass.getAttributeValues();
        if (divAttributeNames == null) {
            divAttributeNames = new String[]{};
        }
        if (divAttributeValues == null) {
            divAttributeValues = new String[]{};
        }
        String[] attributeNames = new String[1 + divAttributeNames.length];
        String[] attributeValues = new String[1 + divAttributeValues.length];
        System.arraycopy(divAttributeNames, 0, attributeNames, 1, divAttributeNames.length);
        System.arraycopy(divAttributeValues, 0, attributeValues, 1, divAttributeNames.length);
        attributeNames[0] = "class";
        attributeValues[0] = cssClass.getName();
        this.beginElement(cssClass.getDivElementName(), attributeNames, attributeValues);
        if (cssClass.getInnerElementName() != null) {
            this.beginElement(cssClass.getInnerElementName());
        }
    }

    public void endDiv(CssClass cssClass) {
        if (cssClass.getInnerElementName() != null) {
            this.endElement(cssClass.getInnerElementName());
        }
        this.endElement(cssClass.getDivElementName());
    }

    public void beginSpan(CssClass cssClass) {
        this.beginElement(cssClass.getSpanElementName(), "class", cssClass.getName());
    }

    public void endSpan(CssClass cssClass) {
        this.endElement(cssClass.getSpanElementName());
    }

    public void hr() {
        this.atomicElement("hr");
    }

    public void br() {
        this.atomicElement("br");
    }

    public void print(String text) {
        this.out.print(text);
    }

    public void print(char c) {
        this.out.print(c);
    }

    public void div(CssClass cssClass, String contents) {
        this.beginDiv(cssClass);
        this.print(contents);
        this.endDiv(cssClass);
    }

    public void span(CssClass cssClass, String contents) {
        this.beginSpan(cssClass);
        this.print(contents);
        this.endSpan(cssClass);
    }

    public void beginPage(String title, String charset, Map stylesheets) throws IOException {
        this.beginPage(title, charset, Collections.EMPTY_SET, stylesheets);
    }

    public void beginPage(String title, String charset, Collection keywords, Map stylesheets) throws IOException {
        this.print("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n");
        this.print(this.docType);
        this.print("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">");
        this.beginElement("head");
        this.beginElement("title");
        this.print(title);
        this.endElement("title");
        if (this.baseUrl != null && this.baseUrl.length() > 0) {
            StringBuffer url = new StringBuffer();
            url.append(this.baseUrl);
            if ('/' == url.charAt(url.length() - 1)) {
                url.delete(url.length() - 1, url.length());
            }
            url.append(this.file.getCanonicalPath().substring(this.rootDir.getCanonicalPath().length()));
            this.atomicElement("base", new String[]{"href"}, new String[]{url.toString()});
        }
        this.beginElement("script", new String[]{"src", "type"}, new String[]{String.valueOf(this.pathToRoot) + "/resources/gjdoc.js", "text/javascript"});
        this.print("<!-- this comment required for konqueror 3.2.2 -->");
        this.endElement("script");
        this.atomicElement("meta", new String[]{"http-equiv", "content"}, new String[]{"Content-Type", "text/html; charset=" + charset});
        this.atomicElement("meta", new String[]{"name", "content"}, new String[]{"generator", "GNU Gjdoc Standard Doclet"});
        for (String keyword : keywords) {
            this.atomicElement("meta", new String[]{"name", "content"}, new String[]{"keywords", keyword});
        }
        for (String sheetName : stylesheets.keySet()) {
            String[] sheetFiles = (String[])stylesheets.get(sheetName);
            int i = 0;
            while (i < sheetFiles.length) {
                String sheetFile = sheetFiles[i];
                this.atomicElement("link", new String[]{"rel", "type", "href", "title"}, new String[]{"stylesheet", "text/css", String.valueOf(this.pathToRoot) + "/" + sheetFile, sheetName});
                ++i;
            }
        }
        this.endElement("head");
    }

    public void endPage() {
        this.endElement("html");
    }

    public void close() {
        this.out.close();
    }

    public void beginTable(CssClass cssClass) {
        this.beginElement("table", "class", cssClass.getName());
    }

    public void beginTable(CssClass cssClass, String[] attributeNames, String[] attributeValues) {
        this.beginElement("table", "class", cssClass.getName(), attributeNames, attributeValues);
    }

    public void beginRow() {
        this.beginElement("tr");
    }

    public void beginRow(CssClass cssClass) {
        this.beginElement("tr", "class", cssClass.getName(), cssClass.getAttributeNames(), cssClass.getAttributeValues());
    }

    public void beginRow(String attribute, String value) {
        this.beginElement("tr", attribute, value);
    }

    public void beginCell() {
        this.beginElement("td");
    }

    public void beginCell(String attribute, String value) {
        this.beginElement("td", attribute, value);
    }

    public void beginCell(CssClass cssClass) {
        this.beginElement("td", "class", cssClass.getName(), cssClass.getAttributeNames(), cssClass.getAttributeValues());
    }

    public void endCell() {
        this.endElement("td");
    }

    public void cell(CssClass cssClass, String contents) {
        this.beginCell(cssClass);
        this.print(contents);
        this.endCell();
    }

    public void endRow() {
        this.endElement("tr");
    }

    public void rowDiv(CssClass cssClass, String contents) {
        this.beginRow(cssClass);
        this.beginCell("colspan", "2");
        this.beginDiv(cssClass);
        this.print(contents);
        this.endDiv(cssClass);
        this.endCell();
        this.endRow();
    }

    public void endTable() {
        this.endElement("table");
    }

    public void beginAnchor(String href) {
        this.beginElement("a", "href", href);
    }

    public void beginAnchor(String href, String title) {
        this.beginElement("a", new String[]{"href", "title"}, new String[]{href, title});
    }

    public void beginAnchor(String href, String title, String target) {
        this.beginElement("a", new String[]{"href", "title", "target"}, new String[]{href, title, target});
    }

    public void endAnchor() {
        this.endElement("a");
    }

    public void anchor(String href, String label) {
        this.beginAnchor(href);
        this.print(label);
        this.endAnchor();
    }

    public void anchorName(String name) {
        this.atomicElement("a", new String[]{"name", "id"}, new String[]{name, name});
    }

    public String getPathToRoot() {
        return this.pathToRoot;
    }

    public void beginBody(CssClass cssClass) {
        this.beginBody(cssClass, true);
    }

    public void beginBody(CssClass cssClass, boolean setTitle) {
        if (setTitle) {
            this.beginElement("body", new String[]{"class", "onload"}, new String[]{cssClass.getName(), "if(parent.contentPageLoaded)parent.contentPageLoaded(document.title)"});
        } else {
            this.beginElement("body", new String[]{"class", "onload"}, new String[]{cssClass.getName(), "if(parent.contentPageLoaded)parent.contentPageLoaded()"});
        }
    }

    public void endBody() {
        this.endElement("body");
    }

    public void insert(Reader in) throws IOException {
        IOToolkit.copyStream(in, this.out);
    }

    public String createHrefString(String url, String content) {
        return this.createHrefString(url, content, null);
    }

    public String createHrefString(String url, String content, String title) {
        StringBuffer result = new StringBuffer();
        result.append("<a href=\"");
        result.append(url);
        result.append("\"");
        if (title != null) {
            result.append(" title=\"");
            result.append(title);
            result.append("\"");
        }
        result.append(">");
        result.append(content);
        result.append("</a>");
        return result.toString();
    }

    public File getFile() {
        return this.file;
    }
}

