/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedWriter;
import java.io.Reader;

public class PipedReader
extends Reader {
    PipedWriter source;
    boolean closed;
    static final int PIPE_SIZE = 2048;
    char[] buffer = new char[2048];
    int in = -1;
    int out = 0;
    char[] read_buf = new char[1];

    public PipedReader() {
    }

    public PipedReader(PipedWriter source) throws IOException {
        this.connect(source);
    }

    public void connect(PipedWriter source) throws IOException {
        if (this.source != null || source.sink != null) {
            throw new IOException("Already connected");
        }
        source.sink = this;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void receive(char[] buf, int offset, int len) throws IOException {
        var4_4 = this.lock;
        synchronized (var4_4) {
            if (this.closed) {
                throw new IOException("Pipe closed");
            }
            bufpos = offset;
lbl7:
            // 3 sources

            while (true) {
                if (len <= 0) {
                    this.lock.notifyAll();
                    return;
                }
                if (true) ** GOTO lbl19
                break;
            }
            {
                do {
                    this.lock.notifyAll();
                    this.lock.wait();
                    if (!this.closed) continue;
                    throw new IOException("Pipe closed");
lbl19:
                    // 2 sources

                } while (this.in == this.out);
            }
            if (this.in < 0) {
                this.in = 0;
            }
            copylen = this.in < this.out ? Math.min(len, this.out - this.in) : Math.min(len, this.buffer.length - this.in);
            System.arraycopy(buf, bufpos, this.buffer, this.in, copylen);
            len -= copylen;
            bufpos += copylen;
            this.in += copylen;
            if (this.in != this.buffer.length) ** GOTO lbl7
            this.in = 0;
            ** continue;
        }
    }

    public int read() throws IOException {
        int r = this.read(this.read_buf, 0, 1);
        return r != -1 ? this.read_buf[0] : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] buf, int offset, int len) throws IOException {
        var4_4 = this.lock;
        synchronized (var4_4) {
            if (this.source == null) {
                throw new IOException("Not connected");
            }
            if (this.closed) {
                throw new IOException("Pipe closed");
            }
            if (len == 0) {
                return 0;
            }
            if (true) ** GOTO lbl17
            {
                do {
                    if (this.source.closed) {
                        return -1;
                    }
                    this.lock.wait();
lbl17:
                    // 2 sources

                } while (this.in < 0);
            }
            total = 0;
            do {
                copylen = this.out < this.in ? Math.min(len, this.in - this.out) : Math.min(len, this.buffer.length - this.out);
                System.arraycopy(this.buffer, this.out, buf, offset, copylen);
                offset += copylen;
                len -= copylen;
                this.out += copylen;
                total += copylen;
                if (this.out == this.buffer.length) {
                    this.out = 0;
                }
                if (this.out != this.in) continue;
                this.in = -1;
                this.out = 0;
            } while (len != 0 && this.in != -1);
            this.lock.notifyAll();
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.closed) {
                    throw new IOException("Pipe closed");
                }
                if (this.in >= 0) break block5;
                return false;
            }
            int count = this.out < this.in ? this.in - this.out : this.buffer.length - this.out - this.in;
            return count > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.lock.notifyAll();
        }
    }
}

