/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.util.Base64;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.logging.Logger;

class ListCmd
extends Command {
    private static final Logger log = Logger.getLogger(ListCmd.class.getName());
    protected String _alias;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    protected boolean rfc;
    private boolean all;

    ListCmd() {
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    public void setRfc(String flag) {
        this.rfc = Boolean.valueOf(flag);
    }

    void setup() throws Exception {
        this.setOutputStreamParam(null);
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        boolean bl = this.all = this._alias == null;
        if (!this.all) {
            this.setAliasParam(this._alias);
        }
        if (this.verbose & this.rfc) {
            if (Configuration.DEBUG) {
                log.fine("Both -v and -rfc options were found on the command line. Only the former will be considered");
            }
            this.rfc = false;
        }
        if (Configuration.DEBUG) {
            log.fine("-list handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
            log.fine("  -rfc=" + this.rfc);
        }
    }

    void start() throws KeyStoreException, CertificateEncodingException, IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        PrintWriter writer = new PrintWriter(this.outStream, true);
        writer.println(Messages.getFormattedString("ListCmd.21", this.store.getType()));
        writer.println(Messages.getFormattedString("ListCmd.22", this.store.getProvider().getName()));
        if (this.all) {
            if (Configuration.DEBUG) {
                log.fine("About to list all aliases in key store...");
            }
            writer.println();
            writer.println(Messages.getFormattedString("ListCmd.24", this.store.size()));
            Enumeration<String> e = this.store.aliases();
            while (e.hasMoreElements()) {
                String anAlias = e.nextElement();
                if (anAlias == null) continue;
                this.list1Alias(anAlias, writer);
            }
        } else {
            this.list1Alias(this.alias, writer);
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("list", true);
        result.setHeader(Messages.getString("ListCmd.20"));
        result.setFooter(Messages.getString("ListCmd.19"));
        OptionGroup options = new OptionGroup(Messages.getString("ListCmd.18"));
        options.add(new Option("alias", Messages.getString("ListCmd.17"), Messages.getString("ListCmd.16")){

            public void parsed(String argument) throws OptionException {
                ListCmd.this._alias = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("ListCmd.15"), Messages.getString("ListCmd.14")){

            public void parsed(String argument) throws OptionException {
                ListCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("ListCmd.13"), Messages.getString("ListCmd.12")){

            public void parsed(String argument) throws OptionException {
                ListCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("ListCmd.11"), Messages.getString("ListCmd.10")){

            public void parsed(String argument) throws OptionException {
                ListCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("ListCmd.9"), Messages.getString("ListCmd.8")){

            public void parsed(String argument) throws OptionException {
                ListCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("ListCmd.7")){

            public void parsed(String argument) throws OptionException {
                ListCmd.this.verbose = true;
            }
        });
        options.add(new Option("rfc", Messages.getString("ListCmd.6")){

            public void parsed(String argument) throws OptionException {
                ListCmd.this.rfc = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    private void list1Alias(String anAlias, PrintWriter writer) throws KeyStoreException, CertificateEncodingException, IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "list1Alias", anAlias);
        }
        writer.println();
        writer.println(Messages.getFormattedString("ListCmd.30", anAlias));
        writer.println(Messages.getFormattedString("ListCmd.31", this.store.getCreationDate(anAlias)));
        if (this.store.isCertificateEntry(anAlias)) {
            writer.println(Messages.getString("ListCmd.32"));
            Certificate certificate = this.store.getCertificate(anAlias);
            this.print1Certificate(certificate, writer);
        } else if (this.store.isKeyEntry(anAlias)) {
            writer.println(Messages.getString("ListCmd.33"));
            Certificate[] chain = this.store.getCertificateChain(anAlias);
            this.print1Chain(chain, writer);
        } else {
            throw new IllegalArgumentException(Messages.getFormattedString("ListCmd.34", anAlias));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "list1Alias");
        }
    }

    private void print1Chain(Certificate[] chain, PrintWriter writer) throws CertificateEncodingException {
        if (!this.verbose && !this.rfc) {
            this.fingerprint(chain[0], writer);
        } else {
            int limit = chain.length;
            writer.println(Messages.getFormattedString("ListCmd.38", limit));
            writer.println(Messages.getString("ListCmd.39"));
            this.print1Certificate(chain[0], writer);
            int i = 1;
            while (i < limit) {
                writer.println();
                writer.println(Messages.getFormattedString("ListCmd.40", i + 1));
                this.print1Certificate(chain[i], writer);
                ++i;
            }
            writer.println();
            writer.println(Messages.getString("ListCmd.42"));
        }
    }

    private void print1Certificate(Certificate certificate, PrintWriter writer) throws CertificateEncodingException {
        if (this.verbose) {
            this.printVerbose(certificate, writer);
        } else if (this.rfc) {
            this.printRFC1421(certificate, writer);
        } else {
            this.fingerprint(certificate, writer);
        }
    }

    private void printRFC1421(Certificate certificate, PrintWriter writer) throws CertificateEncodingException {
        byte[] derBytes = certificate.getEncoded();
        String encoded = Base64.encode((byte[])derBytes, (int)72);
        writer.println(Messages.getString("ListCmd.43"));
        writer.println(encoded);
        writer.println(Messages.getString("ListCmd.44"));
    }

    private void fingerprint(Certificate certificate, PrintWriter writer) throws CertificateEncodingException {
        byte[] derBytes = certificate.getEncoded();
        String fingerPrint = this.digestWithMD5(derBytes);
        writer.println(Messages.getFormattedString("ListCmd.45", fingerPrint));
    }
}

