/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.convert;

import gnu.gcj.convert.BytesToCharsetAdaptor;
import gnu.gcj.convert.IOConverter;
import gnu.gcj.convert.Input_8859_1;
import gnu.gcj.convert.Input_iconv;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public abstract class BytesToUnicode
extends IOConverter {
    public byte[] inbuffer;
    public int inpos;
    public int inlength;
    static String defaultEncoding;
    private static final int CACHE_SIZE = 4;
    private static BytesToUnicode[] decoderCache;
    private static int currCachePos;

    static {
        decoderCache = new BytesToUnicode[4];
        currCachePos = 0;
    }

    public abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BytesToUnicode getDefaultDecoder() {
        try {
            Class<BytesToUnicode> clazz = BytesToUnicode.class;
            synchronized (BytesToUnicode.class) {
                if (defaultEncoding == null) {
                    String encoding = BytesToUnicode.canonicalize(System.getProperty("file.encoding", "8859_1"));
                    String className = "gnu.gcj.convert.Input_" + encoding;
                    try {
                        Class.forName(className);
                        defaultEncoding = encoding;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError("missing default encoding " + encoding + " (class " + className + " not found)");
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return BytesToUnicode.getDecoder(defaultEncoding);
            }
        }
        catch (Throwable throwable) {
            return new Input_8859_1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BytesToUnicode getDecoder(String encoding) throws UnsupportedEncodingException {
        String canonicalEncoding = BytesToUnicode.canonicalize(encoding);
        Class<BytesToUnicode> clazz = BytesToUnicode.class;
        synchronized (BytesToUnicode.class) {
            int i = 0;
            while (i < decoderCache.length) {
                if (decoderCache[i] != null && canonicalEncoding.equals(decoderCache[i].getName())) {
                    BytesToUnicode rv = decoderCache[i];
                    BytesToUnicode.decoderCache[i] = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return rv;
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String className = "gnu.gcj.convert.Input_" + canonicalEncoding;
            try {
                Class<?> decodingClass = Class.forName(className);
                return (BytesToUnicode)decodingClass.newInstance();
            }
            catch (Throwable ex) {
                try {
                    return new Input_iconv(encoding);
                }
                catch (Throwable throwable) {
                    try {
                        return new BytesToCharsetAdaptor(Charset.forName(encoding));
                    }
                    catch (Throwable throwable2) {
                        throw new UnsupportedEncodingException(String.valueOf(encoding) + " (" + ex + ')');
                    }
                }
            }
        }
    }

    public final void setInput(byte[] buffer, int pos, int length) {
        this.inbuffer = buffer;
        this.inpos = pos;
        this.inlength = length;
    }

    public abstract int read(char[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Class<BytesToUnicode> clazz = BytesToUnicode.class;
        synchronized (BytesToUnicode.class) {
            this.inbuffer = null;
            this.inpos = 0;
            this.inlength = 0;
            BytesToUnicode.decoderCache[BytesToUnicode.currCachePos] = this;
            currCachePos = (currCachePos + 1) % 4;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

