/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.XPathParser;
import gnu.xml.xpath.XPathTokenizer;
import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.xml.sax.InputSource;

public class XPathImpl
implements XPath {
    XPathParser parser = new XPathParser();
    NamespaceContext namespaceContext;
    XPathVariableResolver variableResolver;
    XPathFunctionResolver functionResolver;

    XPathImpl(NamespaceContext namespaceContext, XPathVariableResolver variableResolver, XPathFunctionResolver functionResolver) {
        this.namespaceContext = namespaceContext;
        this.variableResolver = variableResolver;
        this.functionResolver = functionResolver;
        this.reset();
    }

    public void reset() {
        this.parser.namespaceContext = this.namespaceContext;
        this.parser.variableResolver = this.variableResolver;
        this.parser.functionResolver = this.functionResolver;
    }

    public void setXPathVariableResolver(XPathVariableResolver resolver) {
        this.parser.variableResolver = resolver;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.parser.variableResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver resolver) {
        this.parser.functionResolver = resolver;
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.parser.functionResolver;
    }

    public void setNamespaceContext(NamespaceContext nsContext) {
        this.parser.namespaceContext = nsContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.parser.namespaceContext;
    }

    public XPathExpression compile(String expression) throws XPathExpressionException {
        XPathTokenizer tokenizer = new XPathTokenizer(expression);
        try {
            return (Expr)this.parser.yyparse(tokenizer);
        }
        catch (IOException e) {
            throw new XPathExpressionException(e);
        }
        catch (XPathParser.yyException yyException2) {
            throw new XPathExpressionException(expression);
        }
    }

    public Object evaluate(String expression, Object item, QName returnType) throws XPathExpressionException {
        XPathExpression expr = this.compile(expression);
        return expr.evaluate(item, returnType);
    }

    public String evaluate(String expression, Object item) throws XPathExpressionException {
        XPathExpression expr = this.compile(expression);
        return expr.evaluate(item);
    }

    public Object evaluate(String expression, InputSource source, QName returnType) throws XPathExpressionException {
        XPathExpression expr = this.compile(expression);
        return expr.evaluate(source, returnType);
    }

    public String evaluate(String expression, InputSource source) throws XPathExpressionException {
        XPathExpression expr = this.compile(expression);
        return expr.evaluate(source);
    }
}

