/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import gnu.java.lang.CPStringBuilder;
import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class MultiPixelPackedSampleModel
extends SampleModel {
    private int scanlineStride;
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;
    private int dataBitOffset;
    private int elemBits;
    private int numberOfBits;
    private int numElems;

    public MultiPixelPackedSampleModel(int dataType, int w, int h, int numberOfBits) {
        this(dataType, w, h, numberOfBits, 0, 0);
    }

    public MultiPixelPackedSampleModel(int dataType, int w, int h, int numberOfBits, int scanlineStride, int dataBitOffset) {
        super(dataType, w, h, 1);
        switch (dataType) {
            case 0: {
                this.elemBits = 8;
                break;
            }
            case 1: {
                this.elemBits = 16;
                break;
            }
            case 3: {
                this.elemBits = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("MultiPixelPackedSampleModel unsupported dataType");
            }
        }
        this.dataBitOffset = dataBitOffset;
        this.numberOfBits = numberOfBits;
        if (numberOfBits > this.elemBits) {
            throw new RasterFormatException("MultiPixelPackedSampleModel pixel size larger than dataType");
        }
        switch (numberOfBits) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new RasterFormatException("MultiPixelPackedSampleModel pixel size not 2^n bits");
            }
        }
        this.numElems = this.elemBits / numberOfBits;
        if (scanlineStride == 0) {
            scanlineStride = (dataBitOffset + w * numberOfBits - 1) / this.elemBits + 1;
        }
        this.scanlineStride = scanlineStride;
        this.sampleSize = new int[1];
        this.sampleSize[0] = numberOfBits;
        this.bitMasks = new int[this.numElems];
        this.bitOffsets = new int[this.numElems];
        int i = 0;
        while (i < this.numElems) {
            this.bitOffsets[this.numElems - i - 1] = numberOfBits * i;
            this.bitMasks[this.numElems - i - 1] = (1 << numberOfBits) - 1 << this.bitOffsets[this.numElems - i - 1];
            ++i;
        }
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new MultiPixelPackedSampleModel(this.dataType, w, h, this.numberOfBits);
    }

    public DataBuffer createDataBuffer() {
        int size = this.scanlineStride * this.height;
        if (this.dataBitOffset > 0) {
            size += (this.dataBitOffset - 1) / this.elemBits + 1;
        }
        return Buffers.createBuffer(this.getDataType(), size);
    }

    public int getNumDataElements() {
        return 1;
    }

    public int[] getSampleSize() {
        return (int[])this.sampleSize.clone();
    }

    public int getSampleSize(int band) {
        return this.sampleSize[0];
    }

    public int getOffset(int x, int y) {
        return this.scanlineStride * y + (this.dataBitOffset + x * this.numberOfBits) / this.elemBits;
    }

    public int getBitOffset(int x) {
        return (this.dataBitOffset + x * this.numberOfBits) % this.elemBits;
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.numberOfBits;
    }

    public int getTransferType() {
        if (this.numberOfBits <= DataBuffer.getDataTypeSize(0)) {
            return 0;
        }
        if (this.numberOfBits <= DataBuffer.getDataTypeSize(1)) {
            return 1;
        }
        return 3;
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        if (bands != null && bands.length != 1) {
            throw new RasterFormatException("MultiPixelPackedSampleModel only supports one band");
        }
        return new MultiPixelPackedSampleModel(this.dataType, this.width, this.height, this.numberOfBits, this.scanlineStride, this.dataBitOffset);
    }

    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        int pixel = this.getSample(x, y, 0, data);
        switch (this.getTransferType()) {
            case 0: {
                if (obj == null) {
                    obj = new byte[1];
                }
                ((byte[])obj)[0] = (byte)pixel;
                return obj;
            }
            case 1: {
                if (obj == null) {
                    obj = new short[1];
                }
                ((short[])obj)[0] = (short)pixel;
                return obj;
            }
            case 3: {
                if (obj == null) {
                    obj = new int[1];
                }
                ((int[])obj)[0] = pixel;
                return obj;
            }
        }
        throw new ClassCastException();
    }

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (iArray == null) {
            iArray = new int[]{this.getSample(x, y, 0, data)};
        }
        return iArray;
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        int pos = (this.dataBitOffset + x * this.numberOfBits) % this.elemBits / this.numberOfBits;
        int offset = this.getOffset(x, y);
        int samples = data.getElem(offset);
        return (samples & this.bitMasks[pos]) >>> this.bitOffsets[pos];
    }

    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        int transferType = this.getTransferType();
        try {
            switch (transferType) {
                case 0: {
                    byte[] in = (byte[])obj;
                    this.setSample(x, y, 0, in[0] & 0xFF, data);
                    return;
                }
                case 1: {
                    short[] in = (short[])obj;
                    this.setSample(x, y, 0, in[0] & 0xFFFF, data);
                    return;
                }
                case 3: {
                    int[] in = (int[])obj;
                    this.setSample(x, y, 0, in[0], data);
                    return;
                }
            }
            throw new ClassCastException("Unsupported data type");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = "While writing data elements, x=" + x + ", y=" + y + ", width=" + this.width + ", height=" + this.height + ", scanlineStride=" + this.scanlineStride + ", offset=" + this.getOffset(x, y) + ", data.getSize()=" + data.getSize() + ", data.getOffset()=" + data.getOffset() + ": " + aioobe;
            throw new ArrayIndexOutOfBoundsException(msg);
        }
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        this.setSample(x, y, 0, iArray[0], data);
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        int bitpos = (this.dataBitOffset + x * this.numberOfBits) % this.elemBits / this.numberOfBits;
        int offset = this.getOffset(x, y);
        s <<= this.bitOffsets[bitpos];
        int sample = data.getElem(offset);
        data.setElem(offset, sample |= (s &= this.bitMasks[bitpos]));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiPixelPackedSampleModel)) {
            return false;
        }
        MultiPixelPackedSampleModel that = (MultiPixelPackedSampleModel)obj;
        if (this.dataType != that.dataType) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        if (this.numberOfBits != that.numberOfBits) {
            return false;
        }
        if (this.scanlineStride != that.scanlineStride) {
            return false;
        }
        return this.dataBitOffset == that.dataBitOffset;
    }

    public int hashCode() {
        int result = 193;
        result = 37 * result + this.dataType;
        result = 37 * result + this.width;
        result = 37 * result + this.height;
        result = 37 * result + this.numberOfBits;
        result = 37 * result + this.scanlineStride;
        result = 37 * result + this.dataBitOffset;
        return result;
    }

    public String toString() {
        CPStringBuilder result = new CPStringBuilder();
        result.append(this.getClass().getName());
        result.append("[");
        result.append("scanlineStride=").append(this.scanlineStride);
        int i = 0;
        while (i < this.bitMasks.length) {
            result.append(", mask[").append(i).append("]=0x").append(Integer.toHexString(this.bitMasks[i]));
            ++i;
        }
        result.append("]");
        return result.toString();
    }
}

