/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import gnu.classpath.tools.gjdoc.expr.BinaryExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantBoolean;
import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.Context;
import gnu.classpath.tools.gjdoc.expr.Expression;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;
import gnu.classpath.tools.gjdoc.expr.Type;

abstract class BinaryLogicalExpression
extends BinaryExpression {
    protected BinaryLogicalExpression(Expression left, Expression right) {
        super(left, right);
    }

    public ConstantExpression evaluate(Context context) throws IllegalExpressionException {
        ConstantExpression leftValue = this.left.evaluate(context);
        ConstantExpression rightValue = this.right.evaluate(context);
        if (leftValue.getType() != Type.BOOLEAN || rightValue.getType() != Type.BOOLEAN) {
            throw new IllegalExpressionException("logical expression expects boolean subexpressions");
        }
        return new ConstantBoolean(this.compute(((ConstantBoolean)leftValue).booleanValue(), ((ConstantBoolean)rightValue).booleanValue()));
    }

    protected abstract boolean compute(boolean var1, boolean var2);
}

