/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype;

import gnu.java.awt.font.FontDelegate;
import gnu.java.awt.font.GNUGlyphVector;
import gnu.java.awt.font.autofit.AutoHinter;
import gnu.java.awt.font.opentype.CharGlyphMap;
import gnu.java.awt.font.opentype.GlyphNamer;
import gnu.java.awt.font.opentype.Hinter;
import gnu.java.awt.font.opentype.NameDecoder;
import gnu.java.awt.font.opentype.Scaler;
import gnu.java.awt.font.opentype.truetype.TrueTypeScaler;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.util.Locale;

public final class OpenTypeFont
implements FontDelegate {
    static final int TAG_OTTO = 0x4F54544F;
    static final int TAG_SFNT = 1936092788;
    static final int TAG_TRUE = 1953658213;
    static final int TAG_TTCF = 1953784678;
    static final int TAG_ZAPF = 1516335206;
    ByteBuffer buf;
    final int numGlyphs;
    int[] tableTag;
    int[] tableStart;
    int[] tableLength;
    private int version;
    public int unitsPerEm;
    private float emsPerUnit;
    private Scaler scaler;
    private CharGlyphMap cmap;
    private GlyphNamer glyphNamer;
    private Hinter hinter;
    private ByteBuffer nameTable;

    OpenTypeFont(ByteBuffer buf, int offsetTablePosition) throws FontFormatException {
        this.buf = buf;
        buf.limit(buf.capacity());
        buf.position(offsetTablePosition);
        this.version = buf.getInt();
        switch (this.version) {
            case 65536: 
            case 0x4F54544F: 
            case 1936092788: 
            case 1953658213: 
            case 1954115633: {
                break;
            }
            default: {
                throw new FontFormatException("not in OpenType or TrueType format");
            }
        }
        int numTables = buf.getShort();
        buf.getShort();
        buf.getShort();
        buf.getShort();
        this.tableTag = new int[numTables];
        this.tableStart = new int[numTables];
        this.tableLength = new int[numTables];
        int lastTag = 0;
        int i = 0;
        while (i < numTables) {
            this.tableTag[i] = buf.getInt();
            if (lastTag >= this.tableTag[i]) {
                throw new FontFormatException("unordered OpenType table");
            }
            buf.getInt();
            this.tableStart[i] = buf.getInt();
            this.tableLength[i] = buf.getInt();
            ++i;
        }
        ByteBuffer head = this.getFontTable(1751474532);
        if (head.getInt(0) != 65536 || head.getInt(12) != 1594834165) {
            throw new FontFormatException("unsupported head version");
        }
        this.unitsPerEm = head.getChar(18);
        this.emsPerUnit = 1.0f / (float)this.unitsPerEm;
        ByteBuffer maxp = this.getFontTable(1835104368);
        int maxpVersion = maxp.getInt(0);
        switch (maxpVersion) {
            case 20480: {
                this.numGlyphs = maxp.getChar(4);
                break;
            }
            case 65536: {
                this.numGlyphs = maxp.getChar(4);
                this.scaler = new TrueTypeScaler(this.unitsPerEm, this.getFontTable(1751672161), this.getFontTable(1752003704), this.getFontTable(1986553185), this.getFontTable(1986884728), maxp, this.getFontTable(1668707360), this.getFontTable(1718642541), head.getShort(50), this.getFontTable(1819239265), this.getFontTable(1735162214), this.getFontTable(1886545264));
                break;
            }
            default: {
                throw new FontFormatException("unsupported maxp version");
            }
        }
    }

    private int getTableIndex(int tag) {
        int i = 0;
        while (i < this.tableTag.length) {
            if (this.tableTag[i] == tag) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized String getFamilyName(Locale locale) {
        String name;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((name = this.getName(1, locale)) == null) {
            name = this.getName(1, Locale.ENGLISH);
        }
        if (name == null) {
            name = this.getName(1, null);
        }
        if (name == null) {
            name = this.getName(4, locale);
        }
        if (name == null) {
            name = this.getName(4, null);
        }
        return name;
    }

    public synchronized String getSubFamilyName(Locale locale) {
        String name;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((name = this.getName(2, locale)) == null && "Regular".equals(name = this.getName(2, Locale.ENGLISH))) {
            name = null;
        }
        if (name == null) {
            String lang = locale.getLanguage();
            name = "de".equals(lang) ? "Standard" : ("fr".equals(lang) ? "Standard" : ("it".equals(lang) ? "Normale" : ("nl".equals(lang) ? "Normaal" : ("fi".equals(lang) ? "Normaali" : ("sv".equals(lang) ? "Normal" : "Regular")))));
        }
        return name;
    }

    public synchronized String getFullName(Locale locale) {
        String name;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((name = this.getName(4, locale)) == null) {
            name = this.getName(4, Locale.ENGLISH);
        }
        if (name == null) {
            name = this.getName(4, null);
        }
        return name;
    }

    public synchronized String getPostScriptName() {
        return this.getName(6, null);
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    public int getMissingGlyphCode() {
        return 0;
    }

    private String getName(int name, Locale locale) {
        if (this.nameTable == null) {
            this.nameTable = this.getFontTable(1851878757);
        }
        return NameDecoder.getName(this.nameTable, name, locale);
    }

    public int getVersion() {
        return this.version;
    }

    public synchronized ByteBuffer getFontTable(int tag) {
        int index = this.getTableIndex(tag);
        if (index < 0) {
            return null;
        }
        int start = this.tableStart[index];
        int len = this.tableLength[index];
        this.buf.limit(start + len).position(start);
        ByteBuffer result = this.buf.slice();
        result.limit(len);
        return result;
    }

    public int getFontTableSize(int tag) {
        int index = this.getTableIndex(tag);
        if (index == -1) {
            return index;
        }
        return this.tableLength[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharGlyphMap getCharGlyphMap() {
        if (this.cmap != null) {
            return this.cmap;
        }
        OpenTypeFont openTypeFont = this;
        synchronized (openTypeFont) {
            if (this.cmap == null) {
                int index = this.getTableIndex(1668112752);
                int start = this.tableStart[index];
                this.buf.limit(start + this.tableLength[index]).position(start);
                this.cmap = CharGlyphMap.forTable(this.buf);
            }
            return this.cmap;
        }
    }

    public int getGlyph(int ucs4) {
        return this.getCharGlyphMap().getGlyph(ucs4);
    }

    public synchronized GlyphVector createGlyphVector(Font font, FontRenderContext frc, CharacterIterator ci) {
        this.checkHinter(1);
        CharGlyphMap cmap = this.getCharGlyphMap();
        int numGlyphs = ci.getEndIndex() - ci.getBeginIndex();
        int[] glyphs = new int[numGlyphs];
        int glyph = 0;
        int c = ci.first();
        while (c != 65535) {
            if (c >> 10 == 54) {
                c = ((c & 0x3FF) << 10 | ci.next() & 0x3FF) + 65536;
            }
            glyphs[glyph] = cmap.getGlyph(c);
            ++glyph;
            c = ci.next();
        }
        if (glyph != numGlyphs) {
            int[] newGlyphs = new int[glyph];
            System.arraycopy(glyphs, 0, newGlyphs, 0, glyph);
            glyphs = newGlyphs;
        }
        return new GNUGlyphVector(this, font, frc, glyphs);
    }

    public int getGlyphIndex(int c) {
        return this.getCharGlyphMap().getGlyph(c);
    }

    public synchronized void getAdvance(int glyphIndex, float pointSize, AffineTransform transform, boolean antialias, boolean fractionalMetrics, boolean horizontal, Point2D advance) {
        this.scaler.getAdvance(glyphIndex, pointSize, transform, antialias, fractionalMetrics, horizontal, advance);
    }

    public synchronized GeneralPath getGlyphOutline(int glyph, float pointSize, AffineTransform transform, boolean antialias, boolean fractionalMetrics, int flags) {
        this.checkHinter(flags);
        return this.scaler.getOutline(glyph, pointSize, transform, antialias, fractionalMetrics, this.hinter, flags);
    }

    public synchronized Zone getRawGlyphOutline(int glyph, AffineTransform transform) {
        return this.scaler.getRawOutline(glyph, transform);
    }

    public synchronized String getGlyphName(int glyphIndex) {
        if (this.glyphNamer == null) {
            this.glyphNamer = GlyphNamer.forTables(this.numGlyphs, this.getFontTable(1886352244), this.getFontTable(1516335206));
        }
        return this.glyphNamer.getGlyphName(glyphIndex);
    }

    public synchronized float getAscent(float pointSize, AffineTransform transform, boolean antialiased, boolean fractionalMetrics, boolean horizontal) {
        return this.scaler.getAscent(pointSize, transform, antialiased, fractionalMetrics, horizontal);
    }

    public synchronized float getDescent(float pointSize, AffineTransform transform, boolean antialiased, boolean fractionalMetrics, boolean horizontal) {
        return this.scaler.getDescent(pointSize, transform, antialiased, fractionalMetrics, horizontal);
    }

    static String tagToString(int tag) {
        char[] c = new char[]{(char)(tag >> 24 & 0xFF), (char)(tag >> 16 & 0xFF), (char)(tag >> 8 & 0xFF), (char)(tag & 0xFF)};
        return new String(c);
    }

    private void checkHinter(int flags) {
        if (this.hinter == null) {
            try {
                this.hinter = new AutoHinter();
                this.hinter.init(this);
            }
            catch (Exception ex) {
                this.hinter = null;
                ex.printStackTrace();
            }
        }
        this.hinter.setFlags(flags);
    }
}

