/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.classpath.SystemProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ViewportUI;

public class JViewport
extends JComponent
implements Accessible {
    public static final int SIMPLE_SCROLL_MODE = 0;
    public static final int BLIT_SCROLL_MODE = 1;
    public static final int BACKINGSTORE_SCROLL_MODE = 2;
    private static final long serialVersionUID = -6925142919680527970L;
    private static final int defaultScrollMode;
    protected boolean scrollUnderway;
    protected boolean isViewSizeSet;
    protected boolean backingStore;
    protected Image backingStoreImage;
    protected Point lastPaintPosition;
    ChangeEvent changeEvent = new ChangeEvent(this);
    int scrollMode;
    ViewListener viewListener;
    Point cachedBlitFrom;
    Point cachedBlitTo;
    Dimension cachedBlitSize;
    Rectangle cachedBlitPaint;
    boolean damaged = true;
    boolean sizeChanged = true;
    private boolean isPaintRoot = false;

    static {
        String scrollModeProp = SystemProperties.getProperty("gnu.swing.scrollmode", "BACKINGSTORE");
        defaultScrollMode = scrollModeProp.equalsIgnoreCase("simple") ? 0 : (scrollModeProp.equalsIgnoreCase("backingstore") ? 2 : 1);
    }

    public JViewport() {
        this.setOpaque(true);
        this.setScrollMode(defaultScrollMode);
        this.updateUI();
        this.setLayout(this.createLayoutManager());
        this.lastPaintPosition = new Point();
        this.cachedBlitFrom = new Point();
        this.cachedBlitTo = new Point();
        this.cachedBlitSize = new Dimension();
        this.cachedBlitPaint = new Rectangle();
    }

    public Dimension getExtentSize() {
        return this.getSize();
    }

    public Dimension toViewCoordinates(Dimension size) {
        return size;
    }

    public Point toViewCoordinates(Point p) {
        Point pos = this.getViewPosition();
        return new Point(p.x + pos.x, p.y + pos.y);
    }

    public void setExtentSize(Dimension newSize) {
        Dimension oldExtent = this.getExtentSize();
        if (!newSize.equals(oldExtent)) {
            this.setSize(newSize);
            this.fireStateChanged();
        }
    }

    public Dimension getViewSize() {
        Component view = this.getView();
        Dimension size = view != null ? (this.isViewSizeSet ? view.getSize() : view.getPreferredSize()) : new Dimension(0, 0);
        return size;
    }

    public void setViewSize(Dimension newSize) {
        Component view = this.getView();
        if (view != null && !newSize.equals(view.getSize())) {
            this.scrollUnderway = false;
            view.setSize(newSize);
            this.isViewSizeSet = true;
            this.fireStateChanged();
        }
    }

    public Point getViewPosition() {
        Component view = this.getView();
        if (view == null) {
            return new Point(0, 0);
        }
        Point p = view.getLocation();
        p.x = -p.x;
        p.y = -p.y;
        return p;
    }

    public void setViewPosition(Point p) {
        Component view = this.getView();
        if (view != null && !p.equals(this.getViewPosition())) {
            this.scrollUnderway = true;
            view.setLocation(-p.x, -p.y);
            this.fireStateChanged();
        }
    }

    public Rectangle getViewRect() {
        return new Rectangle(this.getViewPosition(), this.getExtentSize());
    }

    public boolean isBackingStoreEnabled() {
        return this.scrollMode == 2;
    }

    public void setBackingStoreEnabled(boolean b) {
        if (b && this.scrollMode != 2) {
            this.scrollMode = 2;
            this.fireStateChanged();
        }
    }

    public void setScrollMode(int mode) {
        this.scrollMode = mode;
        this.fireStateChanged();
    }

    public int getScrollMode() {
        return this.scrollMode;
    }

    public Component getView() {
        if (this.getComponentCount() == 0) {
            return null;
        }
        return this.getComponents()[0];
    }

    public void setView(Component v) {
        Component currView = this.getView();
        if (this.viewListener != null && currView != null) {
            currView.removeComponentListener(this.viewListener);
        }
        if (v != null) {
            if (this.viewListener == null) {
                this.viewListener = this.createViewListener();
            }
            v.addComponentListener(this.viewListener);
            this.add(v);
            this.fireStateChanged();
        }
        this.revalidate();
        this.repaint();
    }

    public void reshape(int x, int y, int w, int h) {
        if (w != this.getWidth() || h != this.getHeight()) {
            this.sizeChanged = true;
        }
        super.reshape(x, y, w, h);
        if (this.sizeChanged) {
            this.damaged = true;
            this.fireStateChanged();
        }
    }

    public final Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public final Insets getInsets(Insets insets) {
        if (insets == null) {
            return this.getInsets();
        }
        insets.top = 0;
        insets.bottom = 0;
        insets.left = 0;
        insets.right = 0;
        return insets;
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void paint(Graphics g) {
        Component view = this.getView();
        if (view == null) {
            return;
        }
        Rectangle viewBounds = view.getBounds();
        Rectangle portBounds = this.getBounds();
        if (viewBounds.width == 0 || viewBounds.height == 0 || portBounds.width == 0 || portBounds.height == 0) {
            return;
        }
        switch (this.getScrollMode()) {
            case 2: {
                this.paintBackingStore(g);
                break;
            }
            case 1: {
                this.paintBlit(g);
                break;
            }
            default: {
                this.paintSimple(g);
            }
        }
        this.damaged = false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(ChangeListener.class);
    }

    public String getUIClassID() {
        return "ViewportUI";
    }

    public void updateUI() {
        this.setUI((ViewportUI)UIManager.getUI(this));
    }

    public ViewportUI getUI() {
        return (ViewportUI)this.ui;
    }

    public void setUI(ViewportUI ui) {
        super.setUI(ui);
    }

    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException();
        }
    }

    public void scrollRectToVisible(Rectangle contentRect) {
        Component view = this.getView();
        if (view == null) {
            return;
        }
        Point pos = this.getViewPosition();
        int contentX = contentRect.x + pos.x;
        int contentY = contentRect.y + pos.y;
        Rectangle viewBounds = this.getView().getBounds();
        Rectangle portBounds = this.getBounds();
        if (this.isShowing()) {
            this.getView().validate();
        }
        if (contentY + contentRect.height + viewBounds.y > portBounds.height) {
            pos.y = contentY + contentRect.height - portBounds.height;
        }
        if (contentY + viewBounds.y < 0) {
            pos.y = contentY;
        }
        if (contentX + contentRect.width + viewBounds.x > portBounds.width) {
            pos.x = contentX + contentRect.width - portBounds.width;
        }
        if (contentX + viewBounds.x < 0) {
            pos.x = contentX;
        }
        this.setViewPosition(pos);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJViewport();
        }
        return this.accessibleContext;
    }

    public void repaint(long tm, int x, int y, int w, int h) {
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint(tm, x + this.getX(), y + this.getY(), w, h);
        } else {
            super.repaint(tm, x, y, w, h);
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.getComponentCount() > 0) {
            this.remove(this.getComponents()[0]);
        }
        super.addImpl(comp, constraints, index);
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(this.changeEvent);
            ++i;
        }
    }

    protected ViewListener createViewListener() {
        return new ViewListener();
    }

    protected LayoutManager createLayoutManager() {
        return new ViewportLayout();
    }

    protected boolean computeBlit(int dx, int dy, Point blitFrom, Point blitTo, Dimension blitSize, Rectangle blitPaint) {
        if (dx != 0 && dy != 0 || dy == 0 && dy == 0 || this.damaged) {
            return false;
        }
        Rectangle portBounds = SwingUtilities.calculateInnerArea(this, this.getBounds());
        blitFrom.x = portBounds.x;
        blitFrom.y = portBounds.y;
        blitTo.x = portBounds.x;
        blitTo.y = portBounds.y;
        if (dy > 0) {
            blitFrom.y = portBounds.y + dy;
        } else if (dy < 0) {
            blitTo.y = portBounds.y - dy;
        } else if (dx > 0) {
            blitFrom.x = portBounds.x + dx;
        } else if (dx < 0) {
            blitTo.x = portBounds.x - dx;
        }
        if (dx != 0) {
            blitSize.width = portBounds.width - Math.abs(dx);
            blitSize.height = portBounds.height;
        } else if (dy != 0) {
            blitSize.width = portBounds.width;
            blitSize.height = portBounds.height - Math.abs(dy);
        }
        blitPaint.setBounds(portBounds);
        if (dy > 0) {
            blitPaint.y = portBounds.y + portBounds.height - dy;
            blitPaint.height = dy;
        } else if (dy < 0) {
            blitPaint.height = -dy;
        }
        if (dx > 0) {
            blitPaint.x = portBounds.x + portBounds.width - dx;
            blitPaint.width = dx;
        } else if (dx < 0) {
            blitPaint.width = -dx;
        }
        return true;
    }

    void paintSimple(Graphics g) {
        this.paintComponent(g);
        Point pos = this.getViewPosition();
        Component view = this.getView();
        Shape oldClip = g.getClip();
        g.clipRect(0, 0, this.getWidth(), this.getHeight());
        boolean translated = false;
        try {
            g.translate(-pos.x, -pos.y);
            translated = true;
            view.paint(g);
        }
        finally {
            if (translated) {
                g.translate(pos.x, pos.y);
            }
            g.setClip(oldClip);
        }
    }

    void paintBackingStore(Graphics g) {
        if (this.backingStoreImage == null || this.sizeChanged) {
            this.backingStoreImage = this.createImage(this.getWidth(), this.getHeight());
            this.sizeChanged = false;
            Graphics g2 = this.backingStoreImage.getGraphics();
            this.paintSimple(g2);
            g2.dispose();
        } else {
            Graphics g2 = this.backingStoreImage.getGraphics();
            Point viewPosition = this.getViewPosition();
            int dx = viewPosition.x - this.lastPaintPosition.x;
            int dy = viewPosition.y - this.lastPaintPosition.y;
            boolean canBlit = this.computeBlit(dx, dy, this.cachedBlitFrom, this.cachedBlitTo, this.cachedBlitSize, this.cachedBlitPaint);
            if (canBlit && this.isPaintRoot) {
                if (this.cachedBlitSize.width > 0 && this.cachedBlitSize.height > 0) {
                    g2.copyArea(this.cachedBlitFrom.x, this.cachedBlitFrom.y, this.cachedBlitSize.width, this.cachedBlitSize.height, this.cachedBlitTo.x - this.cachedBlitFrom.x, this.cachedBlitTo.y - this.cachedBlitFrom.y);
                }
                g2.setClip(this.cachedBlitPaint.x, this.cachedBlitPaint.y, this.cachedBlitPaint.width, this.cachedBlitPaint.height);
                this.paintSimple(g2);
            } else {
                if (dx == 0 && dy == 0) {
                    g2.setClip(g.getClip());
                }
                this.paintSimple(g2);
            }
            g2.dispose();
        }
        g.drawImage(this.backingStoreImage, 0, 0, this);
        this.lastPaintPosition.setLocation(this.getViewPosition());
    }

    void paintBlit(Graphics g) {
        Point viewPosition = this.getViewPosition();
        int dx = viewPosition.x - this.lastPaintPosition.x;
        int dy = viewPosition.y - this.lastPaintPosition.y;
        boolean canBlit = this.computeBlit(dx, dy, this.cachedBlitFrom, this.cachedBlitTo, this.cachedBlitSize, this.cachedBlitPaint);
        if (canBlit && this.isPaintRoot) {
            if (this.cachedBlitSize.width > 0 && this.cachedBlitSize.width > 0) {
                g.copyArea(this.cachedBlitFrom.x, this.cachedBlitFrom.y, this.cachedBlitSize.width, this.cachedBlitSize.height, this.cachedBlitTo.x - this.cachedBlitFrom.x, this.cachedBlitTo.y - this.cachedBlitFrom.y);
            }
            Shape oldClip = g.getClip();
            g.clipRect(this.cachedBlitPaint.x, this.cachedBlitPaint.y, this.cachedBlitPaint.width, this.cachedBlitPaint.height);
            try {
                this.paintSimple(g);
            }
            finally {
                g.setClip(oldClip);
            }
        } else {
            this.paintSimple(g);
        }
        this.lastPaintPosition.setLocation(this.getViewPosition());
    }

    void paintImmediately2(int x, int y, int w, int h) {
        this.isPaintRoot = true;
        super.paintImmediately2(x, y, w, h);
        this.isPaintRoot = false;
    }

    boolean isPaintRoot() {
        return this.scrollMode == 2;
    }

    protected class AccessibleJViewport
    extends JComponent.AccessibleJComponent {
        protected AccessibleJViewport() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.VIEWPORT;
        }
    }

    protected class ViewListener
    extends ComponentAdapter
    implements Serializable {
        private static final long serialVersionUID = -2812489404285958070L;

        protected ViewListener() {
        }

        public void componentResized(ComponentEvent ev) {
            JViewport.this.fireStateChanged();
            JViewport.this.revalidate();
        }
    }
}

