/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    private static final long serialVersionUID = 6580012493508960512L;
    protected Vector<TableColumn> tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;

    public DefaultTableColumnModel() {
        this.tableColumns = new Vector();
        this.selectionModel = this.createSelectionModel();
        this.selectionModel.addListSelectionListener(this);
        this.columnMargin = 1;
        this.columnSelectionAllowed = false;
    }

    @Override
    public void addColumn(TableColumn column) {
        if (column == null) {
            throw new IllegalArgumentException("Null 'col' argument.");
        }
        this.tableColumns.add(column);
        column.addPropertyChangeListener(this);
        this.invalidateWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.tableColumns.size() - 1));
    }

    @Override
    public void removeColumn(TableColumn column) {
        int index = this.tableColumns.indexOf(column);
        if (index < 0) {
            return;
        }
        this.tableColumns.remove(column);
        this.fireColumnRemoved(new TableColumnModelEvent(this, index, 0));
        column.removePropertyChangeListener(this);
        this.invalidateWidthCache();
    }

    @Override
    public void moveColumn(int i, int j) {
        int columnCount = this.getColumnCount();
        if (i < 0 || i >= columnCount) {
            throw new IllegalArgumentException("Index 'i' out of range.");
        }
        if (j < 0 || j >= columnCount) {
            throw new IllegalArgumentException("Index 'j' out of range.");
        }
        TableColumn column = this.tableColumns.remove(i);
        this.tableColumns.add(j, column);
        this.fireColumnMoved(new TableColumnModelEvent(this, i, j));
    }

    @Override
    public void setColumnMargin(int margin) {
        this.columnMargin = margin;
        this.fireColumnMarginChanged();
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return this.tableColumns.elements();
    }

    @Override
    public int getColumnIndex(Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Null identifier.");
        }
        int columnCount = this.tableColumns.size();
        int i = 0;
        while (i < columnCount) {
            TableColumn tc = this.tableColumns.get(i);
            if (identifier.equals(tc.getIdentifier())) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("No TableColumn with that identifier.");
    }

    @Override
    public TableColumn getColumn(int columnIndex) {
        return this.tableColumns.get(columnIndex);
    }

    @Override
    public int getColumnMargin() {
        return this.columnMargin;
    }

    @Override
    public int getColumnIndexAtX(int x) {
        int i = 0;
        while (i < this.tableColumns.size()) {
            int w = this.tableColumns.get(i).getWidth();
            if (x >= 0 && x < w) {
                return i;
            }
            x -= w;
            ++i;
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    @Override
    public void setSelectionModel(ListSelectionModel model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this.selectionModel.removeListSelectionListener(this);
        this.selectionModel = model;
        this.selectionModel.addListSelectionListener(this);
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void setColumnSelectionAllowed(boolean flag) {
        this.columnSelectionAllowed = flag;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    @Override
    public int[] getSelectedColumns() {
        ListSelectionModel lsm = this.selectionModel;
        int sz = this.getSelectedColumnCount();
        int[] ret = new int[sz];
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int j = 0;
        new ArrayList();
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    ret[0] = lo;
                    break;
                }
                case 1: {
                    int i = lo;
                    while (i <= hi) {
                        ret[j++] = i++;
                    }
                    break;
                }
                case 2: {
                    int i = lo;
                    while (i <= hi) {
                        if (lsm.isSelectedIndex(i)) {
                            ret[j++] = i;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return ret;
    }

    @Override
    public int getSelectedColumnCount() {
        ListSelectionModel lsm = this.selectionModel;
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int sum = 0;
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    sum = 1;
                    break;
                }
                case 1: {
                    sum = hi - lo + 1;
                    break;
                }
                case 2: {
                    int i = lo;
                    while (i <= hi) {
                        if (lsm.isSelectedIndex(i)) {
                            ++sum;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return sum;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener listener) {
        this.listenerList.add(TableColumnModelListener.class, listener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener listener) {
        this.listenerList.remove(TableColumnModelListener.class, listener);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        return (TableColumnModelListener[])this.listenerList.getListeners(TableColumnModelListener.class);
    }

    protected void fireColumnAdded(TableColumnModelEvent e) {
        TableColumnModelListener[] listeners = this.getColumnModelListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].columnAdded(e);
            ++i;
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent e) {
        TableColumnModelListener[] listeners = this.getColumnModelListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].columnRemoved(e);
            ++i;
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent e) {
        TableColumnModelListener[] listeners = this.getColumnModelListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].columnMoved(e);
            ++i;
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent e) {
        EventListener[] listeners = this.getListeners(TableColumnModelListener.class);
        int i = 0;
        while (i < listeners.length) {
            ((TableColumnModelListener)listeners[i]).columnSelectionChanged(e);
            ++i;
        }
    }

    protected void fireColumnMarginChanged() {
        EventListener[] listeners = this.getListeners(TableColumnModelListener.class);
        if (this.changeEvent == null && listeners.length > 0) {
            this.changeEvent = new ChangeEvent(this);
        }
        int i = 0;
        while (i < listeners.length) {
            ((TableColumnModelListener)listeners[i]).columnMarginChanged(this.changeEvent);
            ++i;
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("width")) {
            this.invalidateWidthCache();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.fireColumnSelectionChanged(e);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void recalcWidthCache() {
        if (this.totalColumnWidth == -1) {
            this.totalColumnWidth = 0;
            int i = 0;
            while (i < this.tableColumns.size()) {
                this.totalColumnWidth += this.tableColumns.get(i).getWidth();
                ++i;
            }
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }
}

