/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.Serializable;

public class ContainerOrderFocusTraversalPolicy
extends FocusTraversalPolicy
implements Serializable {
    static final long serialVersionUID = 486933713763926351L;
    private boolean implicitDownCycleTraversal = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentAfter(Container root, Component current) {
        Container ancestor;
        if (root == null) {
            throw new IllegalArgumentException("focus cycle root is null");
        }
        if (current == null) {
            throw new IllegalArgumentException("current component is null");
        }
        if (!root.isFocusCycleRoot()) {
            throw new IllegalArgumentException("root is not a focus cycle root");
        }
        Container prevAncestor = ancestor = current.getFocusCycleRootAncestor();
        while (ancestor != root) {
            ancestor = current.getFocusCycleRootAncestor();
            if (ancestor == prevAncestor) {
                if (ancestor == null) {
                    ancestor = root;
                } else {
                    if (ancestor == root) break;
                    throw new IllegalArgumentException("the given container is not a focus cycle root of the current component");
                }
            }
            prevAncestor = ancestor;
        }
        if (root == current) {
            root = current.getFocusCycleRootAncestor();
        }
        if (current instanceof Window) {
            return this.getFirstComponent((Container)current);
        }
        Container parent = current.getParent();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[] components = parent.getComponents();
            int componentIndex = 0;
            int numComponents = parent.getComponentCount();
            int i = 0;
            while (i < numComponents) {
                if (components[i].equals(current)) {
                    componentIndex = i;
                }
                ++i;
            }
            i = componentIndex + 1;
            int end = numComponents - 1;
            Component next = this.getNextAvailableComponent(components, i, end);
            if (next != null) {
                return next;
            }
            i = 0;
            end = componentIndex;
            next = this.getNextAvailableComponent(components, i, end);
            if (next != null) {
                return next;
            }
            Component result = this.getComponentAfter(root, parent);
            return result;
        }
    }

    private Component getNextAvailableComponent(Component[] components, int start, int end) {
        while (start <= end) {
            Component result;
            Component c = components[start];
            if (c.visible && c.isDisplayable() && c.enabled && c.focusable) {
                return c;
            }
            if (c instanceof Container && (result = this.getFirstComponent((Container)c)) != null && this.implicitDownCycleTraversal && result.visible && result.isDisplayable() && result.enabled && result.focusable) {
                return result;
            }
            ++start;
        }
        return null;
    }

    Component getPrevAvailableComponent(Component[] components, int start, int end) {
        while (start >= end) {
            Component result;
            Component c = components[start];
            if (c.visible && c.isDisplayable() && c.enabled && c.focusable) {
                return c;
            }
            if (c instanceof Container && (result = this.getLastComponent((Container)c)) != null && result.visible && result.isDisplayable() && result.enabled && result.focusable) {
                return result;
            }
            --start;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentBefore(Container root, Component current) {
        Container ancestor;
        if (root == null) {
            throw new IllegalArgumentException("focus cycle root is null");
        }
        if (current == null) {
            throw new IllegalArgumentException("current component is null");
        }
        if (!root.isFocusCycleRoot()) {
            throw new IllegalArgumentException("root is not a focus cycle root");
        }
        Container prevAncestor = ancestor = current.getFocusCycleRootAncestor();
        while (ancestor != root) {
            ancestor = current.getFocusCycleRootAncestor();
            if (ancestor == prevAncestor) {
                if (ancestor == null) {
                    ancestor = root;
                } else {
                    if (ancestor == root) break;
                    throw new IllegalArgumentException("the given container is not a focus cycle root of the current component");
                }
            }
            prevAncestor = ancestor;
        }
        if (root == current) {
            root = current.getFocusCycleRootAncestor();
        }
        if (current instanceof Window) {
            return this.getLastComponent((Container)current);
        }
        Container parent = current.getParent();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[] components = parent.getComponents();
            int componentIndex = 0;
            int numComponents = parent.getComponentCount();
            int i = 0;
            while (i < numComponents) {
                if (components[i] == current) {
                    componentIndex = i;
                }
                ++i;
            }
            i = componentIndex - 1;
            int end = 0;
            Component prev = this.getPrevAvailableComponent(components, i, end);
            if (prev != null) {
                return prev;
            }
            i = numComponents - 1;
            end = componentIndex;
            prev = this.getPrevAvailableComponent(components, i, end);
            if (prev != null) {
                return prev;
            }
            Component result = this.getComponentBefore(root, parent);
            return result;
        }
    }

    public Component getFirstComponent(Container root) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        if (!root.isVisible() || !root.isDisplayable()) {
            return null;
        }
        if (this.accept(root)) {
            return root;
        }
        int ncomponents = root.getComponentCount();
        int i = 0;
        while (i < ncomponents) {
            Component component = root.getComponent(i);
            if (component instanceof Container && !((Container)component).isFocusCycleRoot()) {
                Component first = null;
                Container cont = (Container)component;
                if (cont.isFocusTraversalPolicyProvider()) {
                    FocusTraversalPolicy childPol = cont.getFocusTraversalPolicy();
                    first = childPol.getFirstComponent(cont);
                } else {
                    first = this.getFirstComponent(cont);
                }
                if (first != null) {
                    return first;
                }
            } else if (this.accept(component)) {
                return component;
            }
            ++i;
        }
        return null;
    }

    public Component getLastComponent(Container root) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        if (!root.isVisible() || !root.isDisplayable()) {
            return null;
        }
        if (root.visible && root.isDisplayable() && root.enabled && root.focusable) {
            return root;
        }
        Component[] componentArray = root.getComponents();
        int i = componentArray.length - 1;
        while (i >= 0) {
            Component result;
            Component component = componentArray[i];
            if (component.visible && component.isDisplayable() && component.enabled && component.focusable) {
                return component;
            }
            if (component instanceof Container && (result = this.getLastComponent((Container)component)) != null && result.visible && result.isDisplayable() && result.enabled && result.focusable) {
                return result;
            }
            --i;
        }
        return null;
    }

    public Component getDefaultComponent(Container root) {
        return this.getFirstComponent(root);
    }

    public void setImplicitDownCycleTraversal(boolean value) {
        this.implicitDownCycleTraversal = value;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected boolean accept(Component current) {
        return current.visible && current.isDisplayable() && current.enabled && current.focusable;
    }
}

