/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import gnu.java.lang.CPStringBuilder;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.font.TextHitInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;

public class InputMethodEvent
extends AWTEvent {
    private static final long serialVersionUID = 4727190874778922661L;
    public static final int INPUT_METHOD_FIRST = 1100;
    public static final int INPUT_METHOD_TEXT_CHANGED = 1100;
    public static final int CARET_POSITION_CHANGED = 1101;
    public static final int INPUT_METHOD_LAST = 1101;
    private long when;
    private final transient AttributedCharacterIterator text;
    private final transient int committedCharacterCount;
    private final transient TextHitInfo caret;
    private final transient TextHitInfo visiblePosition;

    public InputMethodEvent(Component source, int id, long when, AttributedCharacterIterator text, int committedCharacterCount, TextHitInfo caret, TextHitInfo visiblePosition) {
        super(source, id);
        this.when = when;
        this.text = text;
        this.committedCharacterCount = committedCharacterCount;
        this.caret = caret;
        this.visiblePosition = visiblePosition;
        if (id < 1100 || id > 1101 || id == 1101 && text != null || committedCharacterCount < 0 || committedCharacterCount > (text == null ? 0 : text.getEndIndex() - text.getBeginIndex())) {
            throw new IllegalArgumentException();
        }
    }

    public InputMethodEvent(Component source, int id, AttributedCharacterIterator text, int committedCharacterCount, TextHitInfo caret, TextHitInfo visiblePosition) {
        this(source, id, EventQueue.getMostRecentEventTime(), text, committedCharacterCount, caret, visiblePosition);
    }

    public InputMethodEvent(Component source, int id, TextHitInfo caret, TextHitInfo visiblePosition) {
        this(source, id, EventQueue.getMostRecentEventTime(), null, 0, caret, visiblePosition);
    }

    public AttributedCharacterIterator getText() {
        return this.text;
    }

    public int getCommittedCharacterCount() {
        return this.committedCharacterCount;
    }

    public TextHitInfo getCaret() {
        return this.caret;
    }

    public TextHitInfo getVisiblePosition() {
        return this.visiblePosition;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public long getWhen() {
        return this.when;
    }

    public String paramString() {
        CPStringBuilder s = new CPStringBuilder(80 + (this.text == null ? 0 : this.text.getEndIndex() - this.text.getBeginIndex()));
        s.append(this.id == 1100 ? "INPUT_METHOD_TEXT_CHANGED, " : "CARET_POSITION_CHANGED, ");
        if (this.text == null) {
            s.append("no text, 0 characters committed, caret: ");
        } else {
            s.append('\"');
            int i = this.text.getBeginIndex();
            int j = this.committedCharacterCount;
            while (--j >= 0) {
                s.append(this.text.setIndex(i++));
            }
            s.append("\" + \"");
            j = this.text.getEndIndex() - i;
            while (--j >= 0) {
                s.append(this.text.setIndex(i++));
            }
            s.append("\", ").append(this.committedCharacterCount).append(" characters committed, caret: ");
        }
        s.append(this.caret == null ? "no caret" : this.caret).append(", ").append(this.visiblePosition == null ? "no visible position" : this.visiblePosition);
        return s.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.when == 0L) {
            this.when = EventQueue.getMostRecentEventTime();
        }
    }
}

