/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class GrayFilter
extends RGBImageFilter {
    private boolean b;
    private double p;

    public GrayFilter(boolean b, int p) {
        this.b = b;
        this.p = (1.0 - (double)p / 100.0) / 3.0;
    }

    public static Image createDisabledImage(Image src) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(src.getSource(), new GrayFilter(true, 0)));
    }

    public int filterRGB(int x, int y, int rgb) {
        int alpha = 0xFF000000 & rgb;
        int red = (0xFF0000 & rgb) >> 16;
        int green = (0xFF00 & rgb) >> 8;
        int blue = 0xFF & rgb;
        int gray = (int)((0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue) * this.p);
        if (this.b) {
            gray = Math.min(gray + 128, 255);
        }
        return gray | gray << 8 | gray << 16 | alpha;
    }
}

