/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JToggleButton
extends AbstractButton
implements Accessible {
    private static final long serialVersionUID = -3128248873429850443L;

    public JToggleButton() {
        this(null, null, false);
    }

    public JToggleButton(Action a) {
        this();
        this.setAction(a);
    }

    public JToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public JToggleButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public JToggleButton(String text) {
        this(text, null, false);
    }

    public JToggleButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public JToggleButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public JToggleButton(String text, Icon icon, boolean selected) {
        this.setModel(new ToggleButtonModel());
        this.init(text, icon);
        this.model.setSelected(selected);
        this.setAlignmentX(0.0f);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    public String getUIClassID() {
        return "ToggleButtonUI";
    }

    protected String paramString() {
        return super.paramString();
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton
    implements ItemListener {
        private static final long serialVersionUID = -8652952712161229225L;

        public AccessibleJToggleButton() {
            JToggleButton.this.addItemListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }

        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                this.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
            }
        }
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        private static final long serialVersionUID = -1589950750899943974L;

        public void setPressed(boolean p) {
            if (!this.isEnabled()) {
                return;
            }
            if (p && this.isPressed() || !p && !this.isPressed()) {
                return;
            }
            if (!p && this.isArmed()) {
                this.setSelected(!this.isSelected());
            }
            this.stateMask = p ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!p && this.isArmed()) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
        }

        public boolean isSelected() {
            return super.isSelected();
        }

        public void setSelected(boolean b) {
            super.setSelected(b);
        }
    }
}

