/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Image;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParseException;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.rmi.Remote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFlavor
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 8367026044764648243L;
    public static final DataFlavor plainTextFlavor = new DataFlavor("text/plain; charset=unicode; class=java.io.InputStream", "plain unicode text");
    public static final DataFlavor stringFlavor = new DataFlavor(String.class, "Java Unicode String");
    public static final DataFlavor javaFileListFlavor = new DataFlavor("application/x-java-file-list; class=java.util.List", "Java File List");
    public static final DataFlavor imageFlavor = new DataFlavor(Image.class, "Java Image");
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    private MimeType mimeType;
    private Class<?> representationClass;
    private String humanPresentableName;

    protected static final Class<?> tryToLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                return Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(className, true, loader);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    if (classLoader != null) {
                        return Class.forName(className, true, classLoader);
                    }
                    throw new ClassNotFoundException(className);
                }
            }
        }
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        return plainTextFlavor;
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] availableFlavors) {
        int i = 0;
        while (i < availableFlavors.length) {
            DataFlavor df = availableFlavors[i];
            Class<?> c = df.representationClass;
            if (Reader.class.isAssignableFrom(c) || String.class.isAssignableFrom(c)) {
                return df;
            }
            if (InputStream.class.isAssignableFrom(c) && "text".equals(df.getPrimaryType())) {
                String encoding = availableFlavors[i].getParameter("charset");
                if (encoding == null) {
                    encoding = "us-ascii";
                }
                InputStreamReader r = null;
                try {
                    r = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                if (r != null) {
                    return df;
                }
            }
            ++i;
        }
        return null;
    }

    public DataFlavor() {
    }

    public DataFlavor(Class<?> representationClass, String humanPresentableName) {
        block4: {
            if (representationClass == null) {
                throw new NullPointerException("representationClass must not be null");
            }
            try {
                this.mimeType = new MimeType(javaSerializedObjectMimeType);
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        if (humanPresentableName == null) {
            humanPresentableName = javaSerializedObjectMimeType;
        }
        this.humanPresentableName = humanPresentableName;
        this.representationClass = representationClass;
    }

    public DataFlavor(String mimeType, String humanPresentableName, ClassLoader classLoader) throws ClassNotFoundException {
        this.init(mimeType, humanPresentableName, classLoader);
    }

    public DataFlavor(String mimeType, String humanPresentableName) {
        try {
            this.init(mimeType, humanPresentableName, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            IllegalArgumentException iae = new IllegalArgumentException("Class not found: " + ex.getMessage());
            iae.initCause(ex);
            throw iae;
        }
    }

    public DataFlavor(String mimeType) throws ClassNotFoundException {
        this.init(mimeType, null, this.getClass().getClassLoader());
    }

    private void init(String mime, String humanPresentableName, ClassLoader loader) throws ClassNotFoundException {
        if (mime == null) {
            throw new NullPointerException("The mime type must not be null");
        }
        try {
            this.mimeType = new MimeType(mime);
        }
        catch (MimeTypeParseException ex) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid mime type");
            iae.initCause(ex);
            throw iae;
        }
        String className = this.mimeType.getParameter("class");
        if (className == null) {
            if (this.mimeType.getBaseType().equals(javaSerializedObjectMimeType)) {
                throw new IllegalArgumentException("Serialized object type must have a representation class parameter");
            }
            this.representationClass = InputStream.class;
        } else {
            this.representationClass = DataFlavor.tryToLoadClass(className, loader);
        }
        this.mimeType.addParameter("class", this.representationClass.getName());
        if (humanPresentableName == null && (humanPresentableName = this.mimeType.getParameter("humanPresentableName")) == null) {
            humanPresentableName = this.mimeType.getBaseType();
        }
        this.humanPresentableName = humanPresentableName;
    }

    public String getMimeType() {
        return this.mimeType.toString();
    }

    public Class<?> getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        return this.mimeType.getPrimaryType();
    }

    public String getSubType() {
        return this.mimeType.getSubType();
    }

    public String getParameter(String paramName) {
        if ("humanPresentableName".equals(paramName)) {
            return this.getHumanPresentableName();
        }
        return this.mimeType.getParameter(paramName);
    }

    public void setHumanPresentableName(String humanPresentableName) {
        this.humanPresentableName = humanPresentableName;
    }

    public boolean isMimeTypeEqual(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("mimeType must not be null");
        }
        boolean equal = false;
        try {
            if (this.mimeType != null) {
                MimeType other = new MimeType(mimeType);
                equal = this.mimeType.matches(other);
            }
        }
        catch (MimeTypeParseException mimeTypeParseException) {}
        return equal;
    }

    public final boolean isMimeTypeEqual(DataFlavor flavor) {
        return this.isMimeTypeEqual(flavor.getMimeType());
    }

    public boolean isMimeTypeSerializedObject() {
        return this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean isRepresentationClassInputStream() {
        return InputStream.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassSerializable() {
        return Serializable.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassRemote() {
        return Remote.class.isAssignableFrom(this.representationClass);
    }

    public boolean isFlavorSerializedObjectType() {
        return this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.isRepresentationClassRemote() && this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaRemoteObjectMimeType);
    }

    public boolean isFlavorJavaFileListType() {
        return this.getPrimaryType().equals(javaFileListFlavor.getPrimaryType()) && this.getSubType().equals(javaFileListFlavor.getSubType()) && DataFlavor.javaFileListFlavor.representationClass.isAssignableFrom(this.representationClass);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(DataFlavor flavor) {
        if (flavor == null) {
            return false;
        }
        String primary = this.getPrimaryType();
        if (!primary.equals(flavor.getPrimaryType())) {
            return false;
        }
        String sub = this.getSubType();
        if (!sub.equals(flavor.getSubType())) {
            return false;
        }
        if (!this.representationClass.equals(flavor.representationClass)) {
            return false;
        }
        if (!(!primary.equals("text") || this.isRepresentationClassCharBuffer() || this.isRepresentationClassReader() || this.representationClass == String.class || this.representationClass.isArray() && this.representationClass.getComponentType() == Character.TYPE)) {
            String charset = this.getParameter("charset");
            String otherset = flavor.getParameter("charset");
            String defaultset = Charset.defaultCharset().name();
            if (charset == null || charset.equals(defaultset)) {
                return otherset == null || otherset.equals(defaultset);
            }
            return charset.equals(otherset);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataFlavor)) {
            return false;
        }
        return this.equals((DataFlavor)obj);
    }

    public boolean equals(String str) {
        return this.isMimeTypeEqual(str);
    }

    public int hashCode() {
        return this.mimeType.toString().hashCode() ^ this.representationClass.hashCode();
    }

    public boolean match(DataFlavor dataFlavor) {
        return this.equals(dataFlavor);
    }

    protected String normalizeMimeTypeParameter(String name, String value) {
        return String.valueOf(name) + "=" + value;
    }

    protected String normalizeMimeType(String type) {
        return type;
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        if (this.mimeType != null) {
            this.mimeType.addParameter("humanPresentableName", this.humanPresentableName);
            stream.writeObject(this.mimeType);
            this.mimeType.removeParameter("humanPresentableName");
        } else {
            stream.writeObject(null);
        }
        stream.writeObject(this.representationClass);
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.mimeType = (MimeType)stream.readObject();
        String className = null;
        if (this.mimeType != null) {
            this.humanPresentableName = this.mimeType.getParameter("humanPresentableName");
            this.mimeType.removeParameter("humanPresentableName");
            className = this.mimeType.getParameter("class");
            if (className == null) {
                throw new IOException("No class in mime type");
            }
        }
        try {
            this.representationClass = (Class)stream.readObject();
        }
        catch (OptionalDataException ex) {
            if (ex.eof && ex.length == 0) {
                if (className != null) {
                    this.representationClass = DataFlavor.tryToLoadClass(className, this.getClass().getClassLoader());
                }
            }
            throw ex;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[representationClass=" + this.getRepresentationClass().getName() + ",mimeType=" + this.getMimeType() + ",humanPresentableName=" + this.getHumanPresentableName() + "]";
    }

    public final Class<?> getDefaultRepresentationClass() {
        return InputStream.class;
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (!transferable.isDataFlavorSupported(this)) {
            throw new UnsupportedFlavorException(this);
        }
        if (Reader.class.isAssignableFrom(this.representationClass)) {
            return (Reader)transferable.getTransferData(this);
        }
        if (String.class.isAssignableFrom(this.representationClass)) {
            return new StringReader((String)transferable.getTransferData(this));
        }
        if (InputStream.class.isAssignableFrom(this.representationClass) && "text".equals(this.getPrimaryType())) {
            InputStream in = (InputStream)transferable.getTransferData(this);
            String encoding = this.getParameter("charset");
            if (encoding == null) {
                encoding = "us-ascii";
            }
            return new InputStreamReader(in, encoding);
        }
        throw new UnsupportedFlavorException(this);
    }

    public boolean isRepresentationClassByteBuffer() {
        return ByteBuffer.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassCharBuffer() {
        return CharBuffer.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassReader() {
        return Reader.class.isAssignableFrom(this.representationClass);
    }

    public boolean isFlavorTextType() {
        if (this.equals(stringFlavor) || this.getPrimaryType().equals("text")) {
            String charset = this.getParameter("charset");
            Class<?> c = this.getRepresentationClass();
            if (charset != null) {
                if (Reader.class.isAssignableFrom(c) || CharBuffer.class.isAssignableFrom(c) || String.class.isAssignableFrom(c)) {
                    return true;
                }
                if (InputStream.class.isAssignableFrom(c) || ByteBuffer.class.isAssignableFrom(c)) {
                    return Charset.isSupported(charset);
                }
            } else if (InputStream.class.isAssignableFrom(c) || ByteBuffer.class.isAssignableFrom(c)) {
                return true;
            }
        }
        return false;
    }
}

