/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularType
extends OpenType<TabularData> {
    private static final long serialVersionUID = 6554071860220659261L;
    private CompositeType rowType;
    private List<String> indexNames;
    private transient Integer hashCode;
    private transient String string;

    public TabularType(String name, String desc, CompositeType rowType, String[] indexNames) throws OpenDataException {
        super(TabularData.class.getName(), name, desc);
        if (rowType == null) {
            throw new IllegalArgumentException("A null row type was given.");
        }
        int a = 0;
        while (a < indexNames.length) {
            if (indexNames[a] == null) {
                throw new IllegalArgumentException("Name " + a + " is null.");
            }
            if (indexNames[a].length() == 0) {
                throw new IllegalArgumentException("Name " + a + " is the empty string.");
            }
            if (!rowType.containsKey(indexNames[a])) {
                throw new OpenDataException("No matching key for " + indexNames[a] + " was found in " + "the supplied row type.");
            }
            ++a;
        }
        this.rowType = rowType;
        this.indexNames = Collections.unmodifiableList(Arrays.asList(indexNames));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TabularType)) {
            return false;
        }
        TabularType ttype = (TabularType)obj;
        return ttype.getTypeName().equals(this.getTypeName()) && ttype.getRowType().equals(this.getRowType()) && ttype.getIndexNames().equals(this.getIndexNames());
    }

    public List<String> getIndexNames() {
        return this.indexNames;
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            int elementTotal = 0;
            for (String s : this.indexNames) {
                elementTotal += s.hashCode();
            }
            this.hashCode = elementTotal + this.getTypeName().hashCode() + this.rowType.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj instanceof TabularData) {
            TabularData data = (TabularData)obj;
            return this.equals(data.getTabularType());
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = String.valueOf(this.getClass().getName()) + "[name=" + this.getTypeName() + ", rowType=" + this.rowType + ", indexNames=" + this.indexNames + "]";
        }
        return this.string;
    }
}

